/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import org.teavm.backend.wasm.generate.gc.WasmGCDeclarationsGenerator;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.runtime.StringInternPool;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WasmGCModuleGenerator {
    private WasmGCDeclarationsGenerator declarationsGenerator;

    public WasmGCModuleGenerator(WasmGCDeclarationsGenerator declarationsGenerator) {
        this.declarationsGenerator = declarationsGenerator;
    }

    public void generate() {
        this.declarationsGenerator.generate();
        this.createInitializer();
    }

    public WasmFunction generateReportGarbageCollectedStringFunction() {
        ValueType.Object entryType = ValueType.object(StringInternPool.class.getName() + "$Entry");
        return this.declarationsGenerator.functions().forStaticMethod(new MethodReference(StringInternPool.class.getName(), "remove", entryType, ValueType.VOID));
    }

    private void createInitializer() {
        WasmFunctionType functionType = this.declarationsGenerator.functionTypes.of(null, new WasmType[0]);
        WasmFunction initializer = new WasmFunction(functionType);
        initializer.setName("teavm@initializer");
        this.declarationsGenerator.module.functions.add(initializer);
        this.declarationsGenerator.module.setStartFunction(initializer);
        this.declarationsGenerator.contributeToInitializer(initializer);
    }
}

