/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.lowlevel.generate;

import org.teavm.model.ValueType;

public final class ClassGeneratorUtil {
    private ClassGeneratorUtil() {
    }

    public static int applyPrimitiveFlags(int flags, ValueType type) {
        flags = type instanceof ValueType.Primitive ? (flags |= ClassGeneratorUtil.getPrimitiveFlag((ValueType.Primitive)type) << 2) : (flags |= 0x20);
        return flags;
    }

    private static int getPrimitiveFlag(ValueType.Primitive type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return 0;
            }
            case BYTE: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case CHARACTER: {
                return 3;
            }
            case INTEGER: {
                return 4;
            }
            case LONG: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
        }
        throw new AssertionError();
    }
}

