/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.generate;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teavm.ast.ControlFlowEntry;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.decompilation.Decompiler;
import org.teavm.backend.c.generate.CallSiteGenerator;
import org.teavm.backend.c.generate.ClassGenerationContext;
import org.teavm.backend.c.generate.CodeGenerator;
import org.teavm.backend.c.generate.CodeGeneratorUtil;
import org.teavm.backend.c.generate.CodeWriter;
import org.teavm.backend.c.generate.GenerationContext;
import org.teavm.backend.c.generate.GeneratorContextImpl;
import org.teavm.backend.c.generate.IncludeManager;
import org.teavm.backend.c.generate.SimpleIncludeManager;
import org.teavm.backend.c.generate.StringPoolGenerator;
import org.teavm.backend.c.generators.Generator;
import org.teavm.backend.c.util.InteropUtil;
import org.teavm.backend.lowlevel.generate.ClassGeneratorUtil;
import org.teavm.cache.AstCacheEntry;
import org.teavm.cache.AstDependencyExtractor;
import org.teavm.cache.CacheStatus;
import org.teavm.cache.EmptyMethodNodeCache;
import org.teavm.cache.MethodNodeCache;
import org.teavm.interop.Address;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.NoGcRoot;
import org.teavm.interop.Structure;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.ClassMetadataRequirements;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.classes.VirtualTable;
import org.teavm.model.classes.VirtualTableEntry;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.Characteristics;
import org.teavm.model.util.ReflectionUtil;
import org.teavm.runtime.CallSite;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;
import org.teavm.runtime.RuntimeReference;
import org.teavm.runtime.RuntimeReferenceQueue;

public class ClassGenerator {
    private static final Set<String> classesWithDeclaredStructures = new HashSet<String>(Arrays.asList("java.lang.Object", "java.lang.String", "java.lang.Class", RuntimeArray.class.getName(), RuntimeClass.class.getName(), RuntimeObject.class.getName(), WeakReference.class.getName(), ReferenceQueue.class.getName(), RuntimeReferenceQueue.class.getName(), RuntimeReference.class.getName()));
    private GenerationContext context;
    private Decompiler decompiler;
    private CacheStatus cacheStatus;
    private TagRegistry tagRegistry;
    private CodeGenerator codeGenerator;
    private FieldReference[] staticGcRoots;
    private FieldReference[] classLayout;
    private Set<ValueType> types = new LinkedHashSet<ValueType>();
    private CodeWriter prologueWriter;
    private CodeWriter codeWriter;
    private CodeWriter initWriter;
    private CodeWriter headerWriter;
    private CodeWriter callSitesWriter;
    private IncludeManager includes;
    private IncludeManager headerIncludes;
    private MethodNodeCache astCache = EmptyMethodNodeCache.INSTANCE;
    private AstDependencyExtractor dependencyExtractor = new AstDependencyExtractor();
    private List<CallSiteDescriptor> callSites;
    private ClassMetadataRequirements metadataRequirements;
    private static final int VT_STRUCTURE_INITIALIZER_DEPTH_THRESHOLD = 9;
    private InstructionVisitor prepareVisitor = new AbstractInstructionVisitor(){

        @Override
        public void visit(ClassConstantInstruction insn) {
            ClassGenerator.this.addType(insn.getConstant());
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            ClassGenerator.this.addType(ValueType.object("java.lang.String"));
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            ClassGenerator.this.addType(ValueType.arrayOf(insn.getItemType()));
        }

        @Override
        public void visit(ConstructInstruction insn) {
            ClassGenerator.this.addType(ValueType.object(insn.getType()));
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            ClassGenerator.this.addType(insn.getType());
        }

        @Override
        public void visit(CastInstruction insn) {
            ClassGenerator.this.addType(insn.getTargetType());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            ClassGenerator.this.addType(insn.getItemType());
        }
    };
    private static final String TYPE_OBJECT = "TEAVM_FIELD_TYPE_OBJECT";

    public ClassGenerator(GenerationContext context, TagRegistry tagRegistry, Decompiler decompiler, CacheStatus cacheStatus) {
        this.context = context;
        this.tagRegistry = tagRegistry;
        this.decompiler = decompiler;
        this.cacheStatus = cacheStatus;
        this.metadataRequirements = new ClassMetadataRequirements(context.getDependencies());
    }

    public void setAstCache(MethodNodeCache astCache) {
        this.astCache = astCache;
    }

    public void setCallSites(List<CallSiteDescriptor> callSites) {
        this.callSites = callSites;
    }

    public void prepare(ListableClassHolderSource classes) {
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            this.prepareClass(cls);
        }
    }

    private void prepareClass(ClassHolder cls) {
        this.types.add(ValueType.object(cls.getName()));
        if (cls.getParent() != null) {
            this.types.add(ValueType.object(cls.getParent()));
        }
        for (String itf : cls.getInterfaces()) {
            this.types.add(ValueType.object(itf));
        }
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null) continue;
            this.prepareProgram(method.getProgram());
        }
    }

    private void prepareProgram(Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction insn : block) {
                insn.acceptVisitor(this.prepareVisitor);
            }
        }
    }

    private void addType(ValueType type) {
        if (!this.types.add(type)) {
            return;
        }
        if (type instanceof ValueType.Array) {
            this.addType(((ValueType.Array)type).getItemType());
        }
    }

    public void generateClass(CodeWriter writer, CodeWriter headerWriter, ClassHolder cls) {
        ValueType.Object type = ValueType.object(cls.getName());
        this.init(writer, headerWriter, this.context.getFileNames().fileName(cls.getName()), type);
        this.generateStringPoolDecl(type);
        this.generateClassStructure(cls);
        this.generateClassStaticFields(cls);
        this.generateClassMethods(cls);
        this.generateInitializer(cls);
        this.generateVirtualTable(ValueType.object(cls.getName()));
        this.generateStaticGCRoots(cls.getName());
        this.generateLayoutArray(cls.getName());
        this.generateStringPool(type);
    }

    private void generateCallSites(List<? extends CallSiteDescriptor> callSites, String callSitesName) {
        CallSiteGenerator generator = new CallSiteGenerator(this.context, this.callSitesWriter, this.includes, callSitesName);
        generator.setStatic(true);
        generator.generate(callSites);
    }

    public void generateType(CodeWriter writer, CodeWriter headerWriter, ValueType type) {
        this.init(writer, headerWriter, this.context.getFileNames().fileName(type), type);
        this.generateStringPoolDecl(type);
        this.includes.includeType(type);
        this.generateVirtualTable(type);
        this.generateStringPool(type);
    }

    private void init(CodeWriter writer, CodeWriter headerWriter, String fileName, ValueType type) {
        this.staticGcRoots = null;
        this.classLayout = null;
        this.includes = new SimpleIncludeManager(this.context.getFileNames(), writer);
        this.includes.init(fileName + ".c");
        this.prologueWriter = writer.fragment();
        this.codeWriter = writer.fragment();
        this.headerWriter = headerWriter;
        headerWriter.println("#pragma once");
        this.headerIncludes = new SimpleIncludeManager(this.context.getFileNames(), headerWriter);
        this.headerIncludes.init(fileName + ".h");
        this.headerIncludes.includePath("runtime.h");
        String currentClassName = type instanceof ValueType.Object ? ((ValueType.Object)type).getClassName() : null;
        String sysInitializerName = this.context.getNames().forClassSystemInitializer(type);
        headerWriter.println("extern void " + sysInitializerName + "();");
        writer.println("void " + sysInitializerName + "() {").indent();
        this.initWriter = writer.fragment();
        writer.outdent().println("}");
        this.includes.includeType(type);
        ClassGenerationContext classContext = new ClassGenerationContext(this.context, this.includes, this.prologueWriter, this.initWriter, currentClassName);
        this.codeGenerator = new CodeGenerator(classContext, this.codeWriter, this.includes);
        if (!this.context.isIncremental()) {
            this.codeGenerator.setCallSites(this.callSites);
        }
    }

    private void generateStringPoolDecl(ValueType type) {
        if (!this.context.isIncremental()) {
            return;
        }
        String poolName = "strings_" + this.context.getNames().forClassInstance(type);
        this.codeWriter.println("TeaVM_String* " + poolName + "[];");
        this.codeWriter.println("#ifdef TEAVM_GET_STRING");
        this.codeWriter.println("#undef TEAVM_GET_STRING");
        this.codeWriter.println("#endif");
        this.codeWriter.println("#define TEAVM_GET_STRING(i) " + poolName + "[i]");
    }

    private void generateStringPool(ValueType type) {
        if (!this.context.isIncremental() || this.context.getStringPool().getStrings().isEmpty()) {
            return;
        }
        this.codeWriter.println("#undef TEAVM_GET_STRING");
        String poolName = "strings_" + this.context.getNames().forClassInstance(type);
        StringPoolGenerator poolGenerator = new StringPoolGenerator(this.context, poolName);
        this.includes.includePath("stringhash.h");
        poolGenerator.generate(this.codeWriter);
        poolGenerator.generateStringPoolHeaders(this.initWriter, this.includes);
    }

    public Set<ValueType> getTypes() {
        return this.types;
    }

    private void generateClassMethods(ClassHolder cls) {
        boolean needsVirtualTable = ClassGenerator.needsVirtualTable(this.context.getCharacteristics(), ValueType.object(cls.getName()));
        for (MethodHolder method : cls.getMethods()) {
            RegularMethodNode methodNode;
            AstCacheEntry entry;
            if (method.hasModifier(ElementModifier.ABSTRACT)) continue;
            if (method.hasModifier(ElementModifier.NATIVE)) {
                if (!this.tryDelegateToMethod(cls, method) && !this.tryUsingGenerator(method) || !needsVirtualTable) continue;
                this.addToVirtualTable(method);
                continue;
            }
            if (method.getProgram() == null) continue;
            if (needsVirtualTable) {
                this.addToVirtualTable(method);
            }
            if (this.context.isIncremental()) {
                this.callSitesWriter = this.codeWriter.fragment();
            }
            this.generateMethodForwardDeclaration(method);
            AstCacheEntry astCacheEntry = entry = !this.cacheStatus.isStaleMethod(method.getReference()) ? this.astCache.get(method.getReference(), this.cacheStatus) : null;
            if (entry == null) {
                methodNode = this.decompiler.decompileRegular(method);
                this.astCache.store(method.getReference(), new AstCacheEntry(methodNode, new ControlFlowEntry[0]), () -> this.dependencyExtractor.extract(methodNode));
            } else {
                methodNode = entry.method;
            }
            ArrayList<CallSiteDescriptor> callSites = null;
            if (this.context.isIncremental()) {
                callSites = new ArrayList<CallSiteDescriptor>();
                this.codeGenerator.setCallSites(callSites);
            }
            this.codeGenerator.generateMethod(methodNode);
            if (!this.context.isIncremental()) continue;
            this.generateCallSites(method.getReference(), callSites);
            this.codeWriter.println("#undef TEAVM_ALLOC_STACK");
        }
    }

    private void addToVirtualTable(MethodReader method) {
        if (!this.context.isIncremental()) {
            return;
        }
        if (method.hasModifier(ElementModifier.STATIC) || method.getLevel() == AccessLevel.PRIVATE || method.getName().equals("<init>")) {
            return;
        }
        String className = this.context.getNames().forClassInstance(ValueType.object(method.getOwnerName()));
        String idVar = this.codeGenerator.getClassContext().getVirtualMethodId(method.getDescriptor());
        this.initWriter.println("teavm_vc_registerMethod(&" + className + ", " + idVar + ", &" + this.context.getNames().forMethod(method.getReference()) + ");");
    }

    private void generateMethodForwardDeclaration(MethodHolder method) {
        if (this.context.isIncremental()) {
            this.codeGenerator.getClassContext().importMethod(method.getReference(), method.hasModifier(ElementModifier.STATIC));
            return;
        }
        boolean isStatic = method.hasModifier(ElementModifier.STATIC);
        this.headerWriter.print("extern ");
        CodeGenerator.generateMethodSignature(this.headerWriter, this.context.getNames(), method.getReference(), isStatic, false);
        this.headerWriter.println(";");
    }

    private void generateCallSites(MethodReference method, List<? extends CallSiteDescriptor> callSites) {
        Object callSitesName;
        if (!callSites.isEmpty()) {
            callSitesName = "callsites_" + this.context.getNames().forMethod(method);
            this.includes.includeClass(CallSite.class.getName());
            this.generateCallSites(callSites, (String)callSitesName);
        } else {
            callSitesName = "NULL";
        }
        this.callSitesWriter.println("#define TEAVM_ALLOC_STACK(size) TEAVM_ALLOC_STACK_DEF(size, " + (String)callSitesName + ")");
    }

    private void generateInitializer(ClassHolder cls) {
        if (!this.needsInitializer(cls)) {
            return;
        }
        String initializerName = this.context.getNames().forClassInitializer(cls.getName());
        this.headerWriter.print("extern void ").print(initializerName).println("();");
        this.codeWriter.print("void ").print(initializerName).println("() {").indent();
        String classInstanceName = this.context.getNames().forClassInstance(ValueType.object(cls.getName()));
        String clinitName = this.context.getNames().forMethod(new MethodReference(cls.getName(), "<clinit>", ValueType.VOID));
        this.codeWriter.print("TeaVM_Class* cls = (TeaVM_Class*) &").print(classInstanceName).println(";");
        this.codeWriter.println("if (!(cls->flags & INT32_C(1))) {").indent();
        this.codeWriter.println("cls->flags |= INT32_C(1);");
        this.codeWriter.print(clinitName).println("();");
        this.codeWriter.outdent().println("}");
        this.codeWriter.outdent().println("}");
    }

    private void generateClassStructure(ClassHolder cls) {
        boolean writeNeeded;
        if (!this.needsData(cls)) {
            return;
        }
        String name = this.context.getNames().forClass(cls.getName());
        boolean bl = writeNeeded = !classesWithDeclaredStructures.contains(cls.getName());
        if (writeNeeded) {
            this.headerWriter.print("typedef struct ").print(name).println(" {").indent();
        }
        if (cls.getParent() == null || !cls.getParent().equals(Structure.class.getName())) {
            String parentName = cls.getParent();
            if (parentName == null) {
                parentName = RuntimeObject.class.getName();
            }
            if (writeNeeded) {
                this.headerIncludes.includeClass(parentName);
                this.headerWriter.print("struct ").print(this.context.getNames().forClass(parentName)).println(" parent;");
            }
            this.includes.includeClass(parentName);
        }
        FieldReference[] instanceFields = new FieldReference[cls.getFields().size()];
        int instanceIndex = 0;
        for (FieldHolder field : cls.getFields()) {
            if (field.hasModifier(ElementModifier.STATIC) || this.isMonitorField(field.getReference())) continue;
            String fieldName = this.context.getNames().forMemberField(field.getReference());
            if (writeNeeded) {
                this.headerWriter.printStrictType(field.getType()).print(" ").print(fieldName).println(";");
            }
            if (!this.isReferenceType(field.getType())) continue;
            instanceFields[instanceIndex++] = field.getReference();
        }
        if (instanceIndex > 0) {
            this.classLayout = Arrays.copyOf(instanceFields, instanceIndex);
        }
        if (writeNeeded) {
            this.headerWriter.outdent().print("} ").print(name).println(";");
        }
    }

    private boolean isMonitorField(FieldReference field) {
        return field.getClassName().equals("java.lang.Object") && field.getFieldName().equals("monitor");
    }

    private void generateClassStaticFields(ClassHolder cls) {
        CodeWriter fieldsWriter = this.codeWriter.fragment();
        FieldReference[] staticFields = new FieldReference[cls.getFields().size()];
        int staticIndex = 0;
        for (FieldHolder field : cls.getFields()) {
            Object initialValue;
            if (!field.hasModifier(ElementModifier.STATIC)) continue;
            String fieldName = this.context.getNames().forStaticField(field.getReference());
            this.headerWriter.print("extern ").printStrictType(field.getType()).print(" ").print(fieldName).println(";");
            fieldsWriter.printStrictType(field.getType()).print(" ").print(fieldName).println(";");
            if (this.isReferenceType(field.getType()) && field.getAnnotations().get(NoGcRoot.class.getName()) == null) {
                staticFields[staticIndex++] = field.getReference();
            }
            if ((initialValue = field.getInitialValue()) == null) {
                initialValue = ClassGenerator.getDefaultValue(field.getType());
            }
            this.initWriter.print(fieldName + " = ");
            CodeGeneratorUtil.writeValue(this.initWriter, this.context, this.includes, initialValue);
            this.initWriter.println(";");
        }
        if (staticIndex > 0) {
            this.staticGcRoots = Arrays.copyOf(staticFields, staticIndex);
        }
    }

    private static Object getDefaultValue(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitive = (ValueType.Primitive)type;
            switch (primitive.getKind()) {
                case BOOLEAN: {
                    return false;
                }
                case BYTE: {
                    return (byte)0;
                }
                case SHORT: {
                    return (short)0;
                }
                case INTEGER: {
                    return 0;
                }
                case CHARACTER: {
                    return Character.valueOf('\u0000');
                }
                case LONG: {
                    return 0L;
                }
                case FLOAT: {
                    return Float.valueOf(0.0f);
                }
                case DOUBLE: {
                    return 0.0;
                }
            }
        }
        return null;
    }

    private void generateVirtualTable(ValueType type) {
        String structName;
        ClassReader cls;
        if (!ClassGenerator.needsVirtualTable(this.context.getCharacteristics(), type)) {
            return;
        }
        this.generateIsSupertypeFunction(type);
        String className = null;
        if (type instanceof ValueType.Object) {
            className = ((ValueType.Object)type).getClassName();
            if (!this.context.isIncremental()) {
                this.generateVirtualTableStructure(className);
            }
        } else if (type instanceof ValueType.Array) {
            className = "java.lang.Object";
        }
        ClassReader classReader = cls = className != null ? this.context.getClassSource().get(className) : null;
        if (this.context.isIncremental()) {
            structName = className != null ? "TeaVM_DynamicClass" : "TeaVM_Class";
        } else {
            String string = structName = className != null && (cls == null || !cls.hasModifier(ElementModifier.INTERFACE)) ? this.context.getNames().forClassClass(className) : "TeaVM_Class";
        }
        if (className != null && !this.context.isIncremental()) {
            this.headerIncludes.includeClass(className);
        }
        String name = this.context.getNames().forClassInstance(type);
        String enumConstants = cls != null && cls.hasModifier(ElementModifier.ENUM) ? this.writeEnumConstants(cls, name) : "NULL";
        this.headerWriter.print("extern ").print(structName).print(" ").print(name).println(";");
        if (this.classLayout != null) {
            this.codeWriter.println("static int16_t teavm_classLayouts_" + name + "[" + (this.classLayout.length + 1) + "];");
        }
        this.codeWriter.print("alignas(8) ").print(structName).print(" ").print(name);
        if (className != null) {
            if (this.context.isIncremental()) {
                this.generateDynamicVirtualTable(name, type, enumConstants);
            } else {
                VirtualTable virtualTable = this.context.getVirtualTableProvider().lookup(className);
                if (cls.hasModifier(ElementModifier.INTERFACE)) {
                    this.codeWriter.println(" = {").indent();
                    this.generateRuntimeClassInitializer(type, enumConstants, false, 0);
                    this.codeWriter.outdent().print("}");
                } else if (virtualTable != null) {
                    boolean tooDeep;
                    boolean bl = tooDeep = this.getInheritanceDepth(className) > 9;
                    if (tooDeep) {
                        this.initWriter.print(structName).print("* vt_0 = &").print(name).println(";");
                    } else {
                        this.codeWriter.println(" = {").indent();
                    }
                    this.generateVirtualTableContent(virtualTable, virtualTable, type, enumConstants, tooDeep, 0);
                    if (!tooDeep) {
                        this.codeWriter.outdent().print("}");
                    }
                } else {
                    this.codeWriter.println(" = {").indent();
                    this.codeWriter.println(".parent = {").indent();
                    this.generateRuntimeClassInitializer(type, enumConstants, false, 0);
                    this.codeWriter.outdent().println("}");
                    this.codeWriter.outdent().println("}");
                }
            }
        } else {
            this.codeWriter.println(" = {").indent();
            this.generateRuntimeClassInitializer(type, enumConstants, false, 0);
            this.codeWriter.outdent().println("}");
        }
        this.codeWriter.outdent().println(";");
    }

    private int getInheritanceDepth(String className) {
        int depth = 0;
        while (true) {
            ++depth;
            ClassReader cls = this.context.getClassSource().get(className);
            if (cls.getParent() == null) break;
            className = cls.getParent();
        }
        return depth;
    }

    private void generateDynamicVirtualTable(String name, ValueType type, String enumConstants) {
        String[] parentClasses;
        this.codeWriter.println(".parent = {").indent();
        this.generateRuntimeClassInitializer(type, enumConstants, false, 0);
        this.codeWriter.outdent().println("}");
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            ClassReader cls = this.context.getClassSource().get(className);
            if (cls != null) {
                int count = cls.getInterfaces().size();
                if (cls.getParent() != null) {
                    ++count;
                }
                parentClasses = new String[count];
                cls.getInterfaces().toArray(parentClasses);
                if (cls.getParent() != null) {
                    parentClasses[count - 1] = cls.getParent();
                }
            } else {
                parentClasses = new String[]{};
            }
        } else {
            parentClasses = new String[]{"java.lang.Object"};
        }
        for (String parentClass : parentClasses) {
            this.includes.includeClass(parentClass);
            String parentClassName = this.context.getNames().forClassInstance(ValueType.object(parentClass));
            this.initWriter.println("teavm_vc_copyMethods(&" + parentClassName + ", &" + name + ");");
        }
    }

    private void generateVirtualTableContent(VirtualTable current, VirtualTable original, ValueType type, String enumConstants, boolean initMethod, int depth) {
        if (!initMethod) {
            this.codeWriter.println(".parent = {").indent();
        } else {
            String parentStructName = current.getParent() != null ? this.context.getNames().forClassClass(current.getParent().getClassName()) : "TeaVM_Class";
            this.initWriter.print(parentStructName).print("* vt_").print(String.valueOf(depth + 1)).print(" = (").print(parentStructName).print("*) vt_").print(String.valueOf(depth)).println(";");
        }
        if (current.getParent() == null) {
            this.generateRuntimeClassInitializer(type, enumConstants, initMethod, depth + 1);
        } else {
            this.generateVirtualTableContent(current.getParent(), original, type, enumConstants, initMethod, depth + 1);
        }
        if (!initMethod) {
            this.codeWriter.outdent().print("}");
        }
        for (MethodDescriptor methodDescriptor : current.getMethods()) {
            VirtualTableEntry entry;
            if (methodDescriptor == null || (entry = original.getEntry(methodDescriptor)) == null) continue;
            if (!initMethod) {
                this.codeWriter.println(",");
            }
            String methodName = this.context.getNames().forVirtualMethod(methodDescriptor);
            String implName = "&" + this.context.getNames().forMethod(entry.getImplementor());
            this.includes.includeClass(entry.getImplementor().getClassName());
            if (initMethod) {
                this.initWriter.print("vt_").print(String.valueOf(depth)).print("->").print(methodName).print(" = ").print(implName).println(";");
                continue;
            }
            this.codeWriter.print(".").print(methodName).print(" = ").print(implName);
        }
        if (!initMethod) {
            this.codeWriter.println();
        }
    }

    private String writeEnumConstants(ClassReader cls, String baseName) {
        List fields = cls.getFields().stream().filter(f -> f.hasModifier(ElementModifier.ENUM)).collect(Collectors.toList());
        String name = baseName + "_enumConstants";
        this.codeWriter.print("static void* " + name + "[" + (fields.size() + 1) + "] = { ");
        this.codeWriter.print("(void*) (intptr_t) " + fields.size());
        for (FieldReader field : fields) {
            this.codeWriter.print(", ").print("&" + this.context.getNames().forStaticField(field.getReference()));
        }
        this.codeWriter.println(" };");
        return name;
    }

    private void generateRuntimeClassInitializer(ValueType type, String enumConstants, boolean initMethod, int depth) {
        Object arrayTypeExpr;
        Object itemTypeExpr;
        Object parent;
        int tag;
        Object sizeExpr;
        int flags = 0;
        String layout = "NULL";
        String initFunction = "NULL";
        String superinterfaceCount = "0";
        String superinterfaces = "NULL";
        Object simpleName = null;
        Object declaringClass = "NULL";
        Object enclosingClass = "NULL";
        if (type instanceof ValueType.Object) {
            Set<String> interfaces;
            String className = ((ValueType.Object)type).getClassName();
            ClassReader cls = this.context.getClassSource().get(className);
            if (className.equals(Object.class.getName())) {
                className = RuntimeObject.class.getName();
            }
            if (cls != null && this.needsData(cls) && !className.equals("java.lang.Class")) {
                String structName = this.context.getNames().forClass(className);
                sizeExpr = "(int32_t) (intptr_t) TEAVM_ALIGN(sizeof(" + structName + "), sizeof(void*))";
            } else {
                sizeExpr = "0";
            }
            if (cls != null) {
                if (cls.hasModifier(ElementModifier.ABSTRACT)) {
                    flags |= 0x200;
                }
                if (cls.hasModifier(ElementModifier.INTERFACE)) {
                    flags |= 0x400;
                }
                if (cls.hasModifier(ElementModifier.FINAL)) {
                    flags |= 0x800;
                }
                if (cls.hasModifier(ElementModifier.ANNOTATION)) {
                    flags |= 0x2000;
                }
                if (cls.hasModifier(ElementModifier.SYNTHETIC)) {
                    flags |= 0x4000;
                }
                if (cls.hasModifier(ElementModifier.ENUM)) {
                    flags |= 0x1000;
                }
            }
            List<TagRegistry.Range> ranges = this.tagRegistry != null ? this.tagRegistry.getRanges(className) : null;
            int n = tag = !this.context.isIncremental() && ranges != null && !ranges.isEmpty() ? ranges.get((int)0).lower : 0;
            if (cls != null && cls.getParent() != null && this.types.contains(ValueType.object(cls.getParent()))) {
                this.includes.includeClass(cls.getParent());
                parent = "(TeaVM_Class*) &" + this.context.getNames().forClassInstance(ValueType.object(cls.getParent()));
            } else {
                parent = "NULL";
            }
            itemTypeExpr = "NULL";
            String string = layout = this.classLayout != null ? "teavm_classLayouts_" + this.context.getNames().forClassInstance(type) : "NULL";
            if (cls != null && this.needsInitializer(cls)) {
                initFunction = this.context.getNames().forClassInitializer(className);
            }
            Set<String> set = interfaces = cls != null ? cls.getInterfaces().stream().filter(c -> this.types.contains(ValueType.object(c))).collect(Collectors.toSet()) : Collections.emptySet();
            if (!interfaces.isEmpty()) {
                superinterfaceCount = Integer.toString(cls.getInterfaces().size());
                CharSequence sb = new StringBuilder("(TeaVM_Class*[]) { ");
                int first = 1;
                for (String itf : interfaces) {
                    if (first == 0) {
                        ((StringBuilder)sb).append(", ");
                    }
                    first = 0;
                    this.includes.includeClass(itf);
                    ((StringBuilder)sb).append("(TeaVM_Class*) &").append(this.context.getNames().forClassInstance(ValueType.object(itf)));
                }
                superinterfaces = ((StringBuilder)sb).append(" }").toString();
            }
            switch (className) {
                case "java.lang.ref.WeakReference": {
                    flags |= 0x40;
                    break;
                }
                case "java.lang.ref.ReferenceQueue": {
                    flags |= 0x80;
                }
            }
            if (cls != null) {
                simpleName = cls.getSimpleName();
                if (cls.getDeclaringClassName() != null && this.context.getDependencies().getClass(cls.getDeclaringClassName()) != null) {
                    declaringClass = "(TeaVM_Class*) &" + this.context.getNames().forClassInstance(ValueType.object(cls.getDeclaringClassName()));
                    this.includes.includeClass(cls.getDeclaringClassName());
                }
                if (cls.getOwnerName() != null && this.context.getDependencies().getClass(cls.getOwnerName()) != null) {
                    enclosingClass = "(TeaVM_Class*) &" + this.context.getNames().forClassInstance(ValueType.object(cls.getOwnerName()));
                    this.includes.includeClass(cls.getOwnerName());
                }
            }
        } else if (type instanceof ValueType.Array) {
            this.includes.includeClass("java.lang.Object");
            parent = "(TeaVM_Class*) &" + this.context.getNames().forClassInstance(ValueType.object("java.lang.Object"));
            tag = !this.context.isIncremental() ? this.tagRegistry.getRanges((String)"java.lang.Object").get((int)0).lower : 0;
            ValueType itemType = ((ValueType.Array)type).getItemType();
            sizeExpr = "sizeof(" + CodeWriter.strictTypeAsString(itemType) + ")";
            this.includes.includeType(itemType);
            itemTypeExpr = "(TeaVM_Class*) &" + this.context.getNames().forClassInstance(itemType);
        } else if (type == ValueType.VOID) {
            parent = "NULL";
            tag = 0;
            sizeExpr = "0";
            itemTypeExpr = "NULL";
            flags |= 2;
            flags = ClassGeneratorUtil.applyPrimitiveFlags(flags, type);
        } else {
            parent = "NULL";
            tag = Integer.MAX_VALUE;
            sizeExpr = "sizeof(" + CodeWriter.strictTypeAsString(type) + ")";
            flags |= 2;
            flags = ClassGeneratorUtil.applyPrimitiveFlags(flags, type);
            itemTypeExpr = "NULL";
        }
        String metadataName = this.nameOfType(type);
        String nameRef = metadataName != null ? "(TeaVM_Object**) TEAVM_GET_STRING_ADDRESS(" + this.context.getStringPool().getStringIndex(metadataName) + ")" : "NULL";
        String superTypeFunction = this.context.getNames().forSupertypeFunction(type);
        ValueType.Array arrayType = ValueType.arrayOf(type);
        if (this.types.contains(arrayType)) {
            this.includes.includeType(arrayType);
            arrayTypeExpr = "(TeaVM_Class*) &" + this.context.getNames().forClassInstance(arrayType);
        } else {
            arrayTypeExpr = "NULL";
        }
        if (simpleName == null) {
            simpleName = "NULL";
        } else {
            int simpleNameIndex = this.context.getStringPool().getStringIndex((String)simpleName);
            simpleName = "(TeaVM_Object**) TEAVM_GET_STRING_ADDRESS(" + simpleNameIndex + ")";
        }
        this.includes.includePath("strings.h");
        ArrayList<FieldInitializer> initializers = new ArrayList<FieldInitializer>();
        initializers.add(new FieldInitializer("size", (String)sizeExpr));
        initializers.add(new FieldInitializer("flags", String.valueOf(flags)));
        initializers.add(new FieldInitializer("tag", String.valueOf(tag)));
        initializers.add(new FieldInitializer("canary", "0"));
        initializers.add(new FieldInitializer("name", nameRef));
        initializers.add(new FieldInitializer("simpleName", (String)simpleName));
        initializers.add(new FieldInitializer("arrayType", (String)arrayTypeExpr));
        initializers.add(new FieldInitializer("itemType", (String)itemTypeExpr));
        initializers.add(new FieldInitializer("isSupertypeOf", "&" + superTypeFunction));
        initializers.add(new FieldInitializer("superclass", (String)parent));
        initializers.add(new FieldInitializer("superinterfaceCount", superinterfaceCount));
        initializers.add(new FieldInitializer("superinterfaces", superinterfaces));
        initializers.add(new FieldInitializer("layout", layout));
        initializers.add(new FieldInitializer("enumValues", enumConstants));
        initializers.add(new FieldInitializer("declaringClass", (String)declaringClass));
        initializers.add(new FieldInitializer("enclosingClass", (String)enclosingClass));
        initializers.add(new FieldInitializer("init", initFunction));
        if (initMethod) {
            for (FieldInitializer initializer : initializers) {
                this.initWriter.print("vt_").print(String.valueOf(depth)).print("->").print(initializer.name).print(" = ").print(initializer.value).println(";");
            }
        } else {
            for (int i = 0; i < initializers.size(); ++i) {
                FieldInitializer initializer;
                if (i > 0) {
                    this.codeWriter.println(",");
                }
                initializer = (FieldInitializer)initializers.get(i);
                this.codeWriter.print(".").print(initializer.name).print(" = ").print(initializer.value);
            }
        }
        if (this.context.isHeapDump() && type instanceof ValueType.Object) {
            ClassReader cls = this.context.getClassSource().get(((ValueType.Object)type).getClassName());
            this.generateHeapDumpMetadata(initMethod ? this.initWriter : this.codeWriter, cls, initMethod, depth);
        }
        if (!initMethod) {
            this.codeWriter.println();
        }
    }

    private void generateHeapDumpMetadata(CodeWriter writer, ClassReader cls, boolean initMethod, int depth) {
        String structDecl;
        List<HeapDumpField> fields = this.getHeapDumpFields(cls);
        List<HeapDumpField> staticFields = this.getHeapDumpStaticFields(cls);
        if (staticFields.isEmpty() && fields.isEmpty()) {
            return;
        }
        writer.println().println("#if TEAVM_HEAP_DUMP").indent();
        if (!fields.isEmpty()) {
            structDecl = "struct { uint32_t count; TeaVM_FieldDescriptor data[" + fields.size() + "]; }";
            if (initMethod) {
                writer.print("static " + structDecl + " fieldDescriptors = ");
            } else {
                writer.println(",");
                writer.println(".fieldDescriptors = (TeaVM_FieldDescriptors*) &(" + structDecl + ") ");
            }
            writer.println("{").indent();
            this.generateHeapDumpFields(writer, fields);
            writer.outdent().print("}");
            if (initMethod) {
                writer.println(";");
                writer.println("vt_" + depth + "->fieldDescriptors = (TeaVM_FieldDescriptors*) &fieldDescriptors;");
            }
        }
        if (!staticFields.isEmpty()) {
            structDecl = "struct { uint32_t count; TeaVM_StaticFieldDescriptor data[" + staticFields.size() + "]; }";
            if (initMethod) {
                writer.print("static " + structDecl + " staticFieldDescriptors = ");
            } else {
                writer.println(",");
                writer.println(".staticFieldDescriptors = (TeaVM_StaticFieldDescriptors*) &(" + structDecl + ") ");
            }
            writer.println("{").indent();
            this.generateHeapDumpFields(writer, staticFields);
            writer.outdent().print("}");
            if (initMethod) {
                writer.println(";");
                writer.print("vt_" + depth + "->staticFieldDescriptors = (TeaVM_StaticFieldDescriptors*) &staticFieldDescriptors;");
            }
        }
        writer.println().outdent().println("#endif");
    }

    private void generateHeapDumpFields(CodeWriter codeWriter, List<HeapDumpField> fields) {
        codeWriter.println(".count = " + fields.size() + ",");
        codeWriter.println(".data = {").indent();
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                codeWriter.println(",");
            }
            HeapDumpField field = fields.get(i);
            codeWriter.print("{ .name = u");
            StringPoolGenerator.generateSimpleStringLiteral(codeWriter, field.name);
            codeWriter.print(", .offset = " + field.offset + ", .type = " + field.type + " }");
        }
        codeWriter.println().outdent().println("}");
    }

    private List<HeapDumpField> getHeapDumpFields(ClassReader cls) {
        ArrayList<HeapDumpField> fields = new ArrayList<HeapDumpField>();
        switch (cls.getName()) {
            case "java.lang.Object": 
            case "java.lang.ref.ReferenceQueue": 
            case "java.lang.ref.WeakReference": 
            case "java.lang.ref.SoftReference": {
                break;
            }
            case "java.lang.Class": {
                fields.add(new HeapDumpField("name", "offsetof(TeaVM_Class, name)", TYPE_OBJECT));
                fields.add(new HeapDumpField("simpleName", "offsetof(TeaVM_Class, simpleName)", TYPE_OBJECT));
                break;
            }
            case "java.lang.ref.Reference": {
                fields.add(new HeapDumpField("referent", "offsetof(TeaVM_Reference, object)", TYPE_OBJECT));
                fields.add(new HeapDumpField("queue", "offsetof(TeaVM_Reference, queue)", TYPE_OBJECT));
                break;
            }
            default: {
                for (FieldReader fieldReader : cls.getFields()) {
                    if (fieldReader.hasModifier(ElementModifier.STATIC) || !this.isManaged(fieldReader)) continue;
                    String className = this.context.getNames().forClass(cls.getName());
                    String offset = "offsetof(" + className + ", " + this.context.getNames().forMemberField(fieldReader.getReference()) + ")";
                    fields.add(new HeapDumpField(fieldReader.getName(), offset, ClassGenerator.typeForHeapDump(fieldReader.getType())));
                }
            }
        }
        return fields;
    }

    private List<HeapDumpField> getHeapDumpStaticFields(ClassReader cls) {
        ArrayList<HeapDumpField> fields = new ArrayList<HeapDumpField>();
        switch (cls.getName()) {
            case "java.lang.Object": 
            case "java.lang.Class": 
            case "java.lang.ref.ReferenceQueue": 
            case "java.lang.ref.Reference": 
            case "java.lang.ref.WeakReference": 
            case "java.lang.ref.SoftReference": {
                break;
            }
            default: {
                for (FieldReader fieldReader : cls.getFields()) {
                    if (!fieldReader.hasModifier(ElementModifier.STATIC) || !this.isManaged(fieldReader)) continue;
                    String offset = "(unsigned char*) &" + this.context.getNames().forStaticField(fieldReader.getReference());
                    fields.add(new HeapDumpField(fieldReader.getName(), offset, ClassGenerator.typeForHeapDump(fieldReader.getType())));
                }
            }
        }
        return fields;
    }

    private boolean isManaged(FieldReader field) {
        ValueType type = field.getType();
        return !(type instanceof ValueType.Object) || this.context.getCharacteristics().isManaged(((ValueType.Object)type).getClassName());
    }

    static String typeForHeapDump(ValueType type) {
        String result = "127";
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    result = "TEAVM_FIELD_TYPE_BOOLEAN";
                    break;
                }
                case BYTE: {
                    result = "TEAVM_FIELD_TYPE_BYTE";
                    break;
                }
                case SHORT: {
                    result = "TEAVM_FIELD_TYPE_SHORT";
                    break;
                }
                case CHARACTER: {
                    result = "TEAVM_FIELD_TYPE_CHAR";
                    break;
                }
                case INTEGER: {
                    result = "TEAVM_FIELD_TYPE_INT";
                    break;
                }
                case FLOAT: {
                    result = "TEAVM_FIELD_TYPE_FLOAT";
                    break;
                }
                case LONG: {
                    result = "TEAVM_FIELD_TYPE_LONG";
                    break;
                }
                case DOUBLE: {
                    result = "TEAVM_FIELD_TYPE_DOUBLE";
                }
            }
        } else {
            result = type instanceof ValueType.Array ? "TEAVM_FIELD_TYPE_ARRAY" : TYPE_OBJECT;
        }
        return result;
    }

    private void generateVirtualTableStructure(String className) {
        String name = this.context.getNames().forClassClass(className);
        this.headerWriter.print("typedef struct ").print(name).println(" {").indent();
        VirtualTable virtualTable = this.context.getVirtualTableProvider().lookup(className);
        if (virtualTable != null) {
            String parentName = "TeaVM_Class";
            int index = 0;
            if (virtualTable.getParent() != null) {
                this.headerIncludes.includeClass(virtualTable.getParent().getClassName());
                parentName = this.context.getNames().forClassClass(virtualTable.getParent().getClassName());
                index = virtualTable.getParent().size();
            }
            this.headerWriter.println(parentName + " parent;");
            int padIndex = 0;
            for (MethodDescriptor methodDescriptor : virtualTable.getMethods()) {
                if (methodDescriptor != null) {
                    String methodName = this.context.getNames().forVirtualMethod(methodDescriptor);
                    this.headerWriter.printType(methodDescriptor.getResultType()).print(" (*").print(methodName).print(")(");
                    CodeGenerator.generateMethodParameters(this.headerWriter, methodDescriptor, false, false);
                    this.headerWriter.print(")");
                } else {
                    this.headerWriter.print("void (*pad" + padIndex++ + ")()");
                }
                this.headerWriter.println("; // " + index++);
            }
        }
        this.headerWriter.outdent().print("} ").print(name).println(";");
    }

    private boolean isReferenceType(ValueType type) {
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            return !this.context.getCharacteristics().isStructure(className) && !this.context.getCharacteristics().isFunction(className) && !this.context.getCharacteristics().isResource(className) && !className.equals(Address.class.getName());
        }
        return type instanceof ValueType.Array;
    }

    private void generateStaticGCRoots(String className) {
        if (this.staticGcRoots == null) {
            return;
        }
        String suffix = this.context.getNames().forClassInstance(ValueType.object(className));
        String varName = "teavm_gc_localStaticRoots_" + suffix;
        this.codeWriter.println("static void** " + varName + "[" + this.staticGcRoots.length + "] = {").indent();
        boolean first = true;
        for (FieldReference field : this.staticGcRoots) {
            if (!first) {
                this.codeWriter.print(", ");
            }
            first = false;
            String name = this.context.getNames().forStaticField(field);
            this.codeWriter.print("(void**) &").print(name);
        }
        this.codeWriter.println().outdent().println("};");
        this.initWriter.println("teavm_registerStaticGcRoots(" + varName + ", " + this.staticGcRoots.length + ");");
    }

    private void generateLayoutArray(String className) {
        if (this.classLayout == null) {
            return;
        }
        String name = this.context.getNames().forClassInstance(ValueType.object(className));
        this.codeWriter.print("static int16_t teavm_classLayouts_" + name + "[" + (this.classLayout.length + 1) + "] = {").indent();
        this.codeWriter.println().print("INT16_C(" + this.classLayout.length + ")");
        for (FieldReference field : this.classLayout) {
            String structName = this.context.getNames().forClass(field.getClassName());
            String fieldName = this.context.getNames().forMemberField(field);
            this.codeWriter.print(", (int16_t) offsetof(" + structName + ", " + fieldName + ")");
        }
        this.codeWriter.println().outdent().println("};");
    }

    private boolean needsData(ClassReader cls) {
        if (cls.hasModifier(ElementModifier.INTERFACE)) {
            return false;
        }
        if (InteropUtil.isNative(cls)) {
            return false;
        }
        return !cls.getName().equals(Structure.class.getName()) && !cls.getName().equals(Address.class.getName());
    }

    public static boolean needsVirtualTable(Characteristics characteristics, ValueType type) {
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            return characteristics.isManaged(className);
        }
        if (type instanceof ValueType.Array) {
            return ClassGenerator.needsVirtualTable(characteristics, ((ValueType.Array)type).getItemType());
        }
        return true;
    }

    private boolean needsInitializer(ClassReader cls) {
        return !this.context.getCharacteristics().isStaticInit(cls.getName()) && !this.context.getCharacteristics().isStructure(cls.getName()) && cls.getMethod(new MethodDescriptor("<clinit>", ValueType.VOID)) != null && this.context.getClassInitializerInfo().isDynamicInitializer(cls.getName());
    }

    private boolean tryDelegateToMethod(ClassHolder cls, MethodHolder method) {
        AnnotationHolder delegateToAnnot = method.getAnnotations().get(DelegateTo.class.getName());
        if (delegateToAnnot == null) {
            return false;
        }
        String methodName = delegateToAnnot.getValue("value").getString();
        for (MethodHolder candidate : cls.getMethods()) {
            if (!candidate.getName().equals(methodName)) continue;
            this.generateMethodForwardDeclaration(method);
            this.delegateToMethod(method, candidate);
            return true;
        }
        return false;
    }

    private void delegateToMethod(MethodHolder callingMethod, MethodHolder delegateMethod) {
        CodeGenerator.generateMethodSignature(this.codeWriter, this.context.getNames(), callingMethod.getReference(), callingMethod.hasModifier(ElementModifier.STATIC), true);
        this.codeWriter.println(" {").indent();
        if (callingMethod.getResultType() != ValueType.VOID) {
            this.codeWriter.print("return ");
        }
        this.codeWriter.print(this.context.getNames().forMethod(delegateMethod.getReference())).print("(");
        boolean isStatic = callingMethod.hasModifier(ElementModifier.STATIC);
        int start = 0;
        if (!isStatic) {
            this.codeWriter.print("teavm_this_");
        } else {
            if (callingMethod.parameterCount() > 0) {
                this.codeWriter.print("teavm_local_1");
            }
            ++start;
        }
        for (int i = start; i < callingMethod.parameterCount(); ++i) {
            this.codeWriter.print(", ").print("teavm_local_").print(String.valueOf(i + 1));
        }
        this.codeWriter.println(");");
        this.codeWriter.outdent().println("}");
    }

    private boolean tryUsingGenerator(MethodHolder method) {
        MethodReference methodRef = method.getReference();
        Generator generator = this.context.getGenerator(methodRef);
        if (generator == null) {
            return false;
        }
        this.generateMethodForwardDeclaration(method);
        CodeWriter writerBefore = this.codeWriter.fragment();
        boolean isStatic = method.hasModifier(ElementModifier.STATIC);
        CodeGenerator.generateMethodSignature(this.codeWriter, this.context.getNames(), methodRef, isStatic, true);
        this.codeWriter.println(" {").indent();
        CodeWriter bodyWriter = this.codeWriter.fragment();
        this.codeWriter.outdent().println("}");
        GeneratorContextImpl generatorContext = new GeneratorContextImpl(this.codeGenerator.getClassContext(), bodyWriter, writerBefore, this.codeWriter, this.includes, this.callSites);
        generator.generate(generatorContext, methodRef);
        try {
            generatorContext.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public String nameOfType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            return ReflectionUtil.typeName(((ValueType.Primitive)type).getKind());
        }
        if (type instanceof ValueType.Array) {
            if (ClassGenerator.isArrayOfPrimitives(type)) {
                return type.toString().replace('/', '.');
            }
            return null;
        }
        if (type == ValueType.VOID) {
            return "void";
        }
        if (type instanceof ValueType.Object) {
            String name = ((ValueType.Object)type).getClassName();
            return this.metadataRequirements.getInfo(name).name() ? name : null;
        }
        throw new AssertionError();
    }

    private static boolean isArrayOfPrimitives(ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        return type instanceof ValueType.Primitive || type == ValueType.VOID;
    }

    private void generateIsSupertypeFunction(ValueType type) {
        String name = this.context.getNames().forSupertypeFunction(type);
        this.headerWriter.println("extern int32_t " + name + "(TeaVM_Class*);");
        this.codeWriter.println("int32_t " + name + "(TeaVM_Class* cls) {").indent();
        if (type instanceof ValueType.Object) {
            this.generateIsSuperclassFunction(((ValueType.Object)type).getClassName());
        } else if (type instanceof ValueType.Primitive) {
            this.generateIsSuperPrimitiveFunction((ValueType.Primitive)type);
        } else if (type == ValueType.VOID) {
            this.generateIsSuperclassFunction("java.lang.Void");
        } else if (type instanceof ValueType.Array) {
            this.generateIsSuperArrayFunction(((ValueType.Array)type).getItemType());
        }
        this.codeWriter.outdent().println("}");
    }

    private void generateIsSuperclassFunction(String className) {
        if (this.context.isIncremental()) {
            this.generateIncrementalSuperclassFunction(className);
        } else {
            this.generateFastIsSuperclassFunction(className);
        }
    }

    private void generateFastIsSuperclassFunction(String className) {
        List<TagRegistry.Range> ranges = this.tagRegistry.getRanges(className);
        if (ranges.isEmpty()) {
            this.codeWriter.println("return INT32_C(0);");
            return;
        }
        String tagName = this.context.getNames().forMemberField(new FieldReference(RuntimeClass.class.getName(), "tag"));
        this.codeWriter.println("int32_t tag = cls->" + tagName + ";");
        int lower = ranges.get((int)0).lower;
        int upper = ranges.get((int)(ranges.size() - 1)).upper;
        this.codeWriter.println("if (tag < " + lower + " || tag >= " + upper + ") return INT32_C(0);");
        for (int i = 1; i < ranges.size(); ++i) {
            lower = ranges.get((int)(i - 1)).upper;
            upper = ranges.get((int)i).lower;
            this.codeWriter.println("if (tag >= " + lower + " && tag < " + upper + ") return INT32_C(0);");
        }
        this.codeWriter.println("return INT32_C(1);");
    }

    private void generateIncrementalSuperclassFunction(String className) {
        String functionName = this.context.getNames().forSupertypeFunction(ValueType.object(className));
        ClassReader cls = this.context.getClassSource().get(className);
        if (cls != null && this.types.contains(ValueType.object(className))) {
            this.includes.includeClass(className);
            String name = this.context.getNames().forClassInstance(ValueType.object(className));
            this.codeWriter.println("if (cls == (TeaVM_Class*) &" + name + ") return INT32_C(1);");
            this.codeWriter.println("if (cls->superclass != NULL && " + functionName + "(cls->superclass)) return INT32_C(1);");
            this.codeWriter.println("for (int32_t i = 0; i < cls->superinterfaceCount; ++i) {").indent();
            this.codeWriter.println("if (" + functionName + "(cls->superinterfaces[i])) return INT32_C(1);");
            this.codeWriter.outdent().println("}");
        }
        this.codeWriter.println("return INT32_C(0);");
    }

    private void generateIsSuperArrayFunction(ValueType itemType) {
        String itemTypeName = this.context.getNames().forMemberField(new FieldReference(RuntimeClass.class.getName(), "itemType"));
        this.codeWriter.println("TeaVM_Class* itemType = cls->" + itemTypeName + ";");
        this.codeWriter.println("if (itemType == NULL) return INT32_C(0);");
        if (itemType instanceof ValueType.Primitive) {
            this.codeWriter.println("return itemType == &" + this.context.getNames().forClassInstance(itemType) + ";");
        } else {
            this.codeWriter.println("return " + this.context.getNames().forSupertypeFunction(itemType) + "(itemType);");
        }
    }

    private void generateIsSuperPrimitiveFunction(ValueType.Primitive primitive) {
        switch (primitive.getKind()) {
            case BOOLEAN: {
                this.generateIsSuperclassFunction("java.lang.Boolean");
                break;
            }
            case BYTE: {
                this.generateIsSuperclassFunction("java.lang.Byte");
                break;
            }
            case SHORT: {
                this.generateIsSuperclassFunction("java.lang.Short");
                break;
            }
            case CHARACTER: {
                this.generateIsSuperclassFunction("java.lang.Character");
                break;
            }
            case INTEGER: {
                this.generateIsSuperclassFunction("java.lang.Integer");
                break;
            }
            case LONG: {
                this.generateIsSuperclassFunction("java.lang.Long");
                break;
            }
            case FLOAT: {
                this.generateIsSuperclassFunction("java.lang.Float");
                break;
            }
            case DOUBLE: {
                this.generateIsSuperclassFunction("java.lang.Double");
            }
        }
    }

    static class FieldInitializer {
        final String name;
        final String value;

        FieldInitializer(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    static class HeapDumpField {
        String name;
        String offset;
        String type;

        HeapDumpField(String name, String offset, String type) {
            this.name = name;
            this.offset = offset;
            this.type = type;
        }
    }
}

