/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.ArrayList;
import java.util.Objects;
import org.teavm.model.PrimitiveType;

public abstract class GenericValueType {
    private static final Argument[] EMPTY_ARRAY = new Argument[0];
    public static final Void VOID = new Void();
    public static final Primitive BOOLEAN = new Primitive(PrimitiveType.BOOLEAN);
    public static final Primitive BYTE = new Primitive(PrimitiveType.BYTE);
    public static final Primitive SHORT = new Primitive(PrimitiveType.SHORT);
    public static final Primitive INT = new Primitive(PrimitiveType.INTEGER);
    public static final Primitive FLOAT = new Primitive(PrimitiveType.FLOAT);
    public static final Primitive LONG = new Primitive(PrimitiveType.LONG);
    public static final Primitive DOUBLE = new Primitive(PrimitiveType.DOUBLE);
    public static final Primitive CHAR = new Primitive(PrimitiveType.CHARACTER);

    private GenericValueType() {
    }

    abstract void toString(StringBuilder var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public static GenericValueType parse(String text, ParsePosition position) {
        int i = position.index;
        if (i >= text.length()) {
            return null;
        }
        switch (text.charAt(i++)) {
            case 'V': {
                position.index = i;
                return VOID;
            }
            case 'Z': {
                position.index = i;
                return BOOLEAN;
            }
            case 'B': {
                position.index = i;
                return BYTE;
            }
            case 'S': {
                position.index = i;
                return SHORT;
            }
            case 'C': {
                position.index = i;
                return CHAR;
            }
            case 'I': {
                position.index = i;
                return INT;
            }
            case 'J': {
                position.index = i;
                return LONG;
            }
            case 'F': {
                position.index = i;
                return FLOAT;
            }
            case 'D': {
                position.index = i;
                return DOUBLE;
            }
            case 'L': {
                position.index = i;
                return GenericValueType.parseObjectImpl(text, position);
            }
            case 'T': {
                position.index = i;
                return GenericValueType.parseVariable(text, position);
            }
            case '[': {
                position.index = i;
                GenericValueType itemType = GenericValueType.parse(text, position);
                return itemType != null ? new Array(itemType) : null;
            }
        }
        return null;
    }

    private static GenericValueType parseObjectImpl(String text, ParsePosition position) {
        int i;
        int last = i = position.index;
        Object parent = null;
        block5: while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case ';': {
                    if (last == i) {
                        return null;
                    }
                    String name = text.substring(last, i).replace('/', '.');
                    position.index = ++i;
                    return new Object(parent, name, EMPTY_ARRAY);
                }
                case '.': {
                    if (i == last) {
                        return null;
                    }
                    parent = new Object(parent, text.substring(last, i).replace('/', '.'), EMPTY_ARRAY);
                    last = ++i;
                    continue block5;
                }
                case '<': {
                    position.index = i + 1;
                    Argument[] arguments = GenericValueType.parseArguments(text, position);
                    if (arguments == null || position.index >= text.length()) {
                        return null;
                    }
                    String name = text.substring(last, i).replace('/', '.');
                    Object result = new Object(parent, name, arguments);
                    i = position.index;
                    if ((c = text.charAt(i++)) == ';') {
                        position.index = i;
                        return result;
                    }
                    if (c == '.') {
                        parent = result;
                        last = i;
                        continue block5;
                    }
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    private static Argument[] parseArguments(String text, ParsePosition position) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        block6: while (position.index < text.length()) {
            Reference constraint;
            char c = text.charAt(position.index);
            switch (c) {
                case '>': {
                    if (arguments.isEmpty()) {
                        return null;
                    }
                    ++position.index;
                    return arguments.toArray(new Argument[0]);
                }
                case '*': {
                    ++position.index;
                    arguments.add(Argument.ANY);
                    continue block6;
                }
                case '+': {
                    ++position.index;
                    constraint = GenericValueType.parseReference(text, position);
                    if (constraint == null) {
                        return null;
                    }
                    arguments.add(Argument.covariant(constraint));
                    continue block6;
                }
                case '-': {
                    ++position.index;
                    constraint = GenericValueType.parseReference(text, position);
                    if (constraint == null) {
                        return null;
                    }
                    arguments.add(Argument.contravariant(constraint));
                    continue block6;
                }
            }
            constraint = GenericValueType.parseReference(text, position);
            if (constraint == null) {
                return null;
            }
            arguments.add(Argument.invariant(constraint));
        }
        return null;
    }

    public static Reference parseReference(String text, ParsePosition position) {
        GenericValueType type = GenericValueType.parse(text, position);
        return type instanceof Reference ? (Reference)type : null;
    }

    public static Object parseObject(String text, ParsePosition position) {
        GenericValueType type = GenericValueType.parse(text, position);
        return type instanceof Object ? (Object)type : null;
    }

    private static GenericValueType parseVariable(String text, ParsePosition position) {
        for (int i = position.index; i < text.length(); ++i) {
            if (text.charAt(i) != ';') continue;
            if (i == position.index) {
                return null;
            }
            Variable result = new Variable(text.substring(position.index, i));
            position.index = i + 1;
            return result;
        }
        return null;
    }

    public GenericValueType parse(String text) {
        ParsePosition position = new ParsePosition();
        GenericValueType type = GenericValueType.parse(text, position);
        return position.index == text.length() ? type : null;
    }

    public static class ParsePosition {
        public int index;
    }

    public static final class Void
    extends GenericValueType {
        private Void() {
        }

        @Override
        void toString(StringBuilder sb) {
            sb.append("V");
        }

        public boolean equals(java.lang.Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 53604390;
        }
    }

    public static final class Primitive
    extends GenericValueType {
        private final PrimitiveType kind;
        private final int hash;

        private Primitive(PrimitiveType kind) {
            this.kind = kind;
            this.hash = 0x1127CAE ^ kind.ordinal() * 31;
        }

        public PrimitiveType getKind() {
            return this.kind;
        }

        @Override
        void toString(StringBuilder sb) {
            switch (this.kind) {
                case BOOLEAN: {
                    sb.append("Z");
                    break;
                }
                case BYTE: {
                    sb.append("B");
                    break;
                }
                case SHORT: {
                    sb.append("S");
                    break;
                }
                case INTEGER: {
                    sb.append("I");
                    break;
                }
                case LONG: {
                    sb.append("J");
                    break;
                }
                case FLOAT: {
                    sb.append("F");
                    break;
                }
                case CHARACTER: {
                    sb.append("C");
                    break;
                }
                case DOUBLE: {
                    sb.append("D");
                }
            }
        }

        public boolean equals(java.lang.Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static final class Array
    extends Reference {
        private final GenericValueType itemType;
        private int hash;

        public Array(GenericValueType itemType) {
            this.itemType = itemType;
        }

        public GenericValueType getItemType() {
            return this.itemType;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Array)) {
                return false;
            }
            Array that = (Array)obj;
            return this.itemType.equals(that.itemType);
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = 0x19C9884 ^ this.itemType.hashCode() * 193;
                if (this.hash == 0) {
                    ++this.hash;
                }
            }
            return this.hash;
        }

        @Override
        void toString(StringBuilder sb) {
            sb.append("[");
            this.itemType.toString(sb);
        }
    }

    public static final class Object
    extends Reference {
        private final Object parent;
        private final String className;
        private final Argument[] arguments;
        private int hash;

        public Object(Object parent, String className, Argument[] arguments) {
            this.parent = parent;
            this.className = className;
            this.arguments = arguments != null ? (Argument[])arguments.clone() : EMPTY_ARRAY;
        }

        public Object getParent() {
            return this.parent;
        }

        public String getClassName() {
            return this.className;
        }

        public Argument[] getArguments() {
            return this.arguments.length == 0 ? EMPTY_ARRAY : (Argument[])this.arguments.clone();
        }

        @Override
        void toString(StringBuilder sb) {
            sb.append("L");
            this.toStringImpl(sb);
            sb.append(";");
        }

        private void toStringImpl(StringBuilder sb) {
            if (this.parent != null) {
                this.parent.toStringImpl(sb);
                sb.append(".");
            }
            sb.append(this.className.replace('.', '/'));
            if (this.arguments.length > 0) {
                sb.append("<");
                for (Argument argument : this.arguments) {
                    switch (argument.kind) {
                        case ANY: {
                            sb.append("*");
                            break;
                        }
                        case CONTRAVARIANT: {
                            sb.append("-");
                            break;
                        }
                        case COVARIANT: {
                            sb.append("+");
                            break;
                        }
                    }
                    if (argument.value == null) continue;
                    argument.value.toString(sb);
                }
                sb.append(">");
            }
        }

        public boolean equals(java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Object)) {
                return false;
            }
            Object that = (Object)obj;
            if (that.arguments.length != this.arguments.length) {
                return false;
            }
            if (!that.className.equals(this.className)) {
                return false;
            }
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[i].equals(that.arguments[i])) continue;
                return false;
            }
            return Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = 0x5170B48 ^ this.className.hashCode() * 167;
                for (Argument arg : this.arguments) {
                    this.hash = this.hash * 31 + arg.hashCode();
                }
                if (this.parent != null) {
                    this.hash = 167 * this.hash + this.parent.hashCode();
                }
                if (this.hash == 0) {
                    ++this.hash;
                }
            }
            return this.hash;
        }
    }

    public static class Argument {
        public static final Argument ANY = new Argument(ArgumentKind.ANY, null);
        private final ArgumentKind kind;
        private final Reference value;
        private int hash;

        private Argument(ArgumentKind kind, Reference value) {
            this.kind = kind;
            this.value = value;
        }

        public ArgumentKind getKind() {
            return this.kind;
        }

        public Reference getValue() {
            return this.value;
        }

        public static Argument invariant(Reference value) {
            return new Argument(ArgumentKind.INVARIANT, value);
        }

        public static Argument covariant(Reference value) {
            return new Argument(ArgumentKind.COVARIANT, value);
        }

        public static Argument contravariant(Reference value) {
            return new Argument(ArgumentKind.CONTRAVARIANT, value);
        }

        public int hashCode() {
            if (this.hash == 0) {
                switch (this.kind) {
                    case ANY: {
                        this.hash = 43866465;
                        break;
                    }
                    case CONTRAVARIANT: {
                        this.hash = 0x6AB6AB;
                        break;
                    }
                    case COVARIANT: {
                        this.hash = 4379540;
                        break;
                    }
                    case INVARIANT: {
                        this.hash = 72320251;
                    }
                }
            }
            if (this.value != null) {
                this.hash = this.hash * 47 + this.value.hashCode();
            }
            return this.hash;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            return super.equals(obj);
        }
    }

    public static abstract class Reference
    extends GenericValueType {
        private Reference() {
        }
    }

    public static final class Variable
    extends Reference {
        private final String name;
        private int hash;

        public Variable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Variable)) {
                return false;
            }
            Variable that = (Variable)obj;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = 0x420C9D1 ^ this.name.hashCode() * 173;
                if (this.hash == 0) {
                    ++this.hash;
                }
            }
            return this.hash;
        }

        @Override
        void toString(StringBuilder sb) {
            sb.append("T");
            sb.append(this.name);
            sb.append(";");
        }
    }

    public static enum ArgumentKind {
        COVARIANT,
        CONTRAVARIANT,
        INVARIANT,
        ANY;

    }
}

