/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCatch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDefaultExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmFloatUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;

class WasmRenderingVisitor
implements WasmExpressionVisitor {
    StringBuilder sb = new StringBuilder();
    private Map<WasmBlock, String> blockIdentifiers = new HashMap<WasmBlock, String>();
    private int indentLevel;
    private boolean lfDeferred;
    boolean lineNumbersEmitted;
    WasmModule module;

    WasmRenderingVisitor(WasmModule module) {
        this.module = module;
    }

    void preprocess(WasmExpression expression) {
        expression.acceptVisitor(new WasmDefaultExpressionVisitor(){

            @Override
            public void visit(WasmBranch expression) {
                super.visit(expression);
                this.register(expression.getTarget());
            }

            @Override
            public void visit(WasmBreak expression) {
                super.visit(expression);
                this.register(expression.getTarget());
            }

            @Override
            public void visit(WasmSwitch expression) {
                super.visit(expression);
                for (WasmBlock target : expression.getTargets()) {
                    this.register(target);
                }
                this.register(expression.getDefaultTarget());
            }

            private void register(WasmBlock block) {
                WasmRenderingVisitor.this.blockIdentifiers.computeIfAbsent(block, key -> "block_" + WasmRenderingVisitor.this.blockIdentifiers.size());
            }
        });
    }

    void clear() {
        this.blockIdentifiers.clear();
    }

    WasmRenderingVisitor append(String text) {
        if (this.lfDeferred) {
            this.lfDeferred = false;
            this.sb.append("\n");
            this.sb.append("  ".repeat(Math.max(0, this.indentLevel)));
        }
        this.sb.append(text);
        return this;
    }

    WasmRenderingVisitor append(WasmType type) {
        return this.append(this.type(type));
    }

    private WasmRenderingVisitor append(WasmExpression expression) {
        expression.acceptVisitor(this);
        return this;
    }

    WasmRenderingVisitor line(WasmExpression expression) {
        if (expression.getLocation() != null && this.lineNumbersEmitted) {
            this.lf().append(";; " + expression.getLocation().getFileName() + ":" + expression.getLocation().getLine());
        }
        this.lf().append(expression);
        return this;
    }

    WasmRenderingVisitor indent() {
        ++this.indentLevel;
        return this;
    }

    WasmRenderingVisitor outdent() {
        --this.indentLevel;
        return this;
    }

    WasmRenderingVisitor lf() {
        if (this.lfDeferred) {
            this.sb.append("\n");
        }
        this.lfDeferred = true;
        return this;
    }

    WasmRenderingVisitor open() {
        this.append("(").indent();
        return this;
    }

    WasmRenderingVisitor close() {
        this.outdent().append(")");
        return this;
    }

    @Override
    public void visit(WasmBlock expression) {
        this.renderBlock(expression, expression.isLoop() ? "loop" : "block", true);
    }

    private void renderBlock(WasmBlock block, String name, boolean signature) {
        this.open().append(name);
        String id = this.blockIdentifiers.get(block);
        if (id != null) {
            this.append(" $" + id);
        }
        if (signature && block.getType() != null) {
            this.append(" " + this.type(block.getType()));
        }
        for (WasmExpression part : block.getBody()) {
            this.line(part);
        }
        this.close();
    }

    @Override
    public void visit(WasmBranch expression) {
        String id = this.blockIdentifiers.get(expression.getTarget());
        this.open().append("br_if $" + id);
        if (expression.getResult() != null) {
            this.line(expression.getResult());
        }
        this.line(expression.getCondition());
        this.close();
    }

    @Override
    public void visit(WasmBreak expression) {
        String id = this.blockIdentifiers.get(expression.getTarget());
        this.open().append("br $").append(id);
        if (expression.getResult() != null) {
            this.line(expression.getResult());
        }
        this.close();
    }

    @Override
    public void visit(WasmSwitch expression) {
        this.open().append("br_table ");
        for (WasmBlock target : expression.getTargets()) {
            this.append("$" + this.blockIdentifiers.get(target)).append(" ");
        }
        this.append("$" + this.blockIdentifiers.get(expression.getDefaultTarget()));
        this.line(expression.getSelector());
        this.close();
    }

    @Override
    public void visit(WasmConditional expression) {
        this.open().append("if");
        if (expression.getType() != null) {
            this.append(" " + this.type(expression.getType()));
        }
        this.line(expression.getCondition());
        this.lf();
        this.renderBlock(expression.getThenBlock(), "then", false);
        if (!expression.getElseBlock().getBody().isEmpty()) {
            this.lf();
            this.renderBlock(expression.getElseBlock(), "else", false);
        }
        this.close();
    }

    @Override
    public void visit(WasmReturn expression) {
        this.open().append("return");
        if (expression.getValue() != null) {
            this.line(expression.getValue());
        }
        this.close();
    }

    @Override
    public void visit(WasmUnreachable expression) {
        this.open().append("unreachable").close();
    }

    @Override
    public void visit(WasmInt32Constant expression) {
        this.open().append("i32.const " + expression.getValue()).close();
    }

    @Override
    public void visit(WasmInt64Constant expression) {
        this.open().append("i64.const " + expression.getValue()).close();
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
        this.open().append("f32.const " + Float.toHexString(expression.getValue())).close();
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
        this.open().append("f64.const " + Double.toHexString(expression.getValue())).close();
    }

    @Override
    public void visit(WasmNullConstant expression) {
        this.open().append("ref.null " + this.type(expression.getType())).close();
    }

    @Override
    public void visit(WasmGetLocal expression) {
        this.open().append("local.get " + this.asString(expression.getLocal())).close();
    }

    @Override
    public void visit(WasmSetLocal expression) {
        this.open().append("local.set " + this.asString(expression.getLocal())).line(expression.getValue()).close();
    }

    @Override
    public void visit(WasmGetGlobal expression) {
        this.open().append("global.get " + this.asString(expression.getGlobal())).close();
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        this.open().append("global.set " + this.asString(expression.getGlobal())).line(expression.getValue()).close();
    }

    private String asString(WasmLocal local) {
        return String.valueOf(local.getIndex());
    }

    private String asString(WasmGlobal global) {
        return global.getName() != null ? "$" + global.getName() : String.valueOf(this.module.globals.indexOf(global));
    }

    @Override
    public void visit(WasmIntBinary expression) {
        this.open().append(this.type(expression.getType()) + "." + this.operation(expression.getOperation()));
        this.line(expression.getFirst());
        this.line(expression.getSecond());
        this.close();
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        this.open().append(this.type(expression.getType()) + "." + this.operation(expression.getOperation()));
        this.line(expression.getFirst());
        this.line(expression.getSecond());
        this.close();
    }

    @Override
    public void visit(WasmIntUnary expression) {
        this.open().append(this.type(expression.getType()) + "." + this.operation(expression.getOperation()));
        this.line(expression.getOperand());
        this.close();
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        this.open().append(this.type(expression.getType()) + "." + this.operation(expression.getOperation()));
        this.line(expression.getOperand());
        this.close();
    }

    @Override
    public void visit(WasmConversion expression) {
        String name = null;
        block0 : switch (expression.getSourceType()) {
            case INT32: {
                switch (expression.getTargetType()) {
                    case INT32: {
                        break;
                    }
                    case INT64: {
                        name = expression.isSigned() ? "extend_s" : "extend_u";
                        break;
                    }
                    case FLOAT32: 
                    case FLOAT64: {
                        name = expression.isReinterpret() ? "reinterpret" : (expression.isSigned() ? "convert_s" : "convert_u");
                    }
                }
                break;
            }
            case INT64: {
                switch (expression.getTargetType()) {
                    case INT32: {
                        name = "wrap";
                        break;
                    }
                    case INT64: {
                        break;
                    }
                    case FLOAT32: 
                    case FLOAT64: {
                        name = expression.isReinterpret() ? "reinterpret" : (expression.isSigned() ? "convert_s" : "convert_u");
                    }
                }
                break;
            }
            case FLOAT32: {
                switch (expression.getTargetType()) {
                    case INT32: 
                    case INT64: {
                        if (expression.isReinterpret()) {
                            name = "reinterpret";
                            break;
                        }
                        name = expression.isSigned() ? "trunc_s" : "trunc_u";
                        break;
                    }
                    case FLOAT32: {
                        break;
                    }
                    case FLOAT64: {
                        name = "promote";
                    }
                }
                break;
            }
            case FLOAT64: {
                switch (expression.getTargetType()) {
                    case INT32: 
                    case INT64: {
                        if (expression.isReinterpret()) {
                            name = "reinterpret";
                            break block0;
                        }
                        name = expression.isSigned() ? "trunc_s" : "trunc_u";
                        break block0;
                    }
                    case FLOAT32: {
                        name = "demote";
                        break block0;
                    }
                }
            }
        }
        if (name == null) {
            this.append(expression.getOperand());
        } else {
            this.open().append(this.type(expression.getTargetType()) + "." + name + "/" + this.type(expression.getSourceType()));
            this.line(expression.getOperand());
            this.close();
        }
    }

    @Override
    public void visit(WasmCall expression) {
        this.open().append("call").append(" $" + this.module.functions.indexOf(expression.getFunction()));
        for (WasmExpression argument : expression.getArguments()) {
            this.line(argument);
        }
        this.close();
    }

    @Override
    public void visit(WasmIndirectCall expression) {
    }

    @Override
    public void visit(WasmCallReference expression) {
        this.open().append("call_ref ").append(this.type(expression.getType().getReference()));
        this.line(expression.getFunctionReference());
        for (WasmExpression argument : expression.getArguments()) {
            this.line(argument);
        }
        this.close();
    }

    @Override
    public void visit(WasmDrop expression) {
        this.open().append("drop").lf();
        this.append(expression.getOperand());
        this.close();
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        this.open();
        switch (expression.getConvertFrom()) {
            case INT8: {
                this.append("i32.load8_s");
                break;
            }
            case UINT8: {
                this.append("i32.load8_u");
                break;
            }
            case INT16: {
                this.append("i32.load16_s");
                break;
            }
            case UINT16: {
                this.append("i32.load16_u");
                break;
            }
            case INT32: {
                this.append("i32.load");
            }
        }
        if (expression.getOffset() > 0) {
            this.append(" offset=" + expression.getOffset());
        }
        this.append(" align=" + expression.getAlignment());
        this.line(expression.getIndex());
        this.close();
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        this.open();
        switch (expression.getConvertFrom()) {
            case INT8: {
                this.append("i64.load8_s");
                break;
            }
            case UINT8: {
                this.append("i64.load8_u");
                break;
            }
            case INT16: {
                this.append("i64.load16_s");
                break;
            }
            case UINT16: {
                this.append("i64.load16_u");
                break;
            }
            case INT32: {
                this.append("i64.load32_s");
                break;
            }
            case UINT32: {
                this.append("i64.load32_u");
                break;
            }
            case INT64: {
                this.append("i64.load");
            }
        }
        if (expression.getOffset() > 0) {
            this.append(" offset=" + expression.getOffset());
        }
        this.append(" align=" + expression.getAlignment());
        this.line(expression.getIndex());
        this.close();
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        this.open().append("f32.load");
        if (expression.getOffset() > 0) {
            this.append(" offset=" + expression.getOffset());
        }
        this.append(" align=" + expression.getAlignment());
        this.line(expression.getIndex());
        this.close();
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        this.open().append("f64.load");
        if (expression.getOffset() > 0) {
            this.append(" offset=" + expression.getOffset());
        }
        this.append(" align=" + expression.getAlignment());
        this.line(expression.getIndex());
        this.close();
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        this.open();
        switch (expression.getConvertTo()) {
            case INT8: 
            case UINT8: {
                this.append("i32.store8");
                break;
            }
            case INT16: 
            case UINT16: {
                this.append("i32.store16");
                break;
            }
            case INT32: {
                this.append("i32.store");
            }
        }
        if (expression.getOffset() > 0) {
            this.append(" offset=" + expression.getOffset());
        }
        this.append(" align=" + expression.getAlignment());
        this.line(expression.getIndex());
        this.line(expression.getValue());
        this.close();
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        this.open();
        switch (expression.getConvertTo()) {
            case INT8: 
            case UINT8: {
                this.append("i64.store8");
                break;
            }
            case INT16: 
            case UINT16: {
                this.append("i64.store16");
                break;
            }
            case INT32: 
            case UINT32: {
                this.append("i64.store32");
                break;
            }
            case INT64: {
                this.append("i64.store");
            }
        }
        if (expression.getOffset() > 0) {
            this.append(" offset=" + expression.getOffset());
        }
        this.append(" align=" + expression.getAlignment());
        this.line(expression.getIndex());
        this.line(expression.getValue());
        this.close();
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        this.open().append("f32.store");
        if (expression.getOffset() > 0) {
            this.append(" offset=" + expression.getOffset());
        }
        this.append(" align=" + expression.getAlignment());
        this.line(expression.getIndex());
        this.line(expression.getValue());
        this.close();
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        this.open().append("f64.store");
        if (expression.getOffset() > 0) {
            this.append(" offset=" + expression.getOffset());
        }
        this.append(" align=" + expression.getAlignment());
        this.line(expression.getIndex());
        this.line(expression.getValue());
        this.close();
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        this.open().append("memory.grow");
        this.line(expression.getAmount());
        this.close();
    }

    @Override
    public void visit(WasmCopy expression) {
        this.open().append("memory.copy");
        this.line(expression.getDestinationIndex());
        this.line(expression.getSourceIndex());
        this.line(expression.getCount());
        this.close();
    }

    @Override
    public void visit(WasmFill expression) {
        this.open().append("memory.fill");
        this.line(expression.getIndex());
        this.line(expression.getValue());
        this.line(expression.getCount());
        this.close();
    }

    @Override
    public void visit(WasmTry expression) {
        this.open().append("try");
        if (expression.getType() != null) {
            this.append(" " + this.type(expression.getType()));
        }
        for (WasmExpression part : expression.getBody()) {
            this.line(part);
        }
        for (WasmCatch catchClause : expression.getCatches()) {
            this.lf().append("(catch ").append(String.valueOf(catchClause.getTag().getIndex())).append(" ").indent();
            for (WasmExpression part : catchClause.getBody()) {
                this.line(part);
            }
            this.lf().outdent().append(")");
        }
        this.close();
    }

    @Override
    public void visit(WasmThrow expression) {
        this.open().append("throw");
        this.append(" ").append(String.valueOf(expression.getTag().getIndex()));
        for (WasmExpression arg : expression.getArguments()) {
            this.line(arg);
        }
        this.close();
    }

    @Override
    public void visit(WasmReferencesEqual expression) {
        this.open().append("ref.eq ");
        this.line(expression.getFirst());
        this.line(expression.getSecond());
        this.close();
    }

    @Override
    public void visit(WasmCast expression) {
        this.open().append("ref.cast ").append(this.type(expression.getTargetType()));
        this.line(expression.getValue());
        this.close();
    }

    @Override
    public void visit(WasmStructNew expression) {
        this.open().append("struct.new ");
        this.append(expression.getType().getReference());
        for (WasmExpression initializer : expression.getInitializers()) {
            this.line(initializer);
        }
        this.close();
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
        this.open().append("struct.new_default ").append(expression.getType().getReference()).close();
    }

    @Override
    public void visit(WasmStructGet expression) {
        this.open();
        if (expression.getSignedType() == null) {
            this.append("struct.get");
        } else {
            switch (expression.getSignedType()) {
                case SIGNED: {
                    this.append("struct.get_s");
                    break;
                }
                case UNSIGNED: {
                    this.append("struct.get_u");
                }
            }
        }
        this.append(" ").append(this.typeName(expression.getType()));
        this.append(" ").append(String.valueOf(expression.getFieldIndex()));
        this.line(expression.getInstance());
        this.close();
    }

    @Override
    public void visit(WasmStructSet expression) {
        this.open().append("struct.set");
        this.append(" ").append(this.typeName(expression.getType()));
        this.append(" ").append(String.valueOf(expression.getFieldIndex()));
        this.line(expression.getInstance());
        this.line(expression.getValue());
        this.close();
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        this.open().append("array.new_default");
        this.append(" ").append(this.typeName(expression.getType()));
        this.line(expression.getLength());
        this.close();
    }

    @Override
    public void visit(WasmArrayGet expression) {
        this.open();
        if (expression.getSignedType() == null) {
            this.append("array.get");
        } else {
            switch (expression.getSignedType()) {
                case SIGNED: {
                    this.append("array.get_s");
                    break;
                }
                case UNSIGNED: {
                    this.append("array.get_u");
                }
            }
        }
        this.append(" ").append(this.typeName(expression.getType()));
        this.line(expression.getInstance());
        this.line(expression.getIndex());
        this.close();
    }

    @Override
    public void visit(WasmArraySet expression) {
        this.open().append("array.set");
        this.append(" ").append(this.typeName(expression.getType()));
        this.line(expression.getInstance());
        this.line(expression.getIndex());
        this.line(expression.getValue());
        this.close();
    }

    @Override
    public void visit(WasmArrayLength expression) {
        this.open().append("array.length");
        this.line(expression.getInstance());
        this.close();
    }

    @Override
    public void visit(WasmFunctionReference expression) {
        this.open().append("ref.func ").append(" $" + this.module.functions.indexOf(expression.getFunction()));
        this.close();
    }

    private String type(WasmType type) {
        if (type instanceof WasmType.Number) {
            return this.type(((WasmType.Number)type).number);
        }
        if (type instanceof WasmType.SpecialReference) {
            switch (((WasmType.SpecialReference)type).kind) {
                case ANY: {
                    return "anyref";
                }
                case EXTERN: {
                    return "externref";
                }
                case STRUCT: {
                    return "structref";
                }
                case FUNC: {
                    return "funcref";
                }
                case ARRAY: {
                    return "arrayref";
                }
            }
            throw new IllegalArgumentException();
        }
        if (type instanceof WasmType.CompositeReference) {
            return "(ref " + this.typeName(((WasmType.CompositeReference)type).composite) + ")";
        }
        throw new IllegalArgumentException();
    }

    private String typeName(WasmCompositeType type) {
        return type.getName() != null ? "$" + type.getName() : String.valueOf(this.module.types.indexOf(type));
    }

    private String type(WasmNumType type) {
        switch (type) {
            case INT32: {
                return "i32";
            }
            case INT64: {
                return "i64";
            }
            case FLOAT32: {
                return "f32";
            }
            case FLOAT64: {
                return "f64";
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    private String type(WasmIntType type) {
        switch (type) {
            case INT32: {
                return "i32";
            }
            case INT64: {
                return "i64";
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    private String type(WasmFloatType type) {
        switch (type) {
            case FLOAT32: {
                return "f32";
            }
            case FLOAT64: {
                return "f64";
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    private String operation(WasmIntBinaryOperation operation) {
        switch (operation) {
            case ADD: {
                return "add";
            }
            case SUB: {
                return "sub";
            }
            case MUL: {
                return "mul";
            }
            case DIV_SIGNED: {
                return "div_s";
            }
            case DIV_UNSIGNED: {
                return "div_u";
            }
            case REM_SIGNED: {
                return "rem_s";
            }
            case REM_UNSIGNED: {
                return "rem_u";
            }
            case AND: {
                return "and";
            }
            case OR: {
                return "or";
            }
            case XOR: {
                return "xor";
            }
            case EQ: {
                return "eq";
            }
            case NE: {
                return "ne";
            }
            case GT_SIGNED: {
                return "gt_s";
            }
            case GT_UNSIGNED: {
                return "gt_u";
            }
            case GE_SIGNED: {
                return "ge_s";
            }
            case GE_UNSIGNED: {
                return "ge_u";
            }
            case LT_SIGNED: {
                return "lt_s";
            }
            case LT_UNSIGNED: {
                return "lt_u";
            }
            case LE_SIGNED: {
                return "le_s";
            }
            case LE_UNSIGNED: {
                return "le_u";
            }
            case SHL: {
                return "shl";
            }
            case SHR_SIGNED: {
                return "shr_s";
            }
            case SHR_UNSIGNED: {
                return "shr_u";
            }
            case ROTL: {
                return "rotl";
            }
            case ROTR: {
                return "rotr";
            }
        }
        throw new AssertionError((Object)operation.toString());
    }

    private String operation(WasmIntUnaryOperation operation) {
        switch (operation) {
            case EQZ: {
                return "eqz";
            }
            case CLZ: {
                return "clz";
            }
            case CTZ: {
                return "ctz";
            }
            case POPCNT: {
                return "popcnt";
            }
        }
        throw new AssertionError((Object)operation.toString());
    }

    private String operation(WasmFloatBinaryOperation operation) {
        switch (operation) {
            case ADD: {
                return "add";
            }
            case SUB: {
                return "sub";
            }
            case MUL: {
                return "mul";
            }
            case DIV: {
                return "div";
            }
            case EQ: {
                return "eq";
            }
            case NE: {
                return "ne";
            }
            case GT: {
                return "gt";
            }
            case GE: {
                return "ge";
            }
            case LT: {
                return "lt";
            }
            case LE: {
                return "le";
            }
            case MIN: {
                return "min";
            }
            case MAX: {
                return "max";
            }
        }
        throw new AssertionError((Object)operation.toString());
    }

    private String operation(WasmFloatUnaryOperation operation) {
        switch (operation) {
            case ABS: {
                return "abs";
            }
            case NEG: {
                return "neg";
            }
            case COPYSIGN: {
                break;
            }
            case CEIL: {
                return "ceil";
            }
            case FLOOR: {
                return "floor";
            }
            case TRUNC: {
                return "trunc";
            }
            case NEAREST: {
                return "nearest";
            }
            case SQRT: {
                return "sqrt";
            }
        }
        throw new AssertionError((Object)operation.toString());
    }
}

