/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model;

import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmStorageType;

public abstract class WasmType {
    public static final Number INT32 = new Number(WasmNumType.INT32);
    public static final Number INT64 = new Number(WasmNumType.INT64);
    public static final Number FLOAT32 = new Number(WasmNumType.FLOAT32);
    public static final Number FLOAT64 = new Number(WasmNumType.FLOAT64);
    private WasmStorageType.Regular storageType;

    private WasmType() {
    }

    public WasmStorageType.Regular asStorage() {
        if (this.storageType == null) {
            this.storageType = new WasmStorageType.Regular(this);
        }
        return this.storageType;
    }

    public static Number num(WasmNumType number) {
        switch (number) {
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case FLOAT32: {
                return FLOAT32;
            }
            case FLOAT64: {
                return FLOAT64;
            }
        }
        throw new IllegalArgumentException();
    }

    public static final class Number
    extends WasmType {
        public final WasmNumType number;

        private Number(WasmNumType number) {
            this.number = number;
        }
    }

    public static enum SpecialReferenceKind {
        FUNC,
        ANY,
        EXTERN,
        STRUCT,
        ARRAY;

        private SpecialReference type;

        final SpecialReference asType() {
            if (this.type == null) {
                this.type = new SpecialReference(this);
            }
            return this.type;
        }
    }

    public static final class SpecialReference
    extends WasmType {
        public final SpecialReferenceKind kind;

        private SpecialReference(SpecialReferenceKind kind) {
            this.kind = kind;
        }
    }

    public static final class CompositeReference
    extends Reference {
        public final WasmCompositeType composite;

        CompositeReference(WasmCompositeType composite) {
            this.composite = composite;
        }
    }

    public static abstract class Reference
    extends WasmType {
        public static final SpecialReference FUNC = SpecialReferenceKind.FUNC.asType();
        public static final SpecialReference ANY = SpecialReferenceKind.ANY.asType();
        public static final SpecialReference EXTERN = SpecialReferenceKind.EXTERN.asType();
        public static final SpecialReference STRUCT = SpecialReferenceKind.STRUCT.asType();
        public static final SpecialReference ARRAY = SpecialReferenceKind.ARRAY.asType();
    }
}

