/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.strings;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCStandardClasses;
import org.teavm.backend.wasm.generate.gc.initialization.WasmGCInitializerContributor;
import org.teavm.backend.wasm.generate.gc.method.WasmGCFunctionProvider;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringConstant;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.render.WasmBinaryWriter;
import org.teavm.model.MethodReference;

public class WasmGCStringPool
implements WasmGCStringProvider,
WasmGCInitializerContributor {
    private WasmGCStandardClasses standardClasses;
    private WasmModule module;
    private WasmBinaryWriter binaryWriter = new WasmBinaryWriter();
    private Map<String, WasmGCStringConstant> stringMap = new LinkedHashMap<String, WasmGCStringConstant>();
    private WasmGCFunctionProvider functionProvider;

    public WasmGCStringPool(WasmGCStandardClasses standardClasses, WasmModule module, WasmGCFunctionProvider functionProvider) {
        this.standardClasses = standardClasses;
        this.module = module;
        this.functionProvider = functionProvider;
    }

    @Override
    public void contributeToInitializerDefinitions(WasmFunction function) {
        for (WasmGCStringConstant str : this.stringMap.values()) {
            WasmStructNewDefault newStruct = new WasmStructNewDefault(this.standardClasses.stringClass().getStructure());
            function.getBody().add(new WasmSetGlobal(str.global, newStruct));
        }
    }

    @Override
    public void contributeToInitializer(WasmFunction function) {
        WasmFunction nextCharArrayFunction = this.functionProvider.getStaticFunction(new MethodReference(WasmGCStringPool.class, "nextCharArray", char[].class));
    }

    @Override
    public WasmGCStringConstant getStringConstant(String string) {
        return this.stringMap.computeIfAbsent(string, s -> {
            this.binaryWriter.writeInt32(string.length());
            this.binaryWriter.writeBytes(string.getBytes(StandardCharsets.UTF_8));
            String globalName = "_teavm_java_string_" + this.stringMap.size();
            WasmType.CompositeReference globalType = this.standardClasses.stringClass().getType();
            WasmGlobal global = new WasmGlobal(globalName, globalType, WasmExpression.defaultValueOfType(globalType));
            this.module.globals.add(global);
            return new WasmGCStringConstant(this.stringMap.size(), global);
        });
    }

    static char[] nextCharArray() {
        int length = WasmGCStringPool.nextLEB();
        char[] result = new char[length];
        int pos = 0;
        while (pos < length) {
            byte b3;
            byte b2;
            byte b = WasmGCStringPool.nextByte();
            if ((b & 0x80) == 0) {
                result[pos++] = (char)b;
                continue;
            }
            if ((b & 0xE0) == 192) {
                b2 = WasmGCStringPool.nextByte();
                result[pos++] = (char)((b & 0x1F) << 6 | b2 & 0x3F);
                continue;
            }
            if ((b & 0xF0) == 224) {
                b2 = WasmGCStringPool.nextByte();
                b3 = WasmGCStringPool.nextByte();
                char c = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                result[pos++] = c;
                continue;
            }
            if ((b & 0xF8) != 240) continue;
            b2 = WasmGCStringPool.nextByte();
            b3 = WasmGCStringPool.nextByte();
            byte b4 = WasmGCStringPool.nextByte();
            int code = (b & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
            result[pos++] = Character.highSurrogate(code);
            result[pos++] = Character.lowSurrogate(code);
        }
        return result;
    }

    private static int nextLEB() {
        int shift = 0;
        int result = 0;
        while (true) {
            byte b = WasmGCStringPool.nextByte();
            int digit = b & 0x7F;
            result |= digit << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    private static native byte nextByte();

    private static native void error();
}

