/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.classes;

import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.model.WasmPackedType;
import org.teavm.backend.wasm.model.WasmStorageType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.model.ValueType;

public class WasmGCTypeMapper {
    private WasmGCClassInfoProvider classInfoProvider;

    WasmGCTypeMapper(WasmGCClassInfoProvider classInfoProvider) {
        this.classInfoProvider = classInfoProvider;
    }

    public WasmStorageType mapType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BYTE: 
                case BOOLEAN: {
                    return WasmStorageType.packed(WasmPackedType.INT8);
                }
                case SHORT: 
                case CHARACTER: {
                    return WasmStorageType.packed(WasmPackedType.INT8);
                }
                case INTEGER: {
                    return WasmType.INT32.asStorage();
                }
                case LONG: {
                    return WasmType.INT64.asStorage();
                }
                case FLOAT: {
                    return WasmType.FLOAT32.asStorage();
                }
                case DOUBLE: {
                    return WasmType.FLOAT64.asStorage();
                }
            }
            throw new IllegalArgumentException();
        }
        return this.classInfoProvider.getClassInfo(type).getType().asStorage();
    }
}

