/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.disasm;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.function.Consumer;
import org.teavm.backend.wasm.disasm.DisassemblyWriter;
import org.teavm.backend.wasm.model.WasmNumType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmFloatBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmFloatUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmInt64Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.parser.AddressListener;
import org.teavm.backend.wasm.parser.BranchOpcode;
import org.teavm.backend.wasm.parser.CodeListener;
import org.teavm.backend.wasm.parser.CodeSectionListener;
import org.teavm.backend.wasm.parser.CodeSectionParser;
import org.teavm.backend.wasm.parser.LocalOpcode;
import org.teavm.backend.wasm.parser.ModuleParser;
import org.teavm.backend.wasm.parser.Opcode;
import org.teavm.common.ByteArrayAsyncInputStream;

public class DisassemblyCodeSectionListener
implements AddressListener,
CodeSectionListener,
CodeListener {
    private DisassemblyWriter writer;
    private int address;
    private int blockIdGen;

    public DisassemblyCodeSectionListener(DisassemblyWriter writer) {
        this.writer = writer;
    }

    @Override
    public void address(int address) {
        this.address = address;
    }

    @Override
    public void sectionStart(int functionCount) {
        this.writer.address(this.address).write("(; code section ;)").eol();
    }

    @Override
    public boolean functionStart(int index, int size) {
        this.writer.address(this.address).write("(func $fun_" + index).indent().eol();
        return true;
    }

    @Override
    public void localsStart(int count) {
        this.writer.address(this.address).write("(; locals " + count + " ;)").eol();
    }

    @Override
    public void local(int start, int count, WasmType type) {
        this.writer.address(this.address);
        for (int i = 0; i < count; ++i) {
            this.writer.write("(local $loc_" + (i + start) + " " + this.typeToString(type) + ")").eol();
        }
    }

    @Override
    public CodeListener code() {
        this.blockIdGen = 0;
        return this;
    }

    @Override
    public void functionEnd() {
        this.writer.outdent().write(")").eol();
    }

    @Override
    public void sectionEnd() {
        this.writer.outdent().write(")").eol();
    }

    private String blockTypeToString(WasmType type) {
        if (type == null) {
            return "";
        }
        return " " + this.typeToString(type);
    }

    private String typeToString(WasmType type) {
        if (type != null) {
            if (type instanceof WasmType.Number) {
                switch (((WasmType.Number)type).number) {
                    case INT32: {
                        return "i32";
                    }
                    case INT64: {
                        return "i64";
                    }
                    case FLOAT32: {
                        return "f32";
                    }
                    case FLOAT64: {
                        return "f64";
                    }
                }
            } else if (type instanceof WasmType.Reference) {
                return "ref";
            }
        }
        return "unknown";
    }

    @Override
    public void error(int depth) {
        this.writer.address(this.address);
        this.writer.write("error").eol();
        for (int i = 0; i < depth; ++i) {
            this.writer.outdent();
        }
    }

    @Override
    public int startBlock(boolean loop, WasmType type) {
        this.writer.address(this.address);
        int label = this.blockIdGen++;
        this.writer.write(loop ? "loop" : "block").write(" $label_" + label).write(this.blockTypeToString(type)).indent().eol();
        return label;
    }

    @Override
    public int startConditionalBlock(WasmType type) {
        this.writer.address(this.address);
        int label = this.blockIdGen++;
        this.writer.write("if ").write(" $label_" + label).write(this.blockTypeToString(type)).indent().eol();
        return label;
    }

    @Override
    public void startElseSection(int token) {
        this.writer.address(this.address);
        this.writer.outdent().write("else  (; $label_" + token + " ;)").indent().eol();
    }

    @Override
    public void endBlock(int token, boolean loop) {
        this.writer.address(this.address).outdent().write("end  (; $label_" + token + " ;)").eol();
    }

    @Override
    public void branch(BranchOpcode opcode, int depth, int target) {
        this.writer.address(this.address);
        switch (opcode) {
            case BR: {
                this.writer.write("br");
                break;
            }
            case BR_IF: {
                this.writer.write("br_if");
            }
        }
        this.writer.write(" $label_" + target).eol();
    }

    @Override
    public void tableBranch(int[] depths, int[] targets, int defaultDepth, int defaultTarget) {
        this.writer.address(this.address);
        this.writer.write("br_table");
        for (int target : targets) {
            this.writer.write(" $label_" + target);
        }
        this.writer.write(" $label_" + defaultTarget).eol();
    }

    @Override
    public void opcode(Opcode opcode) {
        this.writer.address(this.address);
        switch (opcode) {
            case UNREACHABLE: {
                this.writer.write("unreachable");
                break;
            }
            case NOP: {
                this.writer.write("nop");
                break;
            }
            case RETURN: {
                this.writer.write("return");
                break;
            }
            case DROP: {
                this.writer.write("drop");
            }
        }
        this.writer.eol();
    }

    @Override
    public void local(LocalOpcode opcode, int index) {
        this.writer.address(this.address);
        switch (opcode) {
            case GET: {
                this.writer.write("local.get");
                break;
            }
            case SET: {
                this.writer.write("local.set");
            }
        }
        this.writer.write(" $loc_" + index).eol();
    }

    @Override
    public void call(int functionIndex) {
        this.writer.address(this.address);
        this.writer.write("call $fun_" + functionIndex).eol();
    }

    @Override
    public void indirectCall(int typeIndex, int tableIndex) {
        this.writer.address(this.address);
        this.writer.write("call_indirect $table_" + tableIndex + " $type_" + typeIndex).eol();
    }

    @Override
    public void loadInt32(WasmInt32Subtype convertFrom, int align, int offset) {
        this.writer.address(this.address);
        int defaultAlign = 0;
        switch (convertFrom) {
            case INT8: {
                this.writer.write("i32.load8_s");
                defaultAlign = 1;
                break;
            }
            case UINT8: {
                this.writer.write("i32.load8_u");
                defaultAlign = 1;
                break;
            }
            case INT16: {
                this.writer.write("i32.load16_s");
                defaultAlign = 2;
                break;
            }
            case UINT16: {
                this.writer.write("i32.load16_u");
                defaultAlign = 2;
                break;
            }
            case INT32: {
                this.writer.write("i32.load");
                defaultAlign = 4;
            }
        }
        this.writeMemArg(align, defaultAlign, offset);
        this.writer.eol();
    }

    @Override
    public void storeInt32(WasmInt32Subtype convertTo, int align, int offset) {
        this.writer.address(this.address);
        int defaultAlign = 0;
        switch (convertTo) {
            case INT8: 
            case UINT8: {
                this.writer.write("i32.store8");
                defaultAlign = 1;
                break;
            }
            case INT16: 
            case UINT16: {
                this.writer.write("i32.store16");
                defaultAlign = 2;
                break;
            }
            case INT32: {
                this.writer.write("i32.store");
                defaultAlign = 4;
            }
        }
        this.writeMemArg(align, defaultAlign, offset);
        this.writer.eol();
    }

    @Override
    public void loadInt64(WasmInt64Subtype convertFrom, int align, int offset) {
        this.writer.address(this.address);
        int defaultAlign = 0;
        switch (convertFrom) {
            case INT8: {
                this.writer.write("i64.load8_s");
                defaultAlign = 1;
                break;
            }
            case UINT8: {
                this.writer.write("i64.load8_u");
                defaultAlign = 1;
                break;
            }
            case INT16: {
                this.writer.write("i64.load16_s");
                defaultAlign = 2;
                break;
            }
            case UINT16: {
                this.writer.write("i64.load16_u");
                defaultAlign = 2;
                break;
            }
            case INT32: {
                this.writer.write("i64.load32_s");
                defaultAlign = 4;
                break;
            }
            case UINT32: {
                this.writer.write("i64.load32_u");
                defaultAlign = 4;
                break;
            }
            case INT64: {
                this.writer.write("i64.load");
                defaultAlign = 8;
            }
        }
        this.writeMemArg(align, defaultAlign, offset);
        this.writer.eol();
    }

    @Override
    public void storeInt64(WasmInt64Subtype convertTo, int align, int offset) {
        this.writer.address(this.address);
        int defaultAlign = 0;
        switch (convertTo) {
            case INT8: 
            case UINT8: {
                this.writer.write("i64.store8");
                defaultAlign = 1;
                break;
            }
            case INT16: 
            case UINT16: {
                this.writer.write("i64.store16");
                defaultAlign = 2;
                break;
            }
            case INT32: 
            case UINT32: {
                this.writer.write("i64.store32");
                defaultAlign = 4;
                break;
            }
            case INT64: {
                this.writer.write("i64.store");
                defaultAlign = 8;
            }
        }
        this.writeMemArg(align, defaultAlign, offset);
        this.writer.eol();
    }

    @Override
    public void loadFloat32(int align, int offset) {
        this.writer.address(this.address).write("f32.load");
        this.writeMemArg(align, 4, offset);
        this.writer.eol();
    }

    @Override
    public void storeFloat32(int align, int offset) {
        this.writer.address(this.address).write("f32.store");
        this.writeMemArg(align, 4, offset);
        this.writer.eol();
    }

    @Override
    public void loadFloat64(int align, int offset) {
        this.writer.address(this.address).write("f64.load");
        this.writeMemArg(align, 8, offset);
        this.writer.eol();
    }

    @Override
    public void storeFloat64(int align, int offset) {
        this.writer.address(this.address).write("f64.store");
        this.writeMemArg(align, 8, offset);
        this.writer.eol();
    }

    @Override
    public void memoryGrow() {
        this.writer.address(this.address).write("memory.grow").eol();
    }

    @Override
    public void memoryFill() {
        this.writer.address(this.address).write("memory.fill").eol();
    }

    @Override
    public void memoryCopy() {
        this.writer.address(this.address).write("memory.copy").eol();
    }

    private void writeMemArg(int align, int defaultAlign, int offset) {
        boolean needsComma = false;
        if (align != defaultAlign) {
            this.writer.write(" align=" + align);
            needsComma = true;
        }
        if (offset != 0) {
            if (needsComma) {
                this.writer.write(",");
            }
            this.writer.write(" offset=" + offset);
        }
    }

    @Override
    public void unary(WasmIntUnaryOperation opcode, WasmIntType type) {
        this.writer.address(this.address);
        switch (type) {
            case INT32: {
                this.writer.write("i32.");
                break;
            }
            case INT64: {
                this.writer.write("i64.");
            }
        }
        switch (opcode) {
            case CLZ: {
                this.writer.write("clz");
                break;
            }
            case CTZ: {
                this.writer.write("ctz");
                break;
            }
            case POPCNT: {
                this.writer.write("popcnt");
            }
        }
        this.writer.eol();
    }

    @Override
    public void unary(WasmFloatUnaryOperation opcode, WasmFloatType type) {
        this.writer.address(this.address);
        switch (type) {
            case FLOAT32: {
                this.writer.write("f32.");
                break;
            }
            case FLOAT64: {
                this.writer.write("f64.");
            }
        }
        switch (opcode) {
            case ABS: {
                this.writer.write("abs");
                break;
            }
            case NEG: {
                this.writer.write("neg");
                break;
            }
            case FLOOR: {
                this.writer.write("floor");
                break;
            }
            case CEIL: {
                this.writer.write("ceil");
                break;
            }
            case TRUNC: {
                this.writer.write("trunc");
                break;
            }
            case NEAREST: {
                this.writer.write("nearest");
                break;
            }
            case SQRT: {
                this.writer.write("sqrt");
                break;
            }
            case COPYSIGN: {
                this.writer.write("copysign");
            }
        }
        this.writer.eol();
    }

    @Override
    public void binary(WasmIntBinaryOperation opcode, WasmIntType type) {
        this.writer.address(this.address);
        switch (type) {
            case INT32: {
                this.writer.write("i32.");
                break;
            }
            case INT64: {
                this.writer.write("i64.");
            }
        }
        switch (opcode) {
            case ADD: {
                this.writer.write("add");
                break;
            }
            case SUB: {
                this.writer.write("sub");
                break;
            }
            case MUL: {
                this.writer.write("mul");
                break;
            }
            case DIV_SIGNED: {
                this.writer.write("div_s");
                break;
            }
            case DIV_UNSIGNED: {
                this.writer.write("div_u");
                break;
            }
            case REM_SIGNED: {
                this.writer.write("rem_s");
                break;
            }
            case REM_UNSIGNED: {
                this.writer.write("rem_u");
                break;
            }
            case AND: {
                this.writer.write("and");
                break;
            }
            case OR: {
                this.writer.write("or");
                break;
            }
            case XOR: {
                this.writer.write("xor");
                break;
            }
            case SHL: {
                this.writer.write("shl");
                break;
            }
            case SHR_SIGNED: {
                this.writer.write("shr_s");
                break;
            }
            case SHR_UNSIGNED: {
                this.writer.write("shr_u");
                break;
            }
            case ROTL: {
                this.writer.write("rotl");
                break;
            }
            case ROTR: {
                this.writer.write("rotr");
                break;
            }
            case EQ: {
                this.writer.write("eq");
                break;
            }
            case NE: {
                this.writer.write("ne");
                break;
            }
            case LT_SIGNED: {
                this.writer.write("lt_s");
                break;
            }
            case LT_UNSIGNED: {
                this.writer.write("lt_u");
                break;
            }
            case GT_SIGNED: {
                this.writer.write("gt_s");
                break;
            }
            case GT_UNSIGNED: {
                this.writer.write("gt_u");
                break;
            }
            case LE_SIGNED: {
                this.writer.write("le_s");
                break;
            }
            case LE_UNSIGNED: {
                this.writer.write("le_u");
                break;
            }
            case GE_SIGNED: {
                this.writer.write("ge_s");
                break;
            }
            case GE_UNSIGNED: {
                this.writer.write("ge_u");
            }
        }
        this.writer.eol();
    }

    @Override
    public void binary(WasmFloatBinaryOperation opcode, WasmFloatType type) {
        this.writer.address(this.address);
        switch (type) {
            case FLOAT32: {
                this.writer.write("f32.");
                break;
            }
            case FLOAT64: {
                this.writer.write("f64.");
            }
        }
        switch (opcode) {
            case ADD: {
                this.writer.write("add");
                break;
            }
            case SUB: {
                this.writer.write("sub");
                break;
            }
            case MUL: {
                this.writer.write("mul");
                break;
            }
            case DIV: {
                this.writer.write("div");
                break;
            }
            case MIN: {
                this.writer.write("min");
                break;
            }
            case MAX: {
                this.writer.write("max");
                break;
            }
            case EQ: {
                this.writer.write("eq");
                break;
            }
            case NE: {
                this.writer.write("ne");
                break;
            }
            case LT: {
                this.writer.write("lt");
                break;
            }
            case GT: {
                this.writer.write("gt");
                break;
            }
            case LE: {
                this.writer.write("le");
                break;
            }
            case GE: {
                this.writer.write("ge");
            }
        }
        this.writer.eol();
    }

    @Override
    public void convert(WasmNumType sourceType, WasmNumType targetType, boolean signed, boolean reinterpret) {
        block0 : switch (targetType) {
            case INT32: {
                this.writer.write("i32.");
                switch (sourceType) {
                    case FLOAT32: {
                        if (reinterpret) {
                            this.writer.write("reinterpret_f32");
                            break block0;
                        }
                        if (signed) {
                            this.writer.write("trunc_f32_s");
                            break block0;
                        }
                        this.writer.write("trunc_f32_u");
                        break block0;
                    }
                    case FLOAT64: {
                        if (signed) {
                            this.writer.write("trunc_f64_s");
                            break block0;
                        }
                        this.writer.write("trunc_f64_u");
                        break block0;
                    }
                    case INT64: {
                        this.writer.write("wrap_i64");
                        break block0;
                    }
                }
                this.writer.write("error");
                break;
            }
            case INT64: {
                this.writer.write("i64.");
                switch (sourceType) {
                    case FLOAT32: {
                        if (signed) {
                            this.writer.write("trunc_f32_s");
                            break block0;
                        }
                        this.writer.write("trunc_f32_u");
                        break block0;
                    }
                    case FLOAT64: {
                        if (reinterpret) {
                            this.writer.write("reinterpret_f64");
                            break block0;
                        }
                        if (signed) {
                            this.writer.write("trunc_f64_s");
                            break block0;
                        }
                        this.writer.write("trunc_f64_u");
                        break block0;
                    }
                    case INT32: {
                        if (signed) {
                            this.writer.write("extend_i32_s");
                            break block0;
                        }
                        this.writer.write("extend_i32_u");
                        break block0;
                    }
                }
                this.writer.write("error");
                break;
            }
            case FLOAT32: {
                this.writer.write("f32.");
                switch (sourceType) {
                    case INT32: {
                        if (reinterpret) {
                            this.writer.write("reinterpret_i32");
                            break block0;
                        }
                        if (signed) {
                            this.writer.write("convert_i32_s");
                            break block0;
                        }
                        this.writer.write("convert_i32_u");
                        break block0;
                    }
                    case INT64: {
                        if (signed) {
                            this.writer.write("convert_i64_s");
                            break block0;
                        }
                        this.writer.write("convert_i64_u");
                        break block0;
                    }
                    case FLOAT64: {
                        this.writer.write("demote_f64");
                        break block0;
                    }
                }
                this.writer.write("error");
                break;
            }
            case FLOAT64: {
                this.writer.write("f64.");
                switch (sourceType) {
                    case INT32: {
                        if (signed) {
                            this.writer.write("convert_i32_s");
                            break block0;
                        }
                        this.writer.write("convert_i32_u");
                        break block0;
                    }
                    case INT64: {
                        if (reinterpret) {
                            this.writer.write("reinterpret_i64");
                            break block0;
                        }
                        if (signed) {
                            this.writer.write("convert_i64_s");
                            break block0;
                        }
                        this.writer.write("convert_i64_u");
                        break block0;
                    }
                    case FLOAT32: {
                        this.writer.write("promote_f32");
                        break block0;
                    }
                }
                this.writer.write("error");
            }
        }
        this.writer.eol();
    }

    @Override
    public void int32Constant(int value) {
        this.writer.address(this.address).write("i32.const " + value).eol();
    }

    @Override
    public void int64Constant(long value) {
        this.writer.address(this.address).write("i64.const " + value).eol();
    }

    @Override
    public void float32Constant(float value) {
        this.writer.address(this.address).write("f32.const " + Float.toHexString(value)).eol();
    }

    @Override
    public void float64Constant(double value) {
        this.writer.address(this.address).write("f64.const " + Double.toHexString(value)).eol();
    }

    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        byte[] bytes = Files.readAllBytes(file.toPath());
        ByteArrayAsyncInputStream input = new ByteArrayAsyncInputStream(bytes);
        ModuleParser parser = new ModuleParser(input){

            @Override
            protected Consumer<byte[]> getSectionConsumer(int code, int pos, String name) {
                if (code == 10) {
                    return bytes -> {
                        PrintWriter out = new PrintWriter(System.out);
                        DisassemblyWriter writer = new DisassemblyWriter(out, true);
                        DisassemblyCodeSectionListener disassembler = new DisassemblyCodeSectionListener(writer);
                        CodeSectionParser sectionParser = new CodeSectionParser(disassembler, disassembler);
                        sectionParser.parse((byte[])bytes);
                        out.flush();
                    };
                }
                return null;
            }
        };
        input.readFully((parser)::parse);
    }
}

