/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.info;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teavm.backend.wasm.debug.info.VariableRangeInfo;

public abstract class VariablesInfo {
    public abstract List<? extends VariableRangeInfo> ranges();

    public Collection<? extends VariableRangeInfo> find(int address) {
        ArrayList<VariableRangeInfo> result = new ArrayList<VariableRangeInfo>();
        for (VariableRangeInfo variableRangeInfo : this.ranges()) {
            if (address < variableRangeInfo.start() || address >= variableRangeInfo.end()) continue;
            result.add(variableRangeInfo);
        }
        return result;
    }

    public void dump(PrintStream out) {
        for (VariableRangeInfo variableRangeInfo : this.ranges()) {
            out.println(variableRangeInfo.variable().name() + ": " + variableRangeInfo.variable().type() + " - " + Integer.toHexString(variableRangeInfo.start()) + ".." + Integer.toHexString(variableRangeInfo.end()) + " at " + variableRangeInfo.index());
        }
    }
}

