/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WasmFunctionRepository {
    private WasmModule module;
    private WasmFunctionTypes functionTypes;
    private NameProvider nameProvider;
    private Map<MethodReference, WasmFunction> staticMethods = new HashMap<MethodReference, WasmFunction>();
    private Map<MethodReference, WasmFunction> instanceMethods = new HashMap<MethodReference, WasmFunction>();
    private Map<String, WasmFunction> classInitializers = new HashMap<String, WasmFunction>();
    private Map<ValueType, WasmFunction> supertypes = new HashMap<ValueType, WasmFunction>();

    public WasmFunctionRepository(WasmModule module, WasmFunctionTypes functionTypes, NameProvider nameProvider) {
        this.module = module;
        this.functionTypes = functionTypes;
        this.nameProvider = nameProvider;
    }

    public WasmFunction forMethod(MethodReader method) {
        return this.forMethod(method.getReference(), method.hasModifier(ElementModifier.STATIC));
    }

    public WasmFunction forMethod(MethodReference reference, boolean isStatic) {
        return isStatic ? this.forStaticMethod(reference) : this.forInstanceMethod(reference);
    }

    public WasmFunction forStaticMethod(MethodReference reference) {
        return this.staticMethods.computeIfAbsent(reference, key -> {
            WasmType[] wasmParams = new WasmType[key.parameterCount()];
            for (int i = 0; i < key.parameterCount(); ++i) {
                wasmParams[i] = WasmGeneratorUtil.mapType(reference.parameterType(i));
            }
            WasmFunctionType wasmType = this.functionTypes.of(WasmGeneratorUtil.mapType(key.getReturnType()), wasmParams);
            WasmFunction wasmFunction = new WasmFunction(wasmType);
            wasmFunction.setName(this.nameProvider.forMethod((MethodReference)key));
            wasmFunction.setJavaMethod((MethodReference)key);
            this.module.functions.add(wasmFunction);
            return wasmFunction;
        });
    }

    public WasmFunction forInstanceMethod(MethodReference reference) {
        return this.instanceMethods.computeIfAbsent(reference, key -> {
            WasmType[] wasmParams = new WasmType[key.parameterCount() + 1];
            wasmParams[0] = WasmGeneratorUtil.mapType(ValueType.object(reference.getClassName()));
            for (int i = 0; i < key.parameterCount(); ++i) {
                wasmParams[i + 1] = WasmGeneratorUtil.mapType(reference.parameterType(i));
            }
            WasmFunctionType wasmType = this.functionTypes.of(WasmGeneratorUtil.mapType(key.getReturnType()), wasmParams);
            WasmFunction wasmFunction = new WasmFunction(wasmType);
            wasmFunction.setName(this.nameProvider.forMethod((MethodReference)key));
            wasmFunction.setJavaMethod((MethodReference)key);
            this.module.functions.add(wasmFunction);
            return wasmFunction;
        });
    }

    public WasmFunction forClassInitializer(String className) {
        return this.classInitializers.computeIfAbsent(className, key -> {
            WasmFunction wasmFunction = new WasmFunction(this.functionTypes.of(null, new WasmType[0]));
            wasmFunction.setName(this.nameProvider.forClassInitializer((String)key));
            this.module.functions.add(wasmFunction);
            return wasmFunction;
        });
    }

    public WasmFunction forSupertype(ValueType type) {
        return this.supertypes.computeIfAbsent(type, key -> {
            WasmFunction wasmFunction = new WasmFunction(this.functionTypes.of(WasmType.INT32, WasmType.INT32));
            wasmFunction.setName(this.nameProvider.forSupertypeFunction((ValueType)key));
            this.module.functions.add(wasmFunction);
            return wasmFunction;
        });
    }
}

