/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.util;

import org.teavm.ast.ConstantExpr;
import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.CallLocation;
import org.teavm.model.ValueType;

public final class ConstantUtil {
    private ConstantUtil() {
    }

    public static String getClassLiteral(IntrinsicContext context, InvocationExpr invocation, Expr expr) {
        Object cst;
        if (expr instanceof ConstantExpr && (cst = ((ConstantExpr)expr).getValue()) instanceof ValueType.Object) {
            return ((ValueType.Object)cst).getClassName();
        }
        context.diagnotics().error(new CallLocation(context.callingMethod(), invocation.getLocation()), "This method should take class literal", new Object[0]);
        return "java.lang.Object";
    }

    public static String getStringLiteral(IntrinsicContext context, InvocationExpr invocation, Expr expr) {
        Object cst;
        if (expr instanceof ConstantExpr && (cst = ((ConstantExpr)expr).getValue()) instanceof String) {
            return (String)cst;
        }
        context.diagnotics().error(new CallLocation(context.callingMethod(), invocation.getLocation()), "This method should take string literal", new Object[0]);
        return "";
    }
}

