/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;

public final class VariableUsageGraphBuilder {
    private VariableUsageGraphBuilder() {
    }

    public static Graph build(Program program) {
        GraphBuilder builder = new GraphBuilder(program.variableCount());
        InstructionAnalyzer analyzer = new InstructionAnalyzer(builder);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block.getInstructions()) {
                insn.acceptVisitor(analyzer);
            }
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    builder.addEdge(incoming.getValue().getIndex(), phi.getReceiver().getIndex());
                }
            }
        }
        return builder.build();
    }

    private static class InstructionAnalyzer
    implements InstructionVisitor {
        private GraphBuilder builder;

        public InstructionAnalyzer(GraphBuilder builder) {
            this.builder = builder;
        }

        private void use(Variable receiver, Variable ... arguments) {
            for (Variable arg : arguments) {
                this.builder.addEdge(arg.getIndex(), receiver.getIndex());
            }
        }

        @Override
        public void visit(EmptyInstruction insn) {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
        }

        @Override
        public void visit(NullConstantInstruction insn) {
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
        }

        @Override
        public void visit(LongConstantInstruction insn) {
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
        }

        @Override
        public void visit(StringConstantInstruction insn) {
        }

        @Override
        public void visit(BinaryInstruction insn) {
            this.use(insn.getReceiver(), insn.getFirstOperand(), insn.getSecondOperand());
        }

        @Override
        public void visit(NegateInstruction insn) {
            this.use(insn.getReceiver(), insn.getOperand());
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.use(insn.getReceiver(), insn.getAssignee());
        }

        @Override
        public void visit(CastInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(BranchingInstruction insn) {
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
        }

        @Override
        public void visit(JumpInstruction insn) {
        }

        @Override
        public void visit(SwitchInstruction insn) {
        }

        @Override
        public void visit(ExitInstruction insn) {
        }

        @Override
        public void visit(RaiseInstruction insn) {
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            this.use(insn.getReceiver(), insn.getSize());
        }

        @Override
        public void visit(ConstructInstruction insn) {
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            this.use(insn.getReceiver(), insn.getDimensions().toArray(new Variable[0]));
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (insn.getInstance() != null) {
                this.use(insn.getReceiver(), insn.getInstance());
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            this.use(insn.getReceiver(), insn.getArray());
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.use(insn.getReceiver(), insn.getArray());
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.use(insn.getReceiver(), insn.getArray());
        }

        @Override
        public void visit(GetElementInstruction insn) {
            this.use(insn.getReceiver(), insn.getArray(), insn.getIndex());
        }

        @Override
        public void visit(PutElementInstruction insn) {
        }

        @Override
        public void visit(InvokeInstruction insn) {
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }

        @Override
        public void visit(InitClassInstruction insn) {
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            this.use(insn.getReceiver(), insn.getValue());
        }
    }
}

