/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import org.teavm.model.BasicBlock;
import org.teavm.model.MethodReader;
import org.teavm.model.Program;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.util.BasicBlockMapper;
import org.teavm.optimization.MethodOptimization;

public class EmptyBlockElimination
implements MethodOptimization {
    @Override
    public void optimize(MethodReader method, final Program program) {
        int i;
        final int[] blockMapping = new int[program.basicBlockCount()];
        for (int i2 = 0; i2 < blockMapping.length; ++i2) {
            blockMapping[i2] = i2;
        }
        int lastNonEmpty = program.basicBlockCount() - 1;
        for (i = program.basicBlockCount() - 2; i > 0; --i) {
            JumpInstruction insn;
            BasicBlock block = program.basicBlockAt(i);
            if (block.getPhis().isEmpty() && block.getInstructions().size() == 1 && block.getLastInstruction() instanceof JumpInstruction && (insn = (JumpInstruction)block.getLastInstruction()).getTarget().getIndex() == i + 1) {
                blockMapping[i] = lastNonEmpty;
            }
            lastNonEmpty = blockMapping[i];
        }
        new BasicBlockMapper(){

            @Override
            protected BasicBlock map(BasicBlock block) {
                return program.basicBlockAt(blockMapping[block.getIndex()]);
            }
        }.transform(program);
        for (i = 0; i < program.basicBlockCount(); ++i) {
            if (blockMapping[i] == i) continue;
            program.deleteBasicBlock(i);
        }
        program.pack();
    }
}

