/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import java.util.HashSet;
import java.util.Set;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;

public class Devirtualization {
    private DependencyInfo dependency;
    private ClassReaderSource classSource;

    public Devirtualization(DependencyInfo dependency, ClassReaderSource classSource) {
        this.dependency = dependency;
        this.classSource = classSource;
    }

    public void apply(MethodHolder method) {
        MethodDependencyInfo methodDep = this.dependency.getMethod(method.getReference());
        if (methodDep == null) {
            return;
        }
        Program program = method.getProgram();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block.getInstructions()) {
                ValueDependencyInfo var;
                Set<MethodReference> implementations;
                InvokeInstruction invoke;
                if (!(insn instanceof InvokeInstruction) || (invoke = (InvokeInstruction)insn).getType() != InvocationType.VIRTUAL || (implementations = this.getImplementations((var = methodDep.getVariable(invoke.getInstance().getIndex())).getTypes(), invoke.getMethod())).size() != 1) continue;
                invoke.setType(InvocationType.SPECIAL);
                invoke.setMethod(implementations.iterator().next());
            }
        }
    }

    private Set<MethodReference> getImplementations(String[] classNames, MethodReference ref) {
        HashSet<MethodReference> methods = new HashSet<MethodReference>();
        for (String className : classNames) {
            MethodDependencyInfo methodDep;
            ClassReader cls;
            if (className.startsWith("[")) {
                className = "java.lang.Object";
            }
            if ((cls = this.classSource.get(className)) == null || !this.isAssignable(ref.getClassName(), cls) || (methodDep = this.dependency.getMethod(new MethodReference(className, ref.getDescriptor()))) == null) continue;
            methods.add(methodDep.getReference());
        }
        return methods;
    }

    private boolean isAssignable(String target, ClassReader cls) {
        ClassReader parent;
        if (cls.getName().equals(target)) {
            return true;
        }
        if (cls.getParent() != null && (parent = this.classSource.get(cls.getParent())) != null && this.isAssignable(target, parent)) {
            return true;
        }
        for (String ifaceName : cls.getInterfaces()) {
            ClassReader iface = this.classSource.get(ifaceName);
            if (iface == null || !this.isAssignable(target, iface)) continue;
            return true;
        }
        return false;
    }
}

