/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.InstructionTransitionExtractor;

public final class ProgramUtils {
    private ProgramUtils() {
    }

    public static Graph buildControlFlowGraphWithoutTryCatch(Program program) {
        GraphBuilder graphBuilder = new GraphBuilder(program.basicBlockCount());
        InstructionTransitionExtractor transitionExtractor = new InstructionTransitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getLastInstruction();
            if (insn == null) continue;
            insn.acceptVisitor(transitionExtractor);
            if (transitionExtractor.getTargets() == null) continue;
            for (BasicBlock successor : transitionExtractor.getTargets()) {
                graphBuilder.addEdge(i, successor.getIndex());
            }
        }
        return graphBuilder.build();
    }

    public static Graph buildControlFlowGraph(Program program) {
        GraphBuilder graphBuilder = new GraphBuilder(program.basicBlockCount());
        InstructionTransitionExtractor transitionExtractor = new InstructionTransitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getLastInstruction();
            if (insn != null) {
                insn.acceptVisitor(transitionExtractor);
                if (transitionExtractor.getTargets() != null) {
                    for (BasicBlock successor : transitionExtractor.getTargets()) {
                        graphBuilder.addEdge(i, successor.getIndex());
                    }
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                graphBuilder.addEdge(i, tryCatch.getHandler().getIndex());
            }
        }
        return graphBuilder.build();
    }

    public static Program copy(Program program) {
        int i;
        Program copy = new Program();
        CopyVisitor insnCopier = new CopyVisitor();
        insnCopier.programCopy = copy;
        for (i = 0; i < program.variableCount(); ++i) {
            copy.createVariable();
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            copy.createBasicBlock();
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            BasicBlock blockCopy = copy.basicBlockAt(i);
            for (Instruction insn : block.getInstructions()) {
                insn.acceptVisitor(insnCopier);
                blockCopy.getInstructions().add(insnCopier.copy);
            }
            for (Phi phi : block.getPhis()) {
                Phi phiCopy = new Phi();
                phiCopy.setReceiver(copy.variableAt(phi.getReceiver().getIndex()));
                for (Incoming incoming : phi.getIncomings()) {
                    Incoming incomingCopy = new Incoming();
                    incomingCopy.setSource(copy.basicBlockAt(incoming.getSource().getIndex()));
                    incomingCopy.setValue(copy.variableAt(incoming.getValue().getIndex()));
                    phiCopy.getIncomings().add(incomingCopy);
                }
                blockCopy.getPhis().add(phiCopy);
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                TryCatchBlock tryCatchCopy = new TryCatchBlock();
                tryCatchCopy.setExceptionType(tryCatch.getExceptionType());
                tryCatchCopy.setExceptionVariable(copy.variableAt(tryCatch.getExceptionVariable().getIndex()));
                tryCatchCopy.setHandler(copy.basicBlockAt(tryCatch.getHandler().getIndex()));
                blockCopy.getTryCatchBlocks().add(tryCatchCopy);
            }
        }
        return copy;
    }

    private static class CopyVisitor
    implements InstructionVisitor {
        Instruction copy;
        Program programCopy;

        private CopyVisitor() {
        }

        @Override
        public void visit(EmptyInstruction insn) {
            this.copy = new EmptyInstruction();
        }

        private Variable copyVar(Variable var) {
            return this.programCopy.variableAt(var.getIndex());
        }

        private BasicBlock copyBlock(BasicBlock block) {
            return this.programCopy.basicBlockAt(block.getIndex());
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            ClassConstantInstruction insnCopy = new ClassConstantInstruction();
            insnCopy.setConstant(insn.getConstant());
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            NullConstantInstruction insnCopy = new NullConstantInstruction();
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            IntegerConstantInstruction insnCopy = new IntegerConstantInstruction();
            insnCopy.setConstant(insn.getConstant());
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            LongConstantInstruction insnCopy = new LongConstantInstruction();
            insnCopy.setConstant(insn.getConstant());
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            FloatConstantInstruction insnCopy = new FloatConstantInstruction();
            insnCopy.setConstant(insn.getConstant());
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            DoubleConstantInstruction insnCopy = new DoubleConstantInstruction();
            insnCopy.setConstant(insn.getConstant());
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            StringConstantInstruction insnCopy = new StringConstantInstruction();
            insnCopy.setConstant(insn.getConstant());
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(BinaryInstruction insn) {
            BinaryInstruction insnCopy = new BinaryInstruction(insn.getOperation(), insn.getOperandType());
            insnCopy.setFirstOperand(this.copyVar(insn.getFirstOperand()));
            insnCopy.setSecondOperand(this.copyVar(insn.getSecondOperand()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(NegateInstruction insn) {
            NegateInstruction insnCopy = new NegateInstruction(insn.getOperandType());
            insnCopy.setOperand(this.copyVar(insn.getOperand()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(AssignInstruction insn) {
            AssignInstruction insnCopy = new AssignInstruction();
            insnCopy.setAssignee(this.copyVar(insn.getAssignee()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(CastInstruction insn) {
            CastInstruction insnCopy = new CastInstruction();
            insnCopy.setValue(this.copyVar(insn.getValue()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            insnCopy.setTargetType(insn.getTargetType());
            this.copy = insnCopy;
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            CastNumberInstruction insnCopy = new CastNumberInstruction(insn.getSourceType(), insn.getTargetType());
            insnCopy.setValue(this.copyVar(insn.getValue()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            CastIntegerInstruction insnCopy = new CastIntegerInstruction(insn.getTargetType(), insn.getDirection());
            insnCopy.setValue(this.copyVar(insn.getValue()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(BranchingInstruction insn) {
            BranchingInstruction insnCopy = new BranchingInstruction(insn.getCondition());
            insnCopy.setOperand(this.copyVar(insn.getOperand()));
            insnCopy.setConsequent(this.copyBlock(insn.getConsequent()));
            insnCopy.setAlternative(this.copyBlock(insn.getAlternative()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
            BinaryBranchingInstruction insnCopy = new BinaryBranchingInstruction(insn.getCondition());
            insnCopy.setFirstOperand(this.copyVar(insn.getFirstOperand()));
            insnCopy.setSecondOperand(this.copyVar(insn.getSecondOperand()));
            insnCopy.setConsequent(this.copyBlock(insn.getConsequent()));
            insnCopy.setAlternative(this.copyBlock(insn.getAlternative()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(JumpInstruction insn) {
            JumpInstruction insnCopy = new JumpInstruction();
            insnCopy.setTarget(this.copyBlock(insn.getTarget()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(SwitchInstruction insn) {
            SwitchInstruction insnCopy = new SwitchInstruction();
            insnCopy.setCondition(this.copyVar(insn.getCondition()));
            insnCopy.setDefaultTarget(this.copyBlock(insn.getDefaultTarget()));
            for (SwitchTableEntry entry : insn.getEntries()) {
                SwitchTableEntry entryCopy = new SwitchTableEntry();
                entryCopy.setCondition(entry.getCondition());
                entryCopy.setTarget(this.copyBlock(entry.getTarget()));
                insnCopy.getEntries().add(entryCopy);
            }
            this.copy = insnCopy;
        }

        @Override
        public void visit(ExitInstruction insn) {
            ExitInstruction insnCopy = new ExitInstruction();
            insnCopy.setValueToReturn(insn.getValueToReturn() != null ? this.copyVar(insn.getValueToReturn()) : null);
            this.copy = insnCopy;
        }

        @Override
        public void visit(RaiseInstruction insn) {
            RaiseInstruction insnCopy = new RaiseInstruction();
            insnCopy.setException(this.copyVar(insn.getException()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            ConstructArrayInstruction insnCopy = new ConstructArrayInstruction();
            insnCopy.setItemType(insn.getItemType());
            insnCopy.setSize(this.copyVar(insn.getSize()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(ConstructInstruction insn) {
            ConstructInstruction insnCopy = new ConstructInstruction();
            insnCopy.setType(insn.getType());
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            ConstructMultiArrayInstruction insnCopy = new ConstructMultiArrayInstruction();
            insnCopy.setItemType(insn.getItemType());
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            for (Variable dim : insn.getDimensions()) {
                insnCopy.getDimensions().add(this.copyVar(dim));
            }
            this.copy = insnCopy;
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            GetFieldInstruction insnCopy = new GetFieldInstruction();
            insnCopy.setField(insn.getField());
            insnCopy.setFieldType(insn.getFieldType());
            insnCopy.setInstance(insn.getInstance() != null ? this.copyVar(insn.getInstance()) : null);
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            PutFieldInstruction insnCopy = new PutFieldInstruction();
            insnCopy.setField(insn.getField());
            insnCopy.setInstance(insn.getInstance() != null ? this.copyVar(insn.getInstance()) : null);
            insnCopy.setValue(this.copyVar(insn.getValue()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            ArrayLengthInstruction insnCopy = new ArrayLengthInstruction();
            insnCopy.setArray(this.copyVar(insn.getArray()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            CloneArrayInstruction insnCopy = new CloneArrayInstruction();
            insnCopy.setArray(this.copyVar(insn.getArray()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            UnwrapArrayInstruction insnCopy = new UnwrapArrayInstruction(insn.getElementType());
            insnCopy.setArray(this.copyVar(insn.getArray()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(GetElementInstruction insn) {
            GetElementInstruction insnCopy = new GetElementInstruction();
            insnCopy.setArray(this.copyVar(insn.getArray()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            insnCopy.setIndex(this.copyVar(insn.getIndex()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(PutElementInstruction insn) {
            PutElementInstruction insnCopy = new PutElementInstruction();
            insnCopy.setArray(this.copyVar(insn.getArray()));
            insnCopy.setValue(this.copyVar(insn.getValue()));
            insnCopy.setIndex(this.copyVar(insn.getIndex()));
            this.copy = insnCopy;
        }

        @Override
        public void visit(InvokeInstruction insn) {
            InvokeInstruction insnCopy = new InvokeInstruction();
            insnCopy.setMethod(insn.getMethod());
            insnCopy.setType(insn.getType());
            insnCopy.setInstance(insn.getInstance() != null ? this.copyVar(insn.getInstance()) : null);
            insnCopy.setReceiver(insn.getReceiver() != null ? this.copyVar(insn.getReceiver()) : null);
            for (Variable arg : insn.getArguments()) {
                insnCopy.getArguments().add(this.copyVar(arg));
            }
            this.copy = insnCopy;
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            IsInstanceInstruction insnCopy = new IsInstanceInstruction();
            insnCopy.setValue(this.copyVar(insn.getValue()));
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            insnCopy.setType(insn.getType());
            this.copy = insnCopy;
        }

        @Override
        public void visit(InitClassInstruction insn) {
            InitClassInstruction insnCopy = new InitClassInstruction();
            insnCopy.setClassName(insn.getClassName());
            this.copy = insnCopy;
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            NullCheckInstruction insnCopy = new NullCheckInstruction();
            insnCopy.setReceiver(this.copyVar(insn.getReceiver()));
            insnCopy.setValue(this.copyVar(insn.getValue()));
            this.copy = insnCopy;
        }
    }
}

