/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.List;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.IncomingReader;
import org.teavm.model.PhiReader;
import org.teavm.model.ProgramReader;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.util.InstructionStringifier;

public class ListingBuilder {
    public String buildListing(ProgramReader program, String prefix) {
        StringBuilder sb = new StringBuilder();
        InstructionStringifier stringifier = new InstructionStringifier(sb);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            sb.append(prefix).append("$").append(i).append(":\n");
            for (PhiReader phiReader : block.readPhis()) {
                sb.append(prefix).append("    ");
                sb.append("@").append(phiReader.getReceiver().getIndex()).append(" := ");
                List<? extends IncomingReader> incomings = phiReader.readIncomings();
                for (int j = 0; j < incomings.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    IncomingReader incoming = incomings.get(j);
                    sb.append("@").append(incoming.getValue().getIndex()).append(" from ").append("$").append(incoming.getSource().getIndex());
                }
                sb.append("\n");
            }
            for (int j = 0; j < block.instructionCount(); ++j) {
                sb.append(prefix).append("    ");
                block.readInstruction(j, stringifier);
                sb.append("\n");
            }
            for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
                sb.append(prefix).append("    catch ").append(tryCatchBlockReader.getExceptionType()).append(" @").append(tryCatchBlockReader.getExceptionVariable().getIndex()).append(" -> $").append(tryCatchBlockReader.getHandler().getIndex()).append("\n");
            }
        }
        return sb.toString();
    }
}

