/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.ArrayList;
import org.teavm.model.PrimitiveType;

public abstract class ValueType {
    volatile String reprCache;
    public static final Void VOID = new Void();
    public static final Primitive BOOLEAN = new Primitive(PrimitiveType.BOOLEAN);
    public static final Primitive BYTE = new Primitive(PrimitiveType.BYTE);
    public static final Primitive SHORT = new Primitive(PrimitiveType.SHORT);
    public static final Primitive INTEGER = new Primitive(PrimitiveType.INTEGER);
    public static final Primitive FLOAT = new Primitive(PrimitiveType.FLOAT);
    public static final Primitive LONG = new Primitive(PrimitiveType.LONG);
    public static final Primitive DOUBLE = new Primitive(PrimitiveType.DOUBLE);
    public static final Primitive CHARACTER = new Primitive(PrimitiveType.CHARACTER);
    public static final Null NULL = new Null();

    private ValueType() {
    }

    public static ValueType object(String cls) {
        return new Object(cls);
    }

    public static ValueType arrayOf(ValueType type) {
        return new Array(type);
    }

    public static ValueType primitive(PrimitiveType type) {
        return new Primitive(type);
    }

    public static ValueType[] parseMany(String text) {
        ArrayList<ValueType> types = new ArrayList<ValueType>();
        int index = 0;
        while (index < text.length()) {
            int nextIndex = ValueType.cut(text, index);
            types.add(ValueType.parse(text.substring(index, nextIndex)));
            index = nextIndex;
        }
        return types.toArray(new ValueType[types.size()]);
    }

    private static int cut(String text, int index) {
        while (text.charAt(index) == '[') {
            ++index;
        }
        if (text.charAt(index) != 'L') {
            return index + 1;
        }
        while (text.charAt(index) != ';') {
            ++index;
        }
        return index + 1;
    }

    public static ValueType parse(String string) {
        int arrayDegree = 0;
        int left = 0;
        while (string.charAt(left) == '[') {
            ++arrayDegree;
            ++left;
        }
        string = string.substring(left);
        ValueType type = ValueType.parseImpl(string);
        while (arrayDegree-- > 0) {
            type = ValueType.arrayOf(type);
        }
        return type;
    }

    public static String manyToString(ValueType[] types) {
        StringBuilder sb = new StringBuilder();
        for (ValueType type : types) {
            sb.append(type);
        }
        return sb.toString();
    }

    public abstract boolean isObject(String var1);

    private static ValueType parseImpl(String string) {
        switch (string.charAt(0)) {
            case 'Z': {
                return ValueType.primitive(PrimitiveType.BOOLEAN);
            }
            case 'B': {
                return ValueType.primitive(PrimitiveType.BYTE);
            }
            case 'S': {
                return ValueType.primitive(PrimitiveType.SHORT);
            }
            case 'I': {
                return ValueType.primitive(PrimitiveType.INTEGER);
            }
            case 'J': {
                return ValueType.primitive(PrimitiveType.LONG);
            }
            case 'F': {
                return ValueType.primitive(PrimitiveType.FLOAT);
            }
            case 'D': {
                return ValueType.primitive(PrimitiveType.DOUBLE);
            }
            case 'C': {
                return ValueType.primitive(PrimitiveType.CHARACTER);
            }
            case 'V': {
                return VOID;
            }
            case 'L': {
                if (!string.endsWith(";")) {
                    throw new IllegalArgumentException("Wrong type descriptor");
                }
                return ValueType.object(string.substring(1, string.length() - 1).replace('/', '.'));
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isSubtypeOf(ValueType supertype) {
        if (supertype instanceof Object) {
            return !(this instanceof Primitive);
        }
        if (supertype instanceof Array && this instanceof Array) {
            return ((Array)this).getItemType().isSubtypeOf(((Array)supertype).getItemType());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ValueType)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public static class Null
    extends ValueType {
        @Override
        public boolean isObject(String cls) {
            return false;
        }
    }

    public static class Void
    extends ValueType {
        public String toString() {
            return "V";
        }

        @Override
        public boolean isObject(String cls) {
            return false;
        }
    }

    public static class Array
    extends ValueType {
        private ValueType itemType;

        public Array(ValueType itemType) {
            this.itemType = itemType;
        }

        public ValueType getItemType() {
            return this.itemType;
        }

        public String toString() {
            if (this.reprCache == null) {
                this.reprCache = "[" + this.itemType.toString();
            }
            return this.reprCache;
        }

        @Override
        public boolean isObject(String cls) {
            return false;
        }
    }

    public static class Primitive
    extends ValueType {
        private PrimitiveType kind;

        Primitive(PrimitiveType kind) {
            this.kind = kind;
        }

        public PrimitiveType getKind() {
            return this.kind;
        }

        public String toString() {
            if (this.reprCache == null) {
                this.reprCache = this.createString();
            }
            return this.reprCache;
        }

        private String createString() {
            switch (this.kind) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case SHORT: {
                    return "S";
                }
                case INTEGER: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case FLOAT: {
                    return "F";
                }
                case CHARACTER: {
                    return "C";
                }
                case DOUBLE: {
                    return "D";
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean isObject(String cls) {
            return false;
        }
    }

    public static class Object
    extends ValueType {
        private String className;

        public Object(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            if (this.reprCache == null) {
                this.reprCache = "L" + this.className.replace('.', '/') + ";";
            }
            return this.reprCache;
        }

        @Override
        public boolean isObject(String className) {
            return this.className.equals(className);
        }
    }
}

