/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.ArrayList;
import java.util.Map;
import org.teavm.common.Mapper;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.FieldHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.util.ProgramUtils;
import org.teavm.resource.MapperClassHolderSource;

public class CopyClassHolderSource
implements ClassHolderSource {
    private ClassHolderSource innerSource;
    private MapperClassHolderSource mapperSource = new MapperClassHolderSource(new Mapper<String, ClassHolder>(){

        @Override
        public ClassHolder map(String preimage) {
            return CopyClassHolderSource.this.copyClass(preimage);
        }
    });

    public CopyClassHolderSource(ClassHolderSource innerSource) {
        this.innerSource = innerSource;
    }

    @Override
    public ClassHolder get(String name) {
        return this.mapperSource.get(name);
    }

    private ClassHolder copyClass(String className) {
        ClassHolder original = this.innerSource.get(className);
        if (original == null) {
            return null;
        }
        ClassHolder copy = new ClassHolder(className);
        copy.setLevel(original.getLevel());
        copy.getModifiers().addAll(original.getModifiers());
        copy.setParent(original.getParent());
        copy.getInterfaces().addAll(original.getInterfaces());
        for (MethodHolder method : original.getMethods()) {
            copy.addMethod(this.copyMethod(method));
        }
        for (FieldHolder field : original.getFields()) {
            copy.addField(this.copyField(field));
        }
        copy.setOwnerName(original.getOwnerName());
        this.copyAnnotations(original.getAnnotations(), copy.getAnnotations());
        return copy;
    }

    private MethodHolder copyMethod(MethodHolder method) {
        MethodHolder copy = new MethodHolder(method.getDescriptor());
        copy.setLevel(method.getLevel());
        copy.getModifiers().addAll(method.getModifiers());
        copy.setProgram(ProgramUtils.copy(method.getProgram()));
        this.copyAnnotations(method.getAnnotations(), copy.getAnnotations());
        return copy;
    }

    private FieldHolder copyField(FieldHolder field) {
        FieldHolder copy = new FieldHolder(field.getName());
        copy.setLevel(field.getLevel());
        copy.getModifiers().addAll(field.getModifiers());
        copy.setType(field.getType());
        copy.setInitialValue(field.getInitialValue());
        this.copyAnnotations(field.getAnnotations(), copy.getAnnotations());
        return copy;
    }

    private void copyAnnotations(AnnotationContainer src, AnnotationContainer dst) {
        for (AnnotationHolder annot : src.all()) {
            dst.add(this.copyAnnotation(annot));
        }
    }

    private AnnotationHolder copyAnnotation(AnnotationHolder annot) {
        AnnotationHolder copy = new AnnotationHolder(annot.getType());
        for (Map.Entry<String, AnnotationValue> entry : annot.getValues().entrySet()) {
            copy.getValues().put(entry.getKey(), this.copyAnnotationValue(entry.getValue()));
        }
        return copy;
    }

    private AnnotationValue copyAnnotationValue(AnnotationValue value) {
        switch (value.getType()) {
            case 9: {
                ArrayList<AnnotationValue> listCopy = new ArrayList<AnnotationValue>();
                for (AnnotationValue item : value.getList()) {
                    listCopy.add(this.copyAnnotationValue(item));
                }
                return new AnnotationValue(listCopy);
            }
            case 11: {
                return new AnnotationValue(this.copyAnnotation(value.getAnnotation()));
            }
        }
        return value;
    }
}

