/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.HashMap;
import java.util.Map;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.ForStatement;
import org.teavm.javascript.ast.IdentifiedStatement;
import org.teavm.javascript.ast.IncrementStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.WhileStatement;

class BlockRefCountVisitor
implements StatementVisitor {
    Map<IdentifiedStatement, Integer> refs = new HashMap<IdentifiedStatement, Integer>();

    BlockRefCountVisitor() {
    }

    @Override
    public void visit(AssignmentStatement statement) {
    }

    @Override
    public void visit(SequentialStatement statement) {
        for (Statement part : statement.getSequence()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(ConditionalStatement statement) {
        for (Statement stmt : statement.getConsequent()) {
            stmt.acceptVisitor(this);
        }
        for (Statement stmt : statement.getAlternative()) {
            stmt.acceptVisitor(this);
        }
    }

    @Override
    public void visit(SwitchStatement statement) {
        this.refs.put(statement, 0);
        for (SwitchClause clause : statement.getClauses()) {
            for (Statement part : clause.getBody()) {
                part.acceptVisitor(this);
            }
        }
        for (Statement part : statement.getDefaultClause()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(WhileStatement statement) {
        this.refs.put(statement, 0);
        for (Statement part : statement.getBody()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(BlockStatement statement) {
        this.refs.put(statement, 0);
        for (Statement part : statement.getBody()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(ForStatement statement) {
    }

    @Override
    public void visit(BreakStatement statement) {
        this.refs.put(statement.getTarget(), this.refs.get(statement.getTarget()) + 1);
    }

    @Override
    public void visit(ContinueStatement statement) {
        this.refs.put(statement.getTarget(), this.refs.get(statement.getTarget()) + 1);
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(IncrementStatement statement) {
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(TryCatchStatement statement) {
        for (Statement part : statement.getProtectedBody()) {
            part.acceptVisitor(this);
        }
        for (Statement part : statement.getHandler()) {
            part.acceptVisitor(this);
        }
    }
}

