/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.FieldDependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.MemberHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.MutableClassHolderSource;
import org.teavm.model.Program;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;

public class Linker {
    private DependencyInfo dependency;

    public Linker(DependencyInfo dependency) {
        this.dependency = dependency;
    }

    public ListableClassHolderSource link(ClassHolderSource classes) {
        MutableClassHolderSource cutClasses = new MutableClassHolderSource();
        for (String className : this.dependency.getAchievableClasses()) {
            ClassHolder classHolder = classes.get(className);
            cutClasses.putClassHolder(classHolder);
            for (MethodHolder methodHolder : classHolder.getMethods().toArray(new MethodHolder[0])) {
                MethodReference methodRef = new MethodReference(className, methodHolder.getDescriptor());
                MethodDependencyInfo methodDep = this.dependency.getMethod(methodRef);
                if (methodDep == null) {
                    classHolder.removeMethod(methodHolder);
                    continue;
                }
                if (!methodDep.isUsed()) {
                    methodHolder.getModifiers().add(ElementModifier.ABSTRACT);
                    methodHolder.setProgram(null);
                    continue;
                }
                if (methodHolder.getProgram() == null) continue;
                this.link(methodHolder);
            }
            for (MemberHolder memberHolder : classHolder.getFields().toArray(new FieldHolder[0])) {
                FieldReference fieldRef = new FieldReference(className, memberHolder.getName());
                if (this.dependency.getField(fieldRef) != null) continue;
                classHolder.removeField((FieldHolder)memberHolder);
            }
        }
        return cutClasses;
    }

    public void link(MethodHolder cls) {
        Program program = cls.getProgram();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block.getInstructions()) {
                FieldDependencyInfo linkedField;
                Instruction getField;
                if (insn instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    MethodDependencyInfo linkedMethod = this.dependency.getMethod(invoke.getMethod());
                    if (linkedMethod == null) continue;
                    invoke.setMethod(linkedMethod.getReference());
                    continue;
                }
                if (insn instanceof GetFieldInstruction) {
                    getField = (GetFieldInstruction)insn;
                    linkedField = this.dependency.getField(((GetFieldInstruction)getField).getField());
                    if (linkedField == null) continue;
                    ((GetFieldInstruction)getField).setField(linkedField.getReference());
                    continue;
                }
                if (!(insn instanceof PutFieldInstruction) || (linkedField = this.dependency.getField(((PutFieldInstruction)(getField = (PutFieldInstruction)insn)).getField())) == null) continue;
                ((PutFieldInstruction)getField).setField(linkedField.getReference());
            }
        }
    }
}

