/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import org.teavm.model.MethodReference;

public class DependencyStack {
    public static final DependencyStack ROOT = new DependencyStack();
    private MethodReference method;
    private DependencyStack cause;

    private DependencyStack() {
    }

    public DependencyStack(MethodReference method) {
        this(method, ROOT);
    }

    public DependencyStack(MethodReference method, DependencyStack cause) {
        if (method == null || cause == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        this.method = method;
        this.cause = cause;
    }

    public MethodReference getMethod() {
        return this.method;
    }

    public DependencyStack getCause() {
        return this.cause;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        DependencyStack stack = this;
        while (true) {
            if (stack.method == null) break;
            sb.append(" used by " + stack.method);
            stack = stack.cause;
        }
        sb.append("  used by ROOT\n");
        return sb.toString();
    }
}

