/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNodeToNodeTransition;
import org.teavm.dependency.DependencyTypeFilter;
import org.teavm.dependency.ValueDependencyInfo;

public class DependencyNode
implements ValueDependencyInfo {
    private DependencyChecker dependencyChecker;
    private static final Object mapValue = new Object();
    private ConcurrentMap<DependencyConsumer, Object> followers = new ConcurrentHashMap<DependencyConsumer, Object>();
    private ConcurrentMap<String, Object> types = new ConcurrentHashMap<String, Object>();
    private ConcurrentMap<DependencyNode, DependencyNodeToNodeTransition> transitions = new ConcurrentHashMap<DependencyNode, DependencyNodeToNodeTransition>();
    private volatile String tag;
    private final AtomicReference<DependencyNode> arrayItemNode = new AtomicReference();
    private volatile CountDownLatch arrayItemNodeLatch = new CountDownLatch(1);
    private int degree;

    DependencyNode(DependencyChecker dependencyChecker) {
        this(dependencyChecker, 0);
    }

    DependencyNode(DependencyChecker dependencyChecker, int degree) {
        this.dependencyChecker = dependencyChecker;
        this.degree = degree;
    }

    public void propagate(String type) {
        if (this.degree > 2) {
            return;
        }
        if (this.types.putIfAbsent(type, mapValue) == null) {
            if (DependencyChecker.shouldLog) {
                System.out.println(this.tag + " -> " + type);
            }
            for (DependencyConsumer consumer : this.followers.keySet().toArray(new DependencyConsumer[0])) {
                this.dependencyChecker.schedulePropagation(consumer, type);
            }
        }
    }

    public void addConsumer(DependencyConsumer consumer) {
        if (this.followers.putIfAbsent(consumer, mapValue) == null) {
            for (String type : this.types.keySet().toArray(new String[0])) {
                this.dependencyChecker.schedulePropagation(consumer, type);
            }
        }
    }

    public void connect(DependencyNode node, DependencyTypeFilter filter) {
        DependencyNodeToNodeTransition transition = new DependencyNodeToNodeTransition(this, node, filter);
        if (this.transitions.putIfAbsent(node, transition) == null) {
            if (DependencyChecker.shouldLog) {
                System.out.println("Connecting " + this.tag + " to " + node.tag);
            }
            this.addConsumer(transition);
        }
    }

    public void connect(DependencyNode node) {
        this.connect(node, null);
    }

    @Override
    public DependencyNode getArrayItem() {
        CountDownLatch latch;
        DependencyNode result = this.arrayItemNode.get();
        if (result == null) {
            result = new DependencyNode(this.dependencyChecker, this.degree + 1);
            if (this.arrayItemNode.compareAndSet(null, result)) {
                if (DependencyChecker.shouldLog) {
                    this.arrayItemNode.get().tag = this.tag + "[";
                }
                this.arrayItemNodeLatch.countDown();
                this.arrayItemNodeLatch = null;
            } else {
                result = this.arrayItemNode.get();
            }
        }
        if ((latch = this.arrayItemNodeLatch) != null) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return result;
            }
        }
        return result;
    }

    @Override
    public boolean hasArrayType() {
        return this.arrayItemNode.get() != null && !this.arrayItemNode.get().types.isEmpty();
    }

    @Override
    public boolean hasType(String type) {
        return this.types.containsKey(type);
    }

    @Override
    public String[] getTypes() {
        return this.types != null ? this.types.keySet().toArray(new String[this.types.size()]) : new String[]{};
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

