/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.teavm.common.Mapper;

public class ConcurrentCachedMapper<T, R>
implements Mapper<T, R> {
    private Mapper<T, R> innerMapper;
    private ConcurrentMap<T, Wrapper<R>> cache = new ConcurrentHashMap<T, Wrapper<R>>();
    private List<KeyListener<T>> keyListeners = new ArrayList<KeyListener<T>>();

    public ConcurrentCachedMapper(Mapper<T, R> innerMapper) {
        this.innerMapper = innerMapper;
    }

    public R getKnown(T preimage) {
        Wrapper wrapper = (Wrapper)this.cache.get(preimage);
        return wrapper != null ? (R)wrapper.value : null;
    }

    @Override
    public R map(T preimage) {
        CountDownLatch latch;
        Wrapper wrapper = (Wrapper)this.cache.get(preimage);
        if (wrapper == null) {
            wrapper = new Wrapper();
            Wrapper oldWrapper = this.cache.putIfAbsent(preimage, wrapper);
            if (oldWrapper == null) {
                wrapper.value = this.innerMapper.map(preimage);
                wrapper.latch.countDown();
                wrapper.latch = null;
                for (KeyListener<T> listener : this.keyListeners) {
                    listener.keyAdded(preimage);
                }
            } else {
                wrapper = oldWrapper;
            }
        }
        if ((latch = wrapper.latch) != null) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return (R)wrapper.value;
    }

    public boolean caches(T preimage) {
        return this.cache.get(preimage) != null;
    }

    public Collection<T> getCachedPreimages() {
        return new HashSet(this.cache.keySet());
    }

    public void addKeyListener(KeyListener<T> listener) {
        this.keyListeners.add(listener);
    }

    public static interface KeyListener<S> {
        public void keyAdded(S var1);
    }

    private static class Wrapper<S> {
        volatile S value;
        volatile CountDownLatch latch = new CountDownLatch(1);

        private Wrapper() {
        }
    }
}

