/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.codegen;

import java.util.HashMap;
import java.util.Map;
import org.teavm.codegen.AliasProvider;
import org.teavm.codegen.NamingException;
import org.teavm.codegen.NamingStrategy;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;

public class DefaultNamingStrategy
implements NamingStrategy {
    private AliasProvider aliasProvider;
    private ClassHolderSource classSource;
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, String> privateAliases = new HashMap<String, String>();
    private Map<String, String> classAliases = new HashMap<String, String>();
    private Map<String, String> fieldAliases = new HashMap<String, String>();
    private boolean minifying;

    public DefaultNamingStrategy(AliasProvider aliasProvider, ClassHolderSource classSource) {
        this.aliasProvider = aliasProvider;
        this.classSource = classSource;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    @Override
    public String getNameFor(String cls) {
        String name = this.classAliases.get(cls);
        if (name == null) {
            name = this.aliasProvider.getAlias(cls);
            this.classAliases.put(cls, name);
        }
        return name;
    }

    @Override
    public String getNameFor(MethodReference method) {
        MethodReference origMethod = method;
        if ((method = this.getRealMethod(method)) == null) {
            throw new NamingException("Can't provide name for method as it was not found: " + origMethod);
        }
        ClassHolder clsHolder = this.classSource.get(method.getClassName());
        MethodHolder methodHolder = clsHolder.getMethod(method.getDescriptor());
        if (methodHolder.getModifiers().contains((Object)ElementModifier.STATIC) || method.getDescriptor().getName().equals("<init>") || methodHolder.getLevel() == AccessLevel.PRIVATE) {
            String key = method.toString();
            String alias = this.privateAliases.get(key);
            if (alias == null) {
                alias = this.aliasProvider.getAlias(method);
                this.privateAliases.put(key, alias);
            }
            return alias;
        }
        String key = method.getDescriptor().toString();
        String alias = this.aliases.get(key);
        if (alias == null) {
            alias = this.aliasProvider.getAlias(method);
            this.aliases.put(key, alias);
        }
        return alias;
    }

    @Override
    public String getFullNameFor(MethodReference method) throws NamingException {
        MethodReference originalMethod = method;
        if (!this.minifying) {
            return this.getNameFor(method.getClassName()) + "_" + this.getNameFor(method);
        }
        if ((method = this.getRealMethod(method)) == null) {
            throw new NamingException("Can't provide name for method as it was not found: " + originalMethod);
        }
        String key = method.toString();
        String alias = this.privateAliases.get(key);
        if (alias == null) {
            alias = this.aliasProvider.getAlias(method);
            this.privateAliases.put(key, alias);
        }
        return alias;
    }

    @Override
    public String getNameFor(FieldReference field) {
        String realCls = this.getRealFieldOwner(field.getClassName(), field.getFieldName());
        if (!realCls.equals(field.getClassName())) {
            String alias = this.getNameFor(new FieldReference(realCls, field.getFieldName()));
            this.fieldAliases.put(field.getClassName() + "#" + field, alias);
            return alias;
        }
        String key = realCls + "#" + field;
        String alias = this.fieldAliases.get(key);
        if (alias == null) {
            alias = this.aliasProvider.getAlias(field);
            this.fieldAliases.put(key, alias);
        }
        return alias;
    }

    private MethodReference getRealMethod(MethodReference methodRef) {
        String className = methodRef.getClassName();
        while (className != null) {
            ClassHolder cls = this.classSource.get(className);
            if (cls == null) {
                return null;
            }
            MethodHolder method = cls.getMethod(methodRef.getDescriptor());
            if (method != null) {
                if (method.getLevel() == AccessLevel.PRIVATE && !className.equals(methodRef.getClassName())) {
                    return null;
                }
                return new MethodReference(className, method.getDescriptor());
            }
            className = cls.getParent();
        }
        return null;
    }

    private String getRealFieldOwner(String cls, String field) {
        String initialCls = cls;
        while (!this.fieldExists(cls, field)) {
            ClassHolder clsHolder = this.classSource.get(cls);
            if ((cls = clsHolder.getParent()) != null) continue;
            throw new NamingException("Can't provide name for field as the field not found: " + initialCls + "." + field);
        }
        return cls;
    }

    private boolean fieldExists(String cls, String field) {
        ClassHolder classHolder = this.classSource.get(cls);
        return classHolder.getField(field) != null;
    }
}

