/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.ResourceAccessor;

class ResourceProgramTransformer {
    private static final MethodReference CAST_TO_STRING = new MethodReference(ResourceAccessor.class, "castToString", Object.class, String.class);
    private static final MethodReference CAST_FROM_STRING = new MethodReference(ResourceAccessor.class, "castFromString", String.class, Object.class);
    private static final MethodReference PUT = new MethodReference(ResourceAccessor.class, "put", Object.class, String.class, Object.class, Void.TYPE);
    private static final MethodReference KEYS = new MethodReference(ResourceAccessor.class, "keys", Object.class, Object.class);
    private static final MethodReference KEYS_TO_STRINGS = new MethodReference(ResourceAccessor.class, "keysToStrings", Object.class, String[].class);
    private static final MethodReference GET_PROPERTY = new MethodReference(ResourceAccessor.class, "getProperty", Object.class, String.class, Object.class);
    private static final ValueType RESOURCE = ValueType.parse(Resource.class);
    private ClassHierarchy hierarchy;
    private Program program;

    public ResourceProgramTransformer(ClassHierarchy hierarchy, Program program) {
        this.hierarchy = hierarchy;
        this.program = program;
    }

    public void transformProgram() {
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            this.transformBasicBlock(this.program.basicBlockAt(i));
        }
    }

    private void transformBasicBlock(BasicBlock block) {
        for (Instruction insn : block) {
            if (insn instanceof InvokeInstruction) {
                InvokeInstruction invoke = (InvokeInstruction)insn;
                List<Instruction> replacement = this.transformInvoke(invoke);
                if (replacement == null) continue;
                insn.insertNextAll(replacement);
                insn.delete();
                continue;
            }
            if (!(insn instanceof CastInstruction)) continue;
            this.removeCastToResource((CastInstruction)insn);
        }
    }

    void removeCasts() {
        for (BasicBlock block : this.program.getBasicBlocks()) {
            for (Instruction insn : block) {
                if (!(insn instanceof CastInstruction)) continue;
                this.removeCastToResource((CastInstruction)insn);
            }
        }
    }

    private void removeCastToResource(CastInstruction cast) {
        if (this.hierarchy.isSuperType(RESOURCE, cast.getTargetType(), false)) {
            AssignInstruction assign = new AssignInstruction();
            assign.setReceiver(cast.getReceiver());
            assign.setAssignee(cast.getValue());
            assign.setLocation(cast.getLocation());
            cast.replace(assign);
        }
    }

    private List<Instruction> transformInvoke(InvokeInstruction insn) {
        if (insn.getType() != InvocationType.VIRTUAL) {
            return null;
        }
        MethodReference method = insn.getMethod();
        if (method.getClassName().equals(ResourceArray.class.getName()) || method.getClassName().equals(ResourceMap.class.getName())) {
            if (method.getName().equals("keys")) {
                return this.transformKeys(insn);
            }
            InvokeInstruction accessInsn = new InvokeInstruction();
            accessInsn.setType(InvocationType.SPECIAL);
            ValueType[] types = new ValueType[method.getDescriptor().parameterCount() + 2];
            types[0] = ValueType.object("java.lang.Object");
            System.arraycopy(method.getDescriptor().getSignature(), 0, types, 1, method.getDescriptor().parameterCount() + 1);
            accessInsn.setMethod(new MethodReference(ResourceAccessor.class.getName(), method.getName(), types));
            Variable[] accessArgs = new Variable[insn.getArguments().size() + 1];
            accessArgs[0] = insn.getInstance();
            for (int i = 0; i < insn.getArguments().size(); ++i) {
                accessArgs[i + 1] = insn.getArguments().get(i);
            }
            accessInsn.setArguments(accessArgs);
            accessInsn.setReceiver(insn.getReceiver());
            return Arrays.asList(accessInsn);
        }
        ClassReader iface = this.hierarchy.getClassSource().get(method.getClassName());
        if (iface == null || !this.hierarchy.isSuperType(Resource.class.getName(), iface.getName(), false)) {
            return null;
        }
        if (method.getName().startsWith("get")) {
            if (method.getName().length() > 3) {
                return this.transformGetterInvocation(insn, this.getPropertyName(method.getName().substring(3)));
            }
        } else if (method.getName().startsWith("is")) {
            if (method.getName().length() > 2) {
                return this.transformGetterInvocation(insn, this.getPropertyName(method.getName().substring(2)));
            }
        } else if (method.getName().startsWith("set") && method.getName().length() > 3) {
            return this.transformSetterInvocation(insn, this.getPropertyName(method.getName().substring(3)));
        }
        return null;
    }

    private List<Instruction> transformKeys(InvokeInstruction insn) {
        Variable tmp = this.program.createVariable();
        InvokeInstruction keysInsn = new InvokeInstruction();
        keysInsn.setType(InvocationType.SPECIAL);
        keysInsn.setMethod(KEYS);
        keysInsn.setArguments(insn.getInstance());
        keysInsn.setReceiver(tmp);
        InvokeInstruction transformInsn = new InvokeInstruction();
        transformInsn.setType(InvocationType.SPECIAL);
        transformInsn.setMethod(KEYS_TO_STRINGS);
        transformInsn.setArguments(tmp);
        transformInsn.setReceiver(insn.getReceiver());
        return Arrays.asList(keysInsn, transformInsn);
    }

    private List<Instruction> transformGetterInvocation(InvokeInstruction insn, String property) {
        if (insn.getReceiver() == null) {
            return Collections.emptyList();
        }
        ValueType type = insn.getMethod().getDescriptor().getResultType();
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    this.getAndCastProperty(insn, property, instructions, Boolean.TYPE);
                    return instructions;
                }
                case BYTE: {
                    this.getAndCastProperty(insn, property, instructions, Byte.TYPE);
                    return instructions;
                }
                case SHORT: {
                    this.getAndCastProperty(insn, property, instructions, Short.TYPE);
                    return instructions;
                }
                case INTEGER: {
                    this.getAndCastProperty(insn, property, instructions, Integer.TYPE);
                    return instructions;
                }
                case FLOAT: {
                    this.getAndCastProperty(insn, property, instructions, Float.TYPE);
                    return instructions;
                }
                case DOUBLE: {
                    this.getAndCastProperty(insn, property, instructions, Double.TYPE);
                    return instructions;
                }
            }
        } else if (type instanceof ValueType.Object) {
            switch (((ValueType.Object)type).getClassName()) {
                case "java.lang.String": {
                    Variable resultVar = insn.getProgram().createVariable();
                    this.getProperty(insn, property, instructions, resultVar);
                    InvokeInstruction castInvoke = new InvokeInstruction();
                    castInvoke.setType(InvocationType.SPECIAL);
                    castInvoke.setMethod(CAST_TO_STRING);
                    castInvoke.setArguments(resultVar);
                    castInvoke.setReceiver(insn.getReceiver());
                    instructions.add(castInvoke);
                    return instructions;
                }
            }
            this.getProperty(insn, property, instructions, insn.getReceiver());
            return instructions;
        }
        return null;
    }

    private void getProperty(InvokeInstruction insn, String property, List<Instruction> instructions, Variable resultVar) {
        Variable nameVar = this.program.createVariable();
        StringConstantInstruction nameInsn = new StringConstantInstruction();
        nameInsn.setConstant(property);
        nameInsn.setReceiver(nameVar);
        instructions.add(nameInsn);
        InvokeInstruction accessorInvoke = new InvokeInstruction();
        accessorInvoke.setType(InvocationType.SPECIAL);
        accessorInvoke.setMethod(GET_PROPERTY);
        accessorInvoke.setArguments(insn.getInstance(), nameVar);
        accessorInvoke.setReceiver(resultVar);
        instructions.add(accessorInvoke);
    }

    private void getAndCastProperty(InvokeInstruction insn, String property, List<Instruction> instructions, Class<?> primitive) {
        Variable resultVar = this.program.createVariable();
        this.getProperty(insn, property, instructions, resultVar);
        InvokeInstruction castInvoke = new InvokeInstruction();
        castInvoke.setType(InvocationType.SPECIAL);
        String primitiveCapitalized = primitive.getName();
        primitiveCapitalized = Character.toUpperCase(primitiveCapitalized.charAt(0)) + primitiveCapitalized.substring(1);
        castInvoke.setMethod(new MethodReference(ResourceAccessor.class, "castTo" + primitiveCapitalized, Object.class, primitive));
        castInvoke.setArguments(resultVar);
        castInvoke.setReceiver(insn.getReceiver());
        instructions.add(castInvoke);
    }

    private List<Instruction> transformSetterInvocation(InvokeInstruction insn, String property) {
        ValueType type = insn.getMethod().getDescriptor().parameterType(0);
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    this.castAndSetProperty(insn, property, instructions, Boolean.TYPE);
                    return instructions;
                }
                case BYTE: {
                    this.castAndSetProperty(insn, property, instructions, Byte.TYPE);
                    return instructions;
                }
                case SHORT: {
                    this.castAndSetProperty(insn, property, instructions, Short.TYPE);
                    return instructions;
                }
                case INTEGER: {
                    this.castAndSetProperty(insn, property, instructions, Integer.TYPE);
                    return instructions;
                }
                case FLOAT: {
                    this.castAndSetProperty(insn, property, instructions, Float.TYPE);
                    return instructions;
                }
                case DOUBLE: {
                    this.castAndSetProperty(insn, property, instructions, Double.TYPE);
                    return instructions;
                }
            }
        } else if (type instanceof ValueType.Object) {
            switch (((ValueType.Object)type).getClassName()) {
                case "java.lang.String": {
                    Variable castVar = insn.getProgram().createVariable();
                    InvokeInstruction castInvoke = new InvokeInstruction();
                    castInvoke.setType(InvocationType.SPECIAL);
                    castInvoke.setMethod(CAST_FROM_STRING);
                    castInvoke.setArguments(insn.getArguments().get(0));
                    castInvoke.setReceiver(castVar);
                    instructions.add(castInvoke);
                    this.setProperty(insn, property, instructions, castVar);
                    return instructions;
                }
            }
            this.setProperty(insn, property, instructions, insn.getArguments().get(0));
            return instructions;
        }
        return null;
    }

    private void setProperty(InvokeInstruction insn, String property, List<Instruction> instructions, Variable valueVar) {
        Variable nameVar = this.program.createVariable();
        StringConstantInstruction nameInsn = new StringConstantInstruction();
        nameInsn.setConstant(property);
        nameInsn.setReceiver(nameVar);
        instructions.add(nameInsn);
        InvokeInstruction accessorInvoke = new InvokeInstruction();
        accessorInvoke.setType(InvocationType.SPECIAL);
        accessorInvoke.setMethod(PUT);
        accessorInvoke.setArguments(insn.getInstance(), nameVar, valueVar);
        instructions.add(accessorInvoke);
    }

    private void castAndSetProperty(InvokeInstruction insn, String property, List<Instruction> instructions, Class<?> primitive) {
        Variable castVar = this.program.createVariable();
        InvokeInstruction castInvoke = new InvokeInstruction();
        castInvoke.setType(InvocationType.SPECIAL);
        String primitiveCapitalized = primitive.getName();
        primitiveCapitalized = Character.toUpperCase(primitiveCapitalized.charAt(0)) + primitiveCapitalized.substring(1);
        castInvoke.setMethod(new MethodReference(ResourceAccessor.class, "castFrom" + primitiveCapitalized, primitive, Object.class));
        castInvoke.setArguments(insn.getArguments().get(0));
        castInvoke.setReceiver(castVar);
        instructions.add(castInvoke);
        this.setProperty(insn, property, instructions, castVar);
    }

    private String getPropertyName(String name) {
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        if (Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

