/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TCIBackReferenceSet;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;

class TBackReferenceSet
extends TCIBackReferenceSet {
    public TBackReferenceSet(int groupIndex, int consCounter) {
        super(groupIndex, consCounter);
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        int shift;
        String group = this.getString(matchResult);
        if (group == null || stringIndex + group.length() > matchResult.getRightBound()) {
            return -1;
        }
        int n = shift = testString.toString().startsWith(group, stringIndex) ? group.length() : -1;
        if (shift < 0) {
            return -1;
        }
        matchResult.setConsumed(this.consCounter, shift);
        return this.next.matches(stringIndex + shift, testString, matchResult);
    }

    @Override
    public int find(int strIndex, CharSequence testString, TMatchResultImpl matchResult) {
        String group = this.getString(matchResult);
        int strLength = matchResult.getLeftBound();
        if (group == null || strIndex + group.length() > strLength) {
            return -1;
        }
        String testStr = testString.toString();
        while (strIndex <= strLength) {
            if ((strIndex = testStr.indexOf(group, strIndex)) < 0) {
                return -1;
            }
            if (this.next.matches(strIndex + group.length(), testString, matchResult) >= 0) {
                return strIndex;
            }
            ++strIndex;
        }
        return -1;
    }

    @Override
    public int findBack(int strIndex, int lastIndex, CharSequence testString, TMatchResultImpl matchResult) {
        String group = this.getString(matchResult);
        if (group == null) {
            return -1;
        }
        String testStr = testString.toString();
        while (lastIndex >= strIndex) {
            if ((lastIndex = testStr.lastIndexOf(group, lastIndex)) < 0 || lastIndex < strIndex) {
                return -1;
            }
            if (this.next.matches(lastIndex + group.length(), testString, matchResult) >= 0) {
                return lastIndex;
            }
            --lastIndex;
        }
        return -1;
    }

    @Override
    public boolean first(TAbstractSet set) {
        return true;
    }

    @Override
    public String getName() {
        return "back reference: " + this.groupIndex;
    }
}

