/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.stream.TStream;

public final class TOptional<T> {
    private static TOptional<?> emptyInstance;
    private final T value;

    private TOptional(T value) {
        this.value = value;
    }

    public static <S> TOptional<S> empty() {
        if (emptyInstance == null) {
            emptyInstance = new TOptional<Object>(null);
        }
        return emptyInstance;
    }

    public static <T> TOptional<T> of(T value) {
        return new TOptional<T>(Objects.requireNonNull(value));
    }

    public static <T> TOptional<T> ofNullable(T value) {
        return value != null ? TOptional.of(value) : TOptional.empty();
    }

    public T get() {
        if (this.value == null) {
            throw new TNoSuchElementException();
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public TStream<T> stream() {
        if (this.value == null) {
            return TStream.empty();
        }
        return TStream.of(this.value);
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public TOptional<T> filter(Predicate<? super T> predicate) {
        return this.value == null || predicate.test(this.value) ? this : TOptional.empty();
    }

    public <U> TOptional<U> map(Function<? super T, ? extends U> mapper) {
        return this.value != null ? TOptional.ofNullable(mapper.apply(this.value)) : this;
    }

    public <U> TOptional<U> flatMap(Function<? super T, TOptional<U>> mapper) {
        return this.value != null ? mapper.apply(this.value) : this;
    }

    public TOptional<T> or(Supplier<? extends TOptional<? extends T>> supplier) {
        if (this.value != null) {
            return this;
        }
        return Objects.requireNonNull(supplier.get());
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.value != null) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    public T orElseThrow() {
        if (this.value == null) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TOptional)) {
            return false;
        }
        return Objects.equals(((TOptional)obj).value, this.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.value != null ? "Optional.of(" + this.value + ")" : "Optional.empty()";
    }
}

