/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.NumericOperandType;

public class NumericClassTransformer
implements ClassHolderTransformer {
    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        switch (cls.getName()) {
            case "java.lang.Integer": {
                this.transformInteger(cls);
                break;
            }
            case "java.lang.Long": {
                this.transformLong(cls);
                break;
            }
            case "java.lang.Float": {
                this.transformFloat(cls);
                break;
            }
            case "java.lang.Double": {
                this.transformDouble(cls);
            }
        }
    }

    private void transformInteger(ClassHolder cls) {
        this.transformCompareMethod(cls, ValueType.INTEGER, NumericOperandType.INT);
    }

    private void transformLong(ClassHolder cls) {
        this.transformCompareMethod(cls, ValueType.LONG, NumericOperandType.LONG);
    }

    private void transformFloat(ClassHolder cls) {
        this.transformCompareMethod(cls, ValueType.FLOAT, NumericOperandType.FLOAT);
    }

    private void transformDouble(ClassHolder cls) {
        this.transformCompareMethod(cls, ValueType.DOUBLE, NumericOperandType.DOUBLE);
    }

    private void transformCompareMethod(ClassHolder cls, ValueType type, NumericOperandType insnType) {
        MethodHolder method = cls.getMethod(new MethodDescriptor("compare", type, type, ValueType.INTEGER));
        Program program = new Program();
        program.createVariable();
        Variable firstArg = program.createVariable();
        Variable secondArg = program.createVariable();
        Variable result = program.createVariable();
        BasicBlock block = program.createBasicBlock();
        BinaryInstruction insn = new BinaryInstruction(BinaryOperation.COMPARE, insnType);
        insn.setFirstOperand(firstArg);
        insn.setSecondOperand(secondArg);
        insn.setReceiver(result);
        block.add(insn);
        ExitInstruction exit = new ExitInstruction();
        exit.setValueToReturn(result);
        block.add(exit);
        method.setProgram(program);
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
    }
}

