/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.interop.Address;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;

public class WasmInteropFunctionGenerator {
    private WasmClassGenerator classGenerator;

    public WasmInteropFunctionGenerator(WasmClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    public void generateFunctions(WasmModule module) {
        module.add(this.allocateString());
        module.add(this.stringData());
        module.add(this.allocateArray("teavm_allocateObjectArray", ValueType.parse(Object.class)));
        module.add(this.allocateArray("teavm_allocateStringArray", ValueType.parse(String.class)));
        module.add(this.allocateArray("teavm_allocateByteArray", ValueType.parse(Byte.TYPE)));
        module.add(this.allocateArray("teavm_allocateShortArray", ValueType.parse(Short.TYPE)));
        module.add(this.allocateArray("teavm_allocateCharArray", ValueType.parse(Character.TYPE)));
        module.add(this.allocateArray("teavm_allocateIntArray", ValueType.parse(Integer.TYPE)));
        module.add(this.allocateArray("teavm_allocateLongArray", ValueType.parse(Long.TYPE)));
        module.add(this.allocateArray("teavm_allocateFloatArray", ValueType.parse(Float.TYPE)));
        module.add(this.allocateArray("teavm_allocateDoubleArray", ValueType.parse(Double.TYPE)));
        module.add(this.arrayData("teavm_objectArrayData", 4));
        module.add(this.arrayData("teavm_byteArrayData", 1));
        module.add(this.arrayData("teavm_shortArrayData", 2));
        module.add(this.arrayData("teavm_charArrayData", 2));
        module.add(this.arrayData("teavm_intArrayData", 4));
        module.add(this.arrayData("teavm_longArrayData", 8));
        module.add(this.arrayData("teavm_floatArrayData", 4));
        module.add(this.arrayData("teavm_doubleArrayData", 8));
        module.add(this.arrayLength());
    }

    private WasmFunction allocateString() {
        WasmFunction function = new WasmFunction("teavm_allocateString");
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal sizeLocal = new WasmLocal(WasmType.INT32, "size");
        function.add(sizeLocal);
        String constructorName = this.classGenerator.names.forMethod(new MethodReference(String.class, "allocate", Integer.TYPE, String.class));
        WasmCall constructorCall = new WasmCall(constructorName);
        constructorCall.getArguments().add(new WasmGetLocal(sizeLocal));
        function.getBody().add(constructorCall);
        function.getBody().add(new WasmReturn(constructorCall));
        return function;
    }

    private WasmFunction allocateArray(String name, ValueType type) {
        WasmFunction function = new WasmFunction(name);
        function.setExportName(name);
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal sizeLocal = new WasmLocal(WasmType.INT32, "size");
        function.add(sizeLocal);
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(type));
        String allocName = this.classGenerator.names.forMethod(new MethodReference(Allocator.class, "allocateArray", RuntimeClass.class, Integer.TYPE, Address.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        call.getArguments().add(new WasmGetLocal(sizeLocal));
        function.getBody().add(new WasmReturn(call));
        return function;
    }

    private WasmFunction stringData() {
        WasmFunction function = new WasmFunction("teavm_stringData");
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal stringLocal = new WasmLocal(WasmType.INT32, "string");
        function.add(stringLocal);
        int offset = this.classGenerator.getFieldOffset(new FieldReference("java.lang.String", "characters"));
        WasmLoadInt32 chars = new WasmLoadInt32(4, new WasmGetLocal(stringLocal), WasmInt32Subtype.INT32, offset);
        function.getBody().add(new WasmReturn(chars));
        return function;
    }

    private WasmFunction arrayData(String name, int alignment) {
        WasmFunction function = new WasmFunction(name);
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal arrayLocal = new WasmLocal(WasmType.INT32, "array");
        function.add(arrayLocal);
        int start = WasmClassGenerator.align(this.classGenerator.getClassSize(RuntimeArray.class.getName()), alignment);
        WasmIntBinary data = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(arrayLocal), new WasmInt32Constant(start));
        function.getBody().add(new WasmReturn(data));
        return function;
    }

    private WasmFunction arrayLength() {
        WasmFunction function = new WasmFunction("teavm_arrayLength");
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal arrayLocal = new WasmLocal(WasmType.INT32, "array");
        function.add(arrayLocal);
        int sizeOffset = this.classGenerator.getFieldOffset(new FieldReference(RuntimeArray.class.getName(), "size"));
        WasmIntBinary ptr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(arrayLocal), new WasmInt32Constant(sizeOffset));
        WasmLoadInt32 length = new WasmLoadInt32(4, ptr, WasmInt32Subtype.INT32);
        function.getBody().add(new WasmReturn(length));
        return function;
    }
}

