/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teavm.asm.AnnotationVisitor;
import org.teavm.asm.ClassReader;
import org.teavm.asm.ClassVisitor;
import org.teavm.asm.Type;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.vm.spi.After;
import org.teavm.vm.spi.Before;
import org.teavm.vm.spi.Requires;

@CompileTime
final class TeaVMPluginReader {
    static final String DESCRIPTOR_LOCATION = "META-INF/services/org.teavm.vm.spi.TeaVMPlugin";
    static final String REQUIRES_DESC = Type.getDescriptor(Requires.class);
    static final String BEFORE_DESC = Type.getDescriptor(Before.class);
    static final String AFTER_DESC = Type.getDescriptor(After.class);

    private TeaVMPluginReader() {
    }

    static void load(ClassLoader classLoader, Consumer<String> consumer) {
        HashSet<String> unorderedPlugins = new HashSet<String>();
        try {
            Enumeration<URL> resourceFiles = classLoader.getResources(DESCRIPTOR_LOCATION);
            while (resourceFiles.hasMoreElements()) {
                URL resourceFile = resourceFiles.nextElement();
                BufferedReader input = new BufferedReader(new InputStreamReader(resourceFile.openStream(), "UTF-8"));
                Throwable throwable = null;
                try {
                    TeaVMPluginReader.readPlugins(input, unorderedPlugins);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading plugins", e);
        }
        TeaVMPluginReader.orderPlugins(classLoader, unorderedPlugins).forEach(consumer);
    }

    static List<String> orderPlugins(ClassLoader classLoader, Set<String> classNames) {
        HashMap<String, PluginDescriptor> descriptors = new HashMap<String, PluginDescriptor>();
        try {
            for (String className : classNames) {
                PluginDescriptor descriptor = new PluginDescriptor();
                descriptor.name = className;
                if (!TeaVMPluginReader.readDescriptor(classLoader, className, descriptor)) continue;
                descriptors.put(className, descriptor);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error ordering plugins", e);
        }
        TeaVMPluginReader.findReachableDescriptors(descriptors);
        TeaVMPluginReader.processDescriptors(descriptors);
        ArrayList<String> plugins = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> emmited = new HashSet<String>();
        for (PluginDescriptor descriptor : descriptors.values()) {
            TeaVMPluginReader.orderDescriptors(descriptor, descriptors, plugins, visited, emmited, new ArrayList<String>());
        }
        return plugins;
    }

    static void readPlugins(BufferedReader input, Set<String> plugins) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            plugins.add(line);
        }
    }

    private static boolean readDescriptor(ClassLoader classLoader, String className, PluginDescriptor descriptor) throws IOException {
        try (InputStream input = classLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
            if (input == null) {
                boolean bl = false;
                return bl;
            }
            ClassReader reader = new ClassReader(new BufferedInputStream(input));
            PluginDescriptorFiller filler = new PluginDescriptorFiller(descriptor);
            reader.accept(filler, 0);
            boolean bl = true;
            return bl;
        }
    }

    private static void findReachableDescriptors(Map<String, PluginDescriptor> descriptors) {
        HashSet<String> visited = new HashSet<String>();
        for (String plugin : descriptors.keySet()) {
            TeaVMPluginReader.isReachable(plugin, visited, descriptors);
        }
    }

    private static boolean isReachable(String plugin, Set<String> visited, Map<String, PluginDescriptor> descriptors) {
        PluginDescriptor descriptor = descriptors.get(plugin);
        if (descriptor == null) {
            return false;
        }
        if (!visited.add(plugin)) {
            return descriptor.reachable;
        }
        boolean reachable = true;
        for (String required : descriptor.requires) {
            if (TeaVMPluginReader.isReachable(required, visited, descriptors)) continue;
            reachable = false;
            break;
        }
        descriptor.reachable = reachable;
        return reachable;
    }

    private static void processDescriptors(Map<String, PluginDescriptor> descriptors) {
        for (PluginDescriptor descriptor : descriptors.values()) {
            if (descriptor.after.length > 0 && descriptor.before.length > 0) {
                throw new IllegalStateException("Plugin " + descriptor.name + " has both before and after annotations");
            }
            descriptor.afterList.addAll(Arrays.asList(descriptor.after));
            for (String before : descriptor.before) {
                PluginDescriptor beforeDescriptor = descriptors.get(before);
                if (beforeDescriptor == null || !beforeDescriptor.reachable) continue;
                beforeDescriptor.afterList.add(descriptor.name);
            }
        }
    }

    private static void orderDescriptors(PluginDescriptor descriptor, Map<String, PluginDescriptor> descriptors, List<String> list, Set<String> visited, Set<String> emmited, List<String> path) {
        if (!descriptor.reachable) {
            return;
        }
        if (!visited.add(descriptor.name)) {
            return;
        }
        path.add(descriptor.name);
        for (String after : descriptor.afterList) {
            PluginDescriptor afterDescriptor = descriptors.get(after);
            if (afterDescriptor == null || !afterDescriptor.reachable) continue;
            if (visited.contains(after) && !emmited.contains(after)) {
                ArrayList<String> loop = new ArrayList<String>();
                Collections.reverse(path);
                for (String pathElem : path) {
                    loop.add(pathElem);
                    if (!pathElem.equals(afterDescriptor.name)) continue;
                    break;
                }
                Collections.reverse(loop);
                throw new IllegalStateException("Circular dependency found: " + loop.stream().collect(Collectors.joining(" -> ")));
            }
            TeaVMPluginReader.orderDescriptors(afterDescriptor, descriptors, list, visited, emmited, path);
        }
        emmited.add(descriptor.name);
        path.remove(descriptor.name);
        list.add(descriptor.name);
    }

    static class PluginDescriptor {
        String name;
        String[] requires = new String[0];
        String[] before = new String[0];
        String[] after = new String[0];
        List<String> afterList = new ArrayList<String>();
        boolean reachable;

        PluginDescriptor() {
        }
    }

    static class PluginDescriptorFiller
    extends ClassVisitor {
        PluginDescriptor descriptor;

        public PluginDescriptorFiller(PluginDescriptor descriptor) {
            super(458752);
            this.descriptor = descriptor;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(REQUIRES_DESC)) {
                return this.readClassArray(arr -> {
                    this.descriptor.requires = arr;
                });
            }
            if (desc.equals(BEFORE_DESC)) {
                return this.readClassArray(arr -> {
                    this.descriptor.before = arr;
                });
            }
            if (desc.equals(AFTER_DESC)) {
                return this.readClassArray(arr -> {
                    this.descriptor.after = arr;
                });
            }
            return null;
        }

        private AnnotationVisitor readClassArray(final Consumer<String[]> resultConsumer) {
            return new AnnotationVisitor(458752){

                @Override
                public AnnotationVisitor visitArray(String name) {
                    final ArrayList values = new ArrayList();
                    if (name.equals("value")) {
                        return new AnnotationVisitor(458752){

                            @Override
                            public void visit(String name, Object value) {
                                values.add(((Type)value).getClassName());
                            }

                            @Override
                            public void visitEnd() {
                                resultConsumer.accept(values.toArray(new String[0]));
                            }
                        };
                    }
                    return null;
                }
            };
        }
    }
}

