/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.FieldDependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MemberHolder;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;

public class Linker {
    private static final MethodDescriptor clinitDescriptor = new MethodDescriptor("<clinit>", Void.TYPE);
    private DependencyInfo dependency;

    public Linker(DependencyInfo dependency) {
        this.dependency = dependency;
    }

    public void link(ClassHolder cls) {
        for (MethodHolder methodHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            MethodReference methodRef = methodHolder.getReference();
            MethodDependencyInfo methodDep = this.dependency.getMethod(methodRef);
            if (methodDep == null || !methodDep.isUsed()) {
                if (methodHolder.hasModifier(ElementModifier.STATIC)) {
                    cls.removeMethod(methodHolder);
                    continue;
                }
                methodHolder.getModifiers().add(ElementModifier.ABSTRACT);
                methodHolder.getModifiers().remove((Object)ElementModifier.NATIVE);
                methodHolder.setProgram(null);
                continue;
            }
            if (methodHolder.getProgram() == null) continue;
            this.link(methodHolder.getReference(), methodHolder.getProgram());
        }
        for (MemberHolder memberHolder : cls.getFields().toArray(new FieldHolder[0])) {
            FieldReference fieldRef = new FieldReference(cls.getName(), memberHolder.getName());
            if (this.dependency.getField(fieldRef) != null) continue;
            cls.removeField((FieldHolder)memberHolder);
        }
    }

    public void link(MethodReference method, Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                FieldReference fieldRef;
                FieldDependencyInfo linkedField;
                if (insn instanceof InvokeInstruction) {
                    MethodDependencyInfo linkedMethod;
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    MethodReference calledRef = invoke.getMethod();
                    if (invoke.getType() == InvocationType.SPECIAL) {
                        linkedMethod = this.dependency.getMethodImplementation(calledRef);
                        if (linkedMethod == null) continue;
                        invoke.setMethod(linkedMethod.getReference());
                        continue;
                    }
                    if (invoke.getType() != InvocationType.VIRTUAL || (linkedMethod = this.dependency.getMethodImplementation(calledRef)) == null || linkedMethod.isMissing()) continue;
                    calledRef = linkedMethod.getReference();
                    ClassReader cls = this.dependency.getClassSource().get(calledRef.getClassName());
                    boolean isFinal = false;
                    if (cls != null) {
                        if (cls.hasModifier(ElementModifier.FINAL)) {
                            isFinal = true;
                        } else {
                            MethodReader calledMethod = cls.getMethod(calledRef.getDescriptor());
                            if (calledMethod != null && (calledMethod.hasModifier(ElementModifier.FINAL) || calledMethod.getLevel() == AccessLevel.PRIVATE)) {
                                isFinal = true;
                            }
                        }
                    }
                    if (!isFinal) continue;
                    invoke.setType(InvocationType.SPECIAL);
                    invoke.setMethod(calledRef);
                    continue;
                }
                if (insn instanceof GetFieldInstruction) {
                    GetFieldInstruction getField = (GetFieldInstruction)insn;
                    linkedField = this.dependency.getField(getField.getField());
                    if (linkedField != null) {
                        getField.setField(linkedField.getReference());
                    }
                    fieldRef = getField.getField();
                    if (getField.getInstance() != null) continue;
                    this.insertClinit(this.dependency, fieldRef.getClassName(), method, insn);
                    continue;
                }
                if (!(insn instanceof PutFieldInstruction)) continue;
                PutFieldInstruction putField = (PutFieldInstruction)insn;
                linkedField = this.dependency.getField(putField.getField());
                if (linkedField != null) {
                    putField.setField(linkedField.getReference());
                }
                fieldRef = putField.getField();
                if (putField.getInstance() != null) continue;
                this.insertClinit(this.dependency, fieldRef.getClassName(), method, insn);
            }
        }
    }

    private void insertClinit(DependencyInfo dependency, String className, MethodReference method, Instruction insn) {
        if (className.equals(method.getClassName())) {
            return;
        }
        ClassReader cls = dependency.getClassSource().get(className);
        if (cls == null || cls.getMethod(clinitDescriptor) != null) {
            InitClassInstruction initInsn = new InitClassInstruction();
            initInsn.setClassName(className);
            initInsn.setLocation(insn.getLocation());
            insn.insertPrevious(initInsn);
        }
    }
}

