/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.interop.Import;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;

public class TRandom
extends TObject
implements TSerializable {
    private double storedGaussian;
    private boolean haveStoredGaussian;

    public TRandom() {
    }

    public TRandom(long seed) {
    }

    public void setSeed(long seed) {
    }

    protected int next(int bits) {
        if (bits == 32) {
            return (int)(this.nextDouble() * 4.294967295E9 + -2.147483648E9);
        }
        return (int)(this.nextDouble() * (double)(1L << TMath.min(32, bits)));
    }

    public void nextBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.next(8);
        }
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        return (int)(this.nextDouble() * (double)n);
    }

    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt();
    }

    public boolean nextBoolean() {
        return this.nextInt() % 2 == 0;
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public double nextDouble() {
        if (PlatformDetector.isC()) {
            return TRandom.crand();
        }
        return TRandom.random();
    }

    @Import(name="teavm_rand")
    @Unmanaged
    private static native double crand();

    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveStoredGaussian) {
            this.haveStoredGaussian = false;
            return this.storedGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double m = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.storedGaussian = v2 * m;
        this.haveStoredGaussian = true;
        return v1 * m;
    }

    @JSBody(script="return Math.random();")
    @Import(module="teavmMath", name="random")
    @Unmanaged
    private static native double random();
}

