/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.ResourceAccessorType;
import org.teavm.platform.plugin.ResourceMethodDescriptor;

public class ResourceTypeDescriptor {
    private static Set<Class<?>> allowedPropertyTypes = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, String.class, ResourceArray.class, ResourceMap.class));
    private Class<?> rootIface;
    private Map<String, Class<?>> getters = new HashMap();
    private Map<String, Class<?>> setters = new HashMap();
    private Map<Method, ResourceMethodDescriptor> methods = new LinkedHashMap<Method, ResourceMethodDescriptor>();
    private Map<String, Class<?>> propertyTypes = new LinkedHashMap();

    public ResourceTypeDescriptor(Class<?> iface) {
        this.rootIface = iface;
        if (!this.rootIface.isInterface()) {
            throw new IllegalArgumentException("Error creating a new resource of type " + this.rootIface.getName() + " that is not an interface");
        }
        this.scanIface(this.rootIface);
    }

    public Class<?> getRootInterface() {
        return this.rootIface;
    }

    public Map<Method, ResourceMethodDescriptor> getMethods() {
        return this.methods;
    }

    public Map<String, Class<?>> getPropertyTypes() {
        return this.propertyTypes;
    }

    private void scanIface(Class<?> iface) {
        if (!Resource.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException("Error creating a new resource of type " + iface.getName() + ". This type does not implement the " + Resource.class.getName() + " interface");
        }
        this.getters.clear();
        this.setters.clear();
        for (Method method : iface.getDeclaredMethods()) {
            if (method.getName().startsWith("get")) {
                this.scanGetter(method);
                continue;
            }
            if (method.getName().startsWith("is")) {
                this.scanBooleanGetter(method);
                continue;
            }
            if (method.getName().startsWith("set")) {
                this.scanSetter(method);
                continue;
            }
            this.throwInvalidMethod(method);
        }
        for (Map.Entry entry : this.getters.entrySet()) {
            String propertyName = (String)entry.getKey();
            Class getterType = (Class)entry.getValue();
            Class<?> setterType = this.setters.get(propertyName);
            if (setterType == null) {
                throw new IllegalArgumentException("Property " + iface.getName() + "." + propertyName + " has a getter, but does not have a setter");
            }
            if (setterType.equals(getterType)) continue;
            throw new IllegalArgumentException("Property " + iface.getName() + "." + propertyName + " has a getter and a setter of different types");
        }
        for (String string : this.setters.keySet()) {
            if (this.getters.containsKey(string)) continue;
            throw new IllegalArgumentException("Property " + iface.getName() + "." + string + " has a setter, but does not have a getter");
        }
        for (Map.Entry entry : this.getters.entrySet()) {
            String propertyName = (String)entry.getKey();
            Class propertyType = (Class)entry.getValue();
            if (!(allowedPropertyTypes.contains(propertyType) || propertyType.isInterface() && Resource.class.isAssignableFrom(propertyType))) {
                throw new IllegalArgumentException("Property " + this.rootIface.getName() + "." + propertyName + " has an illegal type " + propertyType.getName());
            }
            if (this.propertyTypes.containsKey(propertyName)) continue;
            this.propertyTypes.put(propertyName, propertyType);
        }
        for (Class<?> superIface : iface.getInterfaces()) {
            this.scanIface(superIface);
        }
    }

    private void throwInvalidMethod(Method method) {
        throw new IllegalArgumentException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " is not likely to be either getter or setter");
    }

    private void scanGetter(Method method) {
        String propertyName = this.extractPropertyName(method.getName().substring(3));
        if (propertyName == null || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length > 0) {
            this.throwInvalidMethod(method);
        }
        if (this.getters.put(propertyName, method.getReturnType()) != null) {
            throw new IllegalArgumentException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " is a duplicate getter for property " + propertyName);
        }
        this.methods.put(method, new ResourceMethodDescriptor(propertyName, ResourceAccessorType.GETTER));
    }

    private void scanBooleanGetter(Method method) {
        String propertyName = this.extractPropertyName(method.getName().substring(2));
        if (propertyName == null || !method.getReturnType().equals(Boolean.TYPE) || method.getParameterTypes().length > 0) {
            this.throwInvalidMethod(method);
        }
        if (this.getters.put(propertyName, method.getReturnType()) != null) {
            throw new IllegalArgumentException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " is a duplicate getter for property " + propertyName);
        }
        this.methods.put(method, new ResourceMethodDescriptor(propertyName, ResourceAccessorType.GETTER));
    }

    private void scanSetter(Method method) {
        String propertyName = this.extractPropertyName(method.getName().substring(3));
        if (propertyName == null || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) {
            this.throwInvalidMethod(method);
        }
        if (this.setters.put(propertyName, method.getParameterTypes()[0]) != null) {
            throw new IllegalArgumentException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " is a duplicate setter for property " + propertyName);
        }
        this.methods.put(method, new ResourceMethodDescriptor(propertyName, ResourceAccessorType.SETTER));
    }

    private String extractPropertyName(String propertyName) {
        if (propertyName.isEmpty()) {
            return null;
        }
        char c = propertyName.charAt(0);
        if (c != Character.toUpperCase(c)) {
            return null;
        }
        if (propertyName.length() == 1) {
            return propertyName.toLowerCase();
        }
        c = propertyName.charAt(1);
        if (c == Character.toUpperCase(c)) {
            return propertyName;
        }
        return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

