/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.text;

import java.util.List;
import java.util.Objects;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.IncomingReader;
import org.teavm.model.InstructionIterator;
import org.teavm.model.PhiReader;
import org.teavm.model.ProgramReader;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.VariableReader;
import org.teavm.model.text.InstructionStringifier;

public class ListingBuilder {
    public String buildListing(ProgramReader program, String prefix) {
        int i;
        StringBuilder sb = new StringBuilder();
        StringBuilder insnSb = new StringBuilder();
        InstructionStringifier stringifier = new InstructionStringifier(insnSb, program);
        for (i = 0; i < program.variableCount(); ++i) {
            VariableReader var = program.variableAt(i);
            if (var == null || var.getDebugName() == null) continue;
            sb.append(prefix).append("var @").append(stringifier.getVariableLabel(i));
            sb.append(" as ").append(var.getDebugName());
            sb.append(" // " + var.getIndex());
            sb.append('\n');
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            sb.append(prefix).append("$").append(i).append("\n");
            if (block == null) continue;
            if (block.getExceptionVariable() != null) {
                sb.append("    @").append(stringifier.getVariableLabel(block.getExceptionVariable().getIndex())).append(" := exception\n");
            }
            for (PhiReader phiReader : block.readPhis()) {
                sb.append(prefix).append("    ");
                sb.append("@").append(stringifier.getVariableLabel(phiReader.getReceiver().getIndex())).append(" := phi ");
                List<? extends IncomingReader> list = phiReader.readIncomings();
                for (int j = 0; j < list.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    IncomingReader incoming = list.get(j);
                    sb.append("@").append(stringifier.getVariableLabel(incoming.getValue().getIndex())).append(" from ").append("$").append(incoming.getSource().getIndex());
                }
                sb.append("\n");
            }
            TextLocation location = null;
            InstructionIterator instructionIterator = block.iterateInstructions();
            while (instructionIterator.hasNext()) {
                instructionIterator.next();
                insnSb.setLength(0);
                instructionIterator.read(stringifier);
                if (!Objects.equals(location, stringifier.getLocation())) {
                    location = stringifier.getLocation();
                    sb.append(prefix).append("  at ");
                    if (location == null) {
                        sb.append("unknown location");
                    } else {
                        sb.append("'");
                        InstructionStringifier.escapeStringLiteral(location.getFileName(), sb);
                        sb.append("' " + location.getLine());
                    }
                    sb.append('\n');
                }
                sb.append(prefix).append("    ").append((CharSequence)insnSb).append("\n");
            }
            for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
                sb.append(prefix).append("    catch ");
                if (tryCatchBlockReader.getExceptionType() != null) {
                    InstructionStringifier.escapeStringLiteral(tryCatchBlockReader.getExceptionType(), sb);
                }
                sb.append(" goto $").append(tryCatchBlockReader.getHandler().getIndex());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

