/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.dom.html;

import java.util.function.Consumer;
import org.teavm.jso.JSProperty;
import org.teavm.jso.dom.css.ElementCSSInlineStyle;
import org.teavm.jso.dom.events.EventTarget;
import org.teavm.jso.dom.events.FocusEventTarget;
import org.teavm.jso.dom.events.KeyboardEventTarget;
import org.teavm.jso.dom.events.LoadEventTarget;
import org.teavm.jso.dom.events.MouseEventTarget;
import org.teavm.jso.dom.events.WheelEventTarget;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.TextRectangle;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.NodeList;

public interface HTMLElement
extends Element,
ElementCSSInlineStyle,
EventTarget,
FocusEventTarget,
MouseEventTarget,
WheelEventTarget,
KeyboardEventTarget,
LoadEventTarget {
    public NodeList<? extends HTMLElement> getElementsByTagName(String var1);

    @JSProperty
    public String getTitle();

    @JSProperty
    public void setTitle(String var1);

    @JSProperty
    public String getLang();

    @JSProperty
    public void setLang(String var1);

    @JSProperty
    public boolean isTranslate();

    @JSProperty
    public void setTranslate(boolean var1);

    @JSProperty
    public String getDir();

    @JSProperty
    public void setDir(String var1);

    @JSProperty
    public boolean isHidden();

    @JSProperty
    public void setHidden(boolean var1);

    public void click();

    @JSProperty
    public int getTabIndex();

    @JSProperty
    public void setTabIndex(int var1);

    public void focus();

    public void blur();

    @JSProperty
    public String getAccessKey();

    @JSProperty
    public void setAccessKey(String var1);

    @JSProperty
    public String getAccessKeyLabel();

    @JSProperty
    public int getClientWidth();

    @JSProperty
    public int getClientHeight();

    @JSProperty
    public int getAbsoluteLeft();

    @JSProperty
    public int getAbsoluteTop();

    @JSProperty
    public int getScrollLeft();

    @JSProperty
    public void setScrollLeft(int var1);

    @JSProperty
    public int getScrollTop();

    @JSProperty
    public void setScrollTop(int var1);

    @JSProperty
    public int getScrollWidth();

    @JSProperty
    public int getScrollHeight();

    @JSProperty
    public int getOffsetWidth();

    @JSProperty
    public int getOffsetHeight();

    @JSProperty
    public int getOffsetTop();

    @JSProperty
    public int getOffsetLeft();

    @Override
    @JSProperty
    public HTMLDocument getOwnerDocument();

    @JSProperty
    public String getInnerHTML();

    @JSProperty
    public void setInnerHTML(String var1);

    public TextRectangle getBoundingClientRect();

    @JSProperty
    public String getClassName();

    @JSProperty
    public void setClassName(String var1);

    default public HTMLElement withAttr(String name, String value) {
        this.setAttribute(name, value);
        return this;
    }

    default public HTMLElement withChild(String tagName) {
        HTMLElement result = this.getOwnerDocument().createElement(tagName);
        this.appendChild(result);
        return this;
    }

    default public HTMLElement withChild(Node node) {
        this.appendChild(node);
        return this;
    }

    default public HTMLElement withChild(String tagName, Consumer<HTMLElement> consumer) {
        HTMLElement result = this.getOwnerDocument().createElement(tagName);
        this.appendChild(result);
        consumer.accept(result);
        return this;
    }

    default public HTMLElement clear() {
        Node node = this.getLastChild();
        while (node != null) {
            Node prev = node.getPreviousSibling();
            if (node.getNodeType() != 2) {
                this.removeChild(node);
            }
            node = prev;
        }
        return this;
    }

    default public HTMLElement withText(String content) {
        this.clear().appendChild(this.getOwnerDocument().createTextNode(content));
        return this;
    }

    @Override
    public HTMLElement querySelector(String var1);

    public NodeList<? extends HTMLElement> querySelectorAll(String var1);

    public void requestPointerLock();
}

