/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.ArraySizingStrategy;
import org.teavm.hppc.ShortArrayList;
import org.teavm.hppc.ShortContainer;
import org.teavm.hppc.cursors.ShortCursor;

public class ShortStack
extends ShortArrayList {
    public ShortStack() {
    }

    public ShortStack(int expectedElements) {
        super(expectedElements);
    }

    public ShortStack(int expectedElements, ArraySizingStrategy resizer) {
        super(expectedElements, resizer);
    }

    public ShortStack(ShortContainer container) {
        super(container);
    }

    public void push(short e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(short e1, short e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(short e1, short e2, short e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(short e1, short e2, short e3, short e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(short[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(short ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(ShortContainer container) {
        return this.addAll(container);
    }

    public int pushAll(Iterable<? extends ShortCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public short pop() {
        assert (this.elementsCount > 0);
        short v = this.buffer[--this.elementsCount];
        return v;
    }

    public short peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static ShortStack from(short ... elements) {
        ShortStack stack = new ShortStack(elements.length);
        stack.push(elements);
        return stack;
    }

    @Override
    public ShortStack clone() {
        return (ShortStack)super.clone();
    }
}

