/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.FloatShortHashMap;
import org.teavm.hppc.HashOrderMixing;

public class FloatShortScatterMap
extends FloatShortHashMap {
    public FloatShortScatterMap() {
        this(4);
    }

    public FloatShortScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatShortScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(float key) {
        return BitMixer.mixPhi(key);
    }

    public static FloatShortScatterMap from(float[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatShortScatterMap map = new FloatShortScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

