/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.Arrays;
import java.util.function.IntPredicate;
import org.teavm.common.DJGraph;
import org.teavm.common.DisjointSet;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphSplittingBackend;
import org.teavm.common.GraphUtils;
import org.teavm.common.IntegerArray;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntSet;
import org.teavm.hppc.cursors.IntCursor;

class IrreducibleGraphConverter {
    private Graph cfg;
    private int totalNodeCount;
    private GraphSplittingBackend backend;
    private IntSet[] nodeCopies;
    private IntegerArray nodeOriginals;

    IrreducibleGraphConverter() {
    }

    void convertToReducible(Graph cfg, int[] weight, GraphSplittingBackend backend) {
        this.backend = backend;
        this.nodeCopies = new IntHashSet[cfg.size()];
        this.nodeOriginals = new IntegerArray(cfg.size());
        for (int i = 0; i < cfg.size(); ++i) {
            this.nodeCopies[i] = new IntHashSet();
            this.nodeOriginals.add(i);
        }
        int[][] identityNodeMap = new int[cfg.size()][];
        for (int i = 0; i < identityNodeMap.length; ++i) {
            identityNodeMap[i] = new int[]{i};
        }
        this.cfg = cfg;
        this.totalNodeCount = cfg.size();
        this.handleLoops(new DJGraph(cfg, weight), identityNodeMap);
        this.backend = null;
    }

    private void handleLoops(DJGraph djGraph, int[][] nodeMap) {
        for (int level = djGraph.levelCount() - 1; level >= 0; --level) {
            int[][] sccs;
            boolean irreducible = false;
            block1: for (int node : djGraph.level(level)) {
                int[] nArray = djGraph.getGraph().incomingEdges(node);
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int pred = nArray[i];
                    if (!djGraph.isCrossJoin(pred, node) || !djGraph.isSpanningBack(node, pred)) continue;
                    irreducible = true;
                    break block1;
                }
            }
            if (!irreducible) continue;
            DJGraphNodeFilter filter = new DJGraphNodeFilter(djGraph, level);
            Graph graph = GraphUtils.subgraph(djGraph.getGraph(), filter);
            for (int[] scc : sccs = GraphUtils.findStronglyConnectedComponents(graph)) {
                if (scc.length <= 1) continue;
                this.handleStronglyConnectedComponent(djGraph, scc, nodeMap);
            }
        }
    }

    private void handleStronglyConnectedComponent(DJGraph djGraph, int[] scc, int[][] nodeMap) {
        int i;
        int i2;
        int sharedDom = scc[0];
        for (i2 = 1; i2 < scc.length; ++i2) {
            sharedDom = djGraph.commonDominatorOf(sharedDom, scc[i2]);
        }
        for (i2 = 0; i2 < scc.length; ++i2) {
            if (scc[i2] != sharedDom) continue;
            this.collapse(djGraph, scc, nodeMap);
            return;
        }
        DisjointSet partitions = new DisjointSet();
        int[] sccBack = new int[djGraph.getGraph().size()];
        for (i = 0; i < scc.length; ++i) {
            partitions.create();
            sccBack[scc[i]] = i;
        }
        for (i = 0; i < scc.length; ++i) {
            int node = scc[i];
            int idom = djGraph.immediateDominatorOf(node);
            if (idom == sharedDom) continue;
            partitions.union(i, sccBack[idom]);
        }
        int[] domains = partitions.pack(scc.length);
        int domainCount = 0;
        for (int domain : domains) {
            domainCount = Math.max(domainCount, domain + 1);
        }
        int[] domainWeight = new int[domainCount];
        for (int i3 = 0; i3 < scc.length; ++i3) {
            int node = scc[i3];
            int n = domains[i3];
            domainWeight[n] = domainWeight[n] + djGraph.weightOf(node);
        }
        int domain = 0;
        int maxWeight = domainWeight[0];
        for (int i4 = 1; i4 < domainWeight.length; ++i4) {
            if (domainWeight[i4] <= maxWeight) continue;
            domain = i4;
            maxWeight = domainWeight[i4];
        }
        IntHashSet domainNodes = new IntHashSet(scc.length);
        for (int i5 = 0; i5 < scc.length; ++i5) {
            int node = scc[i5];
            if (domains[i5] != domain) continue;
            domainNodes.add(node);
        }
        this.splitStronglyConnectedComponent(djGraph, domainNodes, sharedDom, scc, nodeMap);
        int[] sccAndTop = Arrays.copyOf(scc, scc.length + 1);
        sccAndTop[scc.length] = sharedDom;
        this.collapse(djGraph, sccAndTop, nodeMap);
    }

    private void splitStronglyConnectedComponent(DJGraph djGraph, IntSet domain, int sharedDom, int[] scc, int[][] nodeMap) {
        int j;
        int i;
        int i2;
        int[][] newNodes;
        Arrays.sort(scc);
        int[][] mappedNonDomain = new int[scc.length - domain.size()][];
        int[] domainNodes = new int[domain.size()];
        int[] nonDomainNodes = new int[mappedNonDomain.length];
        int index = 0;
        for (int node : scc) {
            if (domain.contains(node)) continue;
            mappedNonDomain[index] = nodeMap[node];
            nonDomainNodes[index] = node;
            ++index;
        }
        int[][] mappedDomain = new int[domain.size()][];
        index = 0;
        for (IntCursor cursor : domain) {
            mappedDomain[index] = nodeMap[cursor.value];
            domainNodes[index] = cursor.value;
            ++index;
        }
        int[] nodesToCopy = this.withCopies(IrreducibleGraphConverter.flatten(mappedNonDomain));
        int[] copies = this.backend.split(this.withCopies(IrreducibleGraphConverter.flatten(mappedDomain)), nodesToCopy);
        this.registerCopies(nodesToCopy, copies);
        for (int[] nodes : newNodes = IrreducibleGraphConverter.unflatten(this.withoutCopies(copies), mappedNonDomain)) {
            this.totalNodeCount += nodes.length;
        }
        int[][] newNodeMap = new int[1 + scc.length + newNodes.length][];
        int[] newNodeBackMap = new int[this.totalNodeCount];
        int[] mappedWeight = new int[newNodeMap.length];
        Arrays.fill(newNodeBackMap, -1);
        newNodeMap[0] = nodeMap[sharedDom];
        newNodeBackMap[sharedDom] = 0;
        mappedWeight[0] = djGraph.weightOf(sharedDom);
        index = 1;
        for (i2 = 0; i2 < mappedDomain.length; ++i2) {
            newNodeMap[index] = mappedDomain[i2];
            newNodeBackMap[domainNodes[i2]] = index;
            mappedWeight[index] = djGraph.weightOf(domainNodes[i2]);
            ++index;
        }
        for (i2 = 0; i2 < mappedNonDomain.length; ++i2) {
            newNodeMap[index] = mappedNonDomain[i2];
            newNodeBackMap[nonDomainNodes[i2]] = index;
            mappedWeight[index] = djGraph.weightOf(nonDomainNodes[i2]);
            ++index;
        }
        for (i2 = 0; i2 < mappedNonDomain.length; ++i2) {
            newNodeMap[index] = newNodes[i2];
            mappedWeight[index] = djGraph.weightOf(nonDomainNodes[i2]);
            ++index;
        }
        GraphBuilder builder = new GraphBuilder(newNodeMap.length);
        for (int succ : this.cfg.outgoingEdges(sharedDom)) {
            int j2 = newNodeBackMap[succ];
            if (j2 < 0) continue;
            builder.addEdge(0, j2);
        }
        for (i = 1; i <= mappedDomain.length; ++i) {
            for (int succ : djGraph.getCfg().outgoingEdges(domainNodes[i - 1])) {
                j = newNodeBackMap[succ];
                if (j > mappedDomain.length) {
                    builder.addEdge(i, j + mappedNonDomain.length);
                    continue;
                }
                if (j < 0) continue;
                builder.addEdge(i, j);
            }
        }
        index = 0;
        for (i = mappedDomain.length + 1; i <= scc.length; ++i) {
            for (int succ : djGraph.getCfg().outgoingEdges(nonDomainNodes[index++])) {
                j = newNodeBackMap[succ];
                if (j < 0) continue;
                builder.addEdge(i, j);
                if (j > mappedDomain.length) {
                    builder.addEdge(i + mappedNonDomain.length, j + mappedNonDomain.length);
                    continue;
                }
                builder.addEdge(i + mappedNonDomain.length, j);
            }
        }
        this.handleLoops(new DJGraph(builder.build(), mappedWeight), newNodeMap);
    }

    private int[] withCopies(int[] nodes) {
        IntegerArray nodesWithCopies = new IntegerArray(nodes.length);
        for (int node : nodes) {
            nodesWithCopies.add(node);
            IntSet copies = this.nodeCopies[node];
            if (copies == null) continue;
            nodesWithCopies.addAll(copies.toArray());
        }
        return nodesWithCopies.getAll();
    }

    private int[] withoutCopies(int[] nodesWithCopies) {
        IntHashSet visited = new IntHashSet();
        int[] nodes = new int[nodesWithCopies.length];
        int sz = 0;
        for (int node : nodesWithCopies) {
            if (!visited.add(node = this.nodeOriginals.get(node))) continue;
            nodes[sz++] = node;
        }
        return Arrays.copyOf(nodes, sz);
    }

    private void registerCopies(int[] originalNodes, int[] copies) {
        for (int i = 0; i < originalNodes.length; ++i) {
            int original = this.nodeOriginals.get(originalNodes[i]);
            int copy = copies[i];
            IntSet knownCopies = this.nodeCopies[original];
            if (knownCopies == null) {
                this.nodeCopies[original] = knownCopies = new IntHashSet();
            }
            if (!knownCopies.add(copy)) continue;
            while (this.nodeOriginals.size() <= copy) {
                this.nodeOriginals.add(-1);
            }
            this.nodeOriginals.set(copy, original);
        }
    }

    private void collapse(DJGraph djGraph, int[] scc, int[][] nodeMap) {
        int cls = djGraph.collapse(scc);
        IntegerArray nodes = new IntegerArray(djGraph.getGraph().size());
        for (int representative : djGraph.classRepresentatives(cls)) {
            for (int node : nodeMap[representative]) {
                nodes.add(node);
            }
        }
        for (int representative : djGraph.classRepresentatives(cls)) {
            nodeMap[representative] = new int[0];
        }
        nodeMap[cls] = nodes.getAll();
    }

    private static int[] flatten(int[][] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            count += array[i].length;
        }
        int[] flat = new int[count];
        int index = 0;
        for (int i = 0; i < array.length; ++i) {
            int[] part = array[i];
            for (int j = 0; j < part.length; ++j) {
                flat[index++] = part[j];
            }
        }
        return flat;
    }

    private static int[][] unflatten(int[] flat, int[][] pattern) {
        int[][] rough = new int[pattern.length][];
        int index = 0;
        for (int i = 0; i < rough.length; ++i) {
            int[] part = new int[pattern[i].length];
            for (int j = 0; j < part.length; ++j) {
                part[j] = flat[index++];
            }
            rough[i] = part;
        }
        return rough;
    }

    static class DJGraphNodeFilter
    implements IntPredicate {
        private DJGraph graph;
        private int level;

        public DJGraphNodeFilter(DJGraph graph, int level) {
            this.graph = graph;
            this.level = level;
        }

        @Override
        public boolean test(int node) {
            return this.graph.levelOf(node) >= this.level;
        }
    }
}

