/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.Arrays;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.common.IntegerArray;
import org.teavm.common.IntegerStack;
import org.teavm.common.LCATree;
import org.teavm.common.MutableDirectedGraph;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.cursors.IntCursor;

public class DJGraph {
    private DominatorTree domTree;
    private MutableDirectedGraph cfg;
    private MutableDirectedGraph graph;
    private LCATree spanningTree;
    private int[] spanningTreeNode;
    private int[] spanningTreeIndex;
    private int[][] levelContent;
    private int[] mergeRoot;
    private int[] weight;
    private IntegerArray[] mergeClasses;

    public DJGraph(Graph src, int[] weight) {
        if (src.size() != weight.length) {
            throw new IllegalArgumentException("Node count " + src.size() + " is not equal to weight array " + weight.length);
        }
        this.cfg = new MutableDirectedGraph(src);
        this.domTree = GraphUtils.buildDominatorTree(src);
        this.buildGraph(src);
        this.buildLevels();
        this.spanningTree = new LCATree(src.size());
        this.dfs();
        this.mergeRoot = new int[src.size()];
        this.mergeClasses = new IntegerArray[src.size()];
        for (int i = 0; i < this.mergeRoot.length; ++i) {
            this.mergeRoot[i] = i;
            this.mergeClasses[i] = IntegerArray.of(i);
        }
        this.weight = Arrays.copyOf(weight, weight.length);
    }

    private void buildGraph(Graph src) {
        int i;
        this.graph = new MutableDirectedGraph();
        for (i = 0; i < src.size(); ++i) {
            for (int j : src.outgoingEdges(i)) {
                this.graph.addEdge(i, j);
            }
        }
        for (i = 0; i < this.graph.size(); ++i) {
            int j = this.domTree.immediateDominatorOf(i);
            if (j < 0) continue;
            this.graph.addEdge(j, i);
        }
    }

    private void buildLevels() {
        int i;
        ArrayList<IntegerArray> builder = new ArrayList<IntegerArray>();
        for (i = 0; i < this.graph.size(); ++i) {
            int level = this.domTree.levelOf(i);
            while (level >= builder.size()) {
                builder.add(new IntegerArray(1));
            }
            ((IntegerArray)builder.get(level)).add(i);
        }
        this.levelContent = new int[builder.size() - 1][];
        for (i = 1; i < builder.size(); ++i) {
            this.levelContent[i - 1] = ((IntegerArray)builder.get(i)).getAll();
        }
    }

    private void dfs() {
        this.spanningTreeNode = new int[this.graph.size()];
        this.spanningTreeIndex = new int[this.graph.size()];
        Arrays.fill(this.spanningTreeIndex, -1);
        Arrays.fill(this.spanningTreeNode, -1);
        boolean[] visited = new boolean[this.graph.size()];
        IntegerStack stack = new IntegerStack(this.graph.size() * 2);
        stack.push(-1);
        stack.push(0);
        while (!stack.isEmpty()) {
            int node = stack.pop();
            int source = stack.pop();
            if (visited[node]) continue;
            int index = source >= 0 ? this.spanningTree.addNode(this.spanningTreeIndex[source]) : 0;
            this.spanningTreeNode[index] = node;
            this.spanningTreeIndex[node] = index;
            visited[node] = true;
            for (int succ : this.graph.outgoingEdges(node)) {
                stack.push(node);
                stack.push(succ);
            }
        }
    }

    public MutableDirectedGraph getCfg() {
        return this.cfg;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public boolean isAncestorInSpanningTree(int anc, int node) {
        anc = this.spanningTreeIndex[this.mergeRoot[anc]];
        node = this.spanningTreeIndex[this.mergeRoot[node]];
        if (anc < 0 || node < 0) {
            return false;
        }
        return this.spanningTree.lcaOf(anc, node) == anc;
    }

    public boolean isDomEdge(int i, int j) {
        return this.immediateDominatorOf(j) == this.mergeRoot[i];
    }

    public int immediateDominatorOf(int node) {
        int dom = this.domTree.immediateDominatorOf(this.mergeRoot[node]);
        return dom >= 0 ? this.mergeRoot[dom] : dom;
    }

    public int commonDominatorOf(int a, int b) {
        int dom = this.domTree.commonDominatorOf(this.mergeRoot[a], this.mergeRoot[b]);
        return dom >= 0 ? this.mergeRoot[dom] : dom;
    }

    public boolean isJoinEdge(int i, int j) {
        return !this.isDomEdge(i, j);
    }

    public boolean isBackJoin(int i, int j) {
        return this.isJoinEdge(i, j) && this.domTree.dominates(this.mergeRoot[j], this.mergeRoot[i]);
    }

    public boolean isCrossJoin(int i, int j) {
        return this.isJoinEdge(i, j) && !this.domTree.dominates(this.mergeRoot[j], this.mergeRoot[i]);
    }

    public boolean isSpanningBack(int i, int j) {
        return this.spanningTree.lcaOf(i = this.spanningTreeIndex[this.mergeRoot[i]], j = this.spanningTreeIndex[this.mergeRoot[j]]) == j;
    }

    public boolean isSpanningCross(int i, int j) {
        int c = this.spanningTree.lcaOf(i = this.spanningTreeIndex[this.mergeRoot[i]], j = this.spanningTreeIndex[this.mergeRoot[j]]);
        return c != i && c != j;
    }

    public int weightOf(int node) {
        return this.weight[node];
    }

    public int weightOf(int ... nodes) {
        int result = 0;
        for (int node : nodes) {
            result += this.weight[node];
        }
        return result;
    }

    public int levelOf(int node) {
        return this.domTree.levelOf(this.mergeRoot[node]) - 1;
    }

    public int[] level(int level) {
        int[] result = this.levelContent[level];
        return Arrays.copyOf(result, result.length);
    }

    public int levelCount() {
        return this.levelContent.length;
    }

    public int[] classRepresentatives(int node) {
        return this.mergeClasses[node].getAll();
    }

    public int classOf(int node) {
        return this.mergeRoot[node];
    }

    public int collapse(int[] nodes) {
        IntHashSet set = new IntHashSet();
        int top = nodes[0];
        for (int node : nodes) {
            node = this.mergeRoot[node];
            top = this.domTree.commonDominatorOf(top, node);
            set.add(node);
        }
        if (!set.contains(top)) {
            throw new IllegalArgumentException("All nodes must have one common dominator");
        }
        IntegerArray cls = this.mergeClasses[top];
        for (IntCursor node : set) {
            this.mergeRoot[node.value] = top;
            if (node.value != top) {
                cls.addAll(this.mergeClasses[node.value].getAll());
                this.mergeClasses[node.value].clear();
            }
            int n = top;
            this.weight[n] = this.weight[n] + this.weight[node.value];
        }
        for (IntCursor node : set) {
            if (node.value == top) continue;
            for (int succ : this.graph.outgoingEdges(node.value)) {
                this.graph.addEdge(top, succ);
            }
            for (int pred : this.graph.incomingEdges(node.value)) {
                this.graph.addEdge(top, pred);
            }
            this.graph.detachNode(node.value);
            for (int succ : this.cfg.outgoingEdges(node.value)) {
                this.cfg.addEdge(top, succ);
            }
            for (int pred : this.cfg.incomingEdges(node.value)) {
                this.cfg.addEdge(top, pred);
            }
            this.cfg.detachNode(node.value);
        }
        return top;
    }
}

