/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.util.THashSet;
import org.teavm.classlib.java.util.TSet;
import org.teavm.classlib.java.util.TTimerTask;
import org.teavm.jso.browser.TimerHandler;
import org.teavm.jso.browser.Window;

public class TTimer
extends TObject {
    TSet<TTimerTask> tasks = new THashSet<TTimerTask>();
    private boolean cancelled;

    public TTimer() {
    }

    public TTimer(TString name) {
    }

    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        for (TTimerTask task : this.tasks.toArray(new TTimerTask[0])) {
            task.cancel();
        }
    }

    public void schedule(TTimerTask task, long delay) {
        if (this.cancelled || task.timer != null || task.nativeTimerId >= 0) {
            throw new TIllegalStateException();
        }
        task.timer = this;
        task.nativeTimerId = Window.setTimeout(() -> new Thread(() -> {
            if (this.cancelled || task.timer == null) {
                return;
            }
            TTimerTask.performOnce(task);
        }).start(), (int)delay);
    }

    public void schedule(final TTimerTask task, long delay, final long period) {
        if (this.cancelled || task.timer != null || task.nativeTimerId >= 0) {
            throw new TIllegalStateException();
        }
        task.timer = this;
        TimerHandler handler = new TimerHandler(){

            @Override
            public void onTimer() {
                new Thread(() -> {
                    if (TTimer.this.cancelled || task2.timer == null) {
                        return;
                    }
                    task2.nativeTimerId = Window.setTimeout((TimerHandler)this, (int)period);
                    TTimerTask.performOnce(task);
                    if (!TTimer.this.cancelled) {
                        task2.timer = TTimer.this;
                    }
                }).start();
            }
        };
        task.nativeTimerId = Window.setTimeout(handler, (int)delay);
    }

    public void scheduleAtFixedRate(final TTimerTask task, long delay, final long period) {
        if (this.cancelled || task.timer != null || task.nativeTimerId >= 0) {
            throw new TIllegalStateException();
        }
        final long[] nextStartTime = new long[]{System.currentTimeMillis() + delay};
        task.timer = this;
        TimerHandler handler = new TimerHandler(){

            @Override
            public void onTimer() {
                new Thread(() -> {
                    if (TTimer.this.cancelled || task2.timer == null) {
                        return;
                    }
                    long nextDelay = nextStartTime[0] - System.currentTimeMillis();
                    if (nextDelay < 0L) {
                        nextDelay = 0L;
                    }
                    task2.nativeTimerId = Window.setTimeout((TimerHandler)this, (int)nextDelay);
                    nextStartTime2[0] = nextStartTime[0] + period;
                    TTimerTask.performOnce(task);
                    if (!TTimer.this.cancelled) {
                        task2.timer = TTimer.this;
                    }
                }).start();
            }
        };
        task.nativeTimerId = Window.setTimeout(handler, (int)delay);
        nextStartTime[0] = nextStartTime[0] + period;
    }
}

