/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.DynamicCallSite;
import org.teavm.model.MethodReference;
import org.teavm.model.ReferenceCache;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;

public class StringConcatFactorySubstitutor
implements BootstrapMethodSubstitutor {
    private ReferenceCache referenceCache = new ReferenceCache();
    private static final String STRING_BUILDER = "java.lang.StringBuilder";
    private static final char VALUE_ARGUMENT = '\u0001';
    private static final char CONST_ARGUMENT = '\u0002';

    @Override
    public ValueEmitter substitute(DynamicCallSite callSite, ProgramEmitter pe) {
        ValueEmitter sb = pe.construct(STRING_BUILDER, new ValueEmitter[0]);
        if (callSite.getBootstrapMethod().getName().equals("makeConcatWithConstants")) {
            this.appendArgumentWithRecipe(sb, callSite);
        } else {
            this.appendSimpleArguments(sb, callSite);
        }
        return sb.invokeSpecial("toString", ValueType.object("java.lang.String"), new ValueEmitter[0]);
    }

    private ValueEmitter appendSimpleArguments(ValueEmitter sb, DynamicCallSite callSite) {
        int parameterCount = callSite.getCalledMethod().parameterCount();
        for (int i = 0; i < parameterCount; ++i) {
            sb = this.appendArgument(sb, callSite.getCalledMethod().parameterType(i), callSite.getArguments().get(i));
        }
        return sb;
    }

    private ValueEmitter appendArgumentWithRecipe(ValueEmitter sb, DynamicCallSite callSite) {
        String recipe = callSite.getBootstrapArguments().get(0).getString();
        int charCount = recipe.length();
        int constantIndex = 0;
        int valueIndex = 0;
        int paramIndex = 0;
        StringBuilder acc = new StringBuilder();
        block4: for (int i = 0; i < charCount; ++i) {
            char c = recipe.charAt(i);
            switch (c) {
                case '\u0001': {
                    sb = this.flushAcc(sb, acc);
                    ValueType type = callSite.getCalledMethod().parameterType(paramIndex++);
                    sb = this.appendArgument(sb, type, callSite.getArguments().get(valueIndex++));
                    continue block4;
                }
                case '\u0002': {
                    sb = this.flushAcc(sb, acc);
                    ValueType type = callSite.getCalledMethod().parameterType(paramIndex++);
                    RuntimeConstant poolConstant = callSite.getBootstrapArguments().get(1 + constantIndex++);
                    sb = this.appendArgument(sb, type, this.constant(sb.getProgramEmitter(), poolConstant));
                    continue block4;
                }
                default: {
                    acc.append(c);
                }
            }
        }
        sb = this.flushAcc(sb, acc);
        return sb;
    }

    private ValueEmitter flushAcc(ValueEmitter sb, StringBuilder acc) {
        if (acc.length() == 0) {
            return sb;
        }
        sb = acc.length() == 1 ? this.appendArgument(sb, ValueType.CHARACTER, sb.getProgramEmitter().constant(acc.charAt(0)).cast(ValueType.CHARACTER)) : this.appendArgument(sb, ValueType.object("java.lang.Object"), sb.getProgramEmitter().constant(acc.toString()));
        acc.setLength(0);
        return sb;
    }

    private ValueEmitter appendArgument(ValueEmitter sb, ValueType type, ValueEmitter argument) {
        if (!(type instanceof ValueType.Primitive)) {
            type = ValueType.object("java.lang.Object");
        }
        MethodReference method = this.referenceCache.getCached(new MethodReference(STRING_BUILDER, "append", type, ValueType.object(STRING_BUILDER)));
        return sb.invokeSpecial(method, argument);
    }

    private ValueEmitter constant(ProgramEmitter pe, RuntimeConstant value) {
        switch (value.getKind()) {
            case 4: {
                return pe.constant(value.getString());
            }
            case 5: {
                return pe.constant(value.getValueType());
            }
            case 0: {
                return pe.constant(value.getInt());
            }
            case 1: {
                return pe.constant(value.getLong());
            }
            case 2: {
                return pe.constant(value.getFloat());
            }
            case 3: {
                return pe.constant(value.getDouble());
            }
        }
        throw new IllegalArgumentException("Unsupported constant type: " + value.getKind());
    }
}

