/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import java.util.ArrayList;
import java.util.List;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.generate.CallSiteBinaryGenerator;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.model.MethodReference;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.runtime.CallSite;
import org.teavm.runtime.ExceptionHandling;

public class ExceptionHandlingIntrinsic
implements WasmIntrinsic {
    private CallSiteBinaryGenerator callSiteBinaryGenerator;
    private WasmClassGenerator classGenerator;
    private List<WasmInt32Constant> constants = new ArrayList<WasmInt32Constant>();

    public ExceptionHandlingIntrinsic(BinaryWriter binaryWriter, WasmClassGenerator classGenerator, WasmStringPool stringPool) {
        this.callSiteBinaryGenerator = new CallSiteBinaryGenerator(binaryWriter, classGenerator, stringPool);
        this.classGenerator = classGenerator;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(ExceptionHandling.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "findCallSiteById": 
            case "isJumpSupported": 
            case "jumpToFrame": 
            case "abort": {
                return true;
            }
        }
        return false;
    }

    public void postProcess(List<? extends CallSiteDescriptor> callSites) {
        int address = this.callSiteBinaryGenerator.writeCallSites(callSites);
        for (WasmInt32Constant constant : this.constants) {
            constant.setValue(address);
        }
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "findCallSiteById": {
                WasmInt32Constant constant = new WasmInt32Constant(0);
                constant.setLocation(invocation.getLocation());
                this.constants.add(constant);
                int callSiteSize = this.classGenerator.getClassSize(CallSite.class.getName());
                WasmExpression id = manager.generate(invocation.getArguments().get(0));
                WasmIntBinary offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.MUL, id, new WasmInt32Constant(callSiteSize));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, constant, offset);
            }
            case "isJumpSupported": {
                return new WasmInt32Constant(0);
            }
            case "jumpToFrame": 
            case "abort": {
                return new WasmUnreachable();
            }
        }
        throw new IllegalArgumentException("Unknown method: " + invocation.getMethod());
    }
}

