/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.intrinsic;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.MethodReference;
import org.teavm.runtime.GC;

public class GCIntrinsic
implements Intrinsic {
    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(GC.class.getName())) {
            return false;
        }
        switch (method.getName()) {
            case "gcStorageAddress": 
            case "gcStorageSize": 
            case "heapAddress": 
            case "regionsAddress": 
            case "regionMaxCount": 
            case "availableBytes": 
            case "regionSize": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        context.includes().includePath("memory.h");
        context.includes().includePath("heaptrace.h");
        context.writer().print("teavm_gc_").print(invocation.getMethod().getName());
    }
}

