/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.analyze;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.RecursiveVisitor;
import org.teavm.ast.Statement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.VariableExpr;
import org.teavm.backend.c.analyze.AstDefinitionUsageAnalysis;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntSet;

public class VolatileDefinitionFinder {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private Map<AssignmentStatement, StackElement> defHandlers = new HashMap<AssignmentStatement, StackElement>();
    private Set<AssignmentStatement> definitionsToBackup = new HashSet<AssignmentStatement>();
    private Map<TryCatchStatement, IntSet> usagesToRestoreByHandler = new HashMap<TryCatchStatement, IntSet>();
    private RecursiveVisitor handlerAnalyzer = new RecursiveVisitor(){
        StackElement surroundingTryCatches;
        StackElement handlingTryCatches;

        @Override
        public void visit(TryCatchStatement statement) {
            this.surroundingTryCatches = new StackElement(statement, this.surroundingTryCatches);
            this.visit(statement.getProtectedBody());
            this.surroundingTryCatches = this.surroundingTryCatches.next;
            this.visit(statement.getHandler());
        }

        @Override
        public void visit(AssignmentStatement statement) {
            super.visit(statement);
            if (statement.getLeftValue() instanceof VariableExpr && this.surroundingTryCatches != null) {
                VolatileDefinitionFinder.this.defHandlers.put(statement, this.surroundingTryCatches);
            }
        }
    };

    public void findVolatileDefinitions(Statement statement) {
        AstDefinitionUsageAnalysis defuse = new AstDefinitionUsageAnalysis();
        defuse.analyze(statement);
        statement.acceptVisitor(this.handlerAnalyzer);
        for (AstDefinitionUsageAnalysis.Definition definition : defuse.getDefinitions()) {
            StackElement stack = this.defHandlers.get(definition.getStatement());
            if (stack == null || definition.getExceptionHandlingUsages().isEmpty()) continue;
            while (stack != null) {
                if (definition.getExceptionHandlingUsages().get(stack.statement) != null) {
                    IntSet usagesToRestore = this.usagesToRestoreByHandler.get(stack.statement);
                    if (usagesToRestore == null) {
                        usagesToRestore = new IntHashSet();
                        this.usagesToRestoreByHandler.put(stack.statement, usagesToRestore);
                    }
                    usagesToRestore.add(definition.getVariableIndex());
                    this.definitionsToBackup.add(definition.getStatement());
                }
                stack = stack.next;
            }
        }
        this.defHandlers = null;
    }

    public boolean shouldBackup(AssignmentStatement statement) {
        return this.definitionsToBackup.contains(statement);
    }

    public int[] variablesToRestore(TryCatchStatement tryCatch) {
        IntSet result = this.usagesToRestoreByHandler.get(tryCatch);
        if (result == null) {
            return EMPTY_INT_ARRAY;
        }
        int[] array = result.toArray();
        Arrays.sort(array);
        return array;
    }

    static class StackElement {
        final TryCatchStatement statement;
        final StackElement next;

        StackElement(TryCatchStatement statement, StackElement next) {
            this.statement = statement;
            this.next = next;
        }
    }
}

