/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import java.time.zone.ZoneRules;
import org.teavm.classlib.impl.tz.DateTimeZone;
import org.teavm.classlib.impl.tz.StorableDateTimeZone;

public final class CachedDateTimeZone
extends StorableDateTimeZone {
    private static final int cInfoCacheMask = 511;
    private final StorableDateTimeZone iZone;
    private final transient Info[] iInfoCache = new Info[cInfoCacheMask + 1];

    public static CachedDateTimeZone forZone(StorableDateTimeZone zone) {
        if (zone instanceof CachedDateTimeZone) {
            return (CachedDateTimeZone)zone;
        }
        return new CachedDateTimeZone(zone);
    }

    private CachedDateTimeZone(StorableDateTimeZone zone) {
        super(zone.getID());
        this.iZone = zone;
    }

    @Override
    public void write(StringBuilder sb) {
        this.iZone.write(sb);
    }

    public DateTimeZone getUncachedZone() {
        return this.iZone;
    }

    @Override
    public int getOffset(long instant) {
        return this.getInfo(instant).getOffset(instant);
    }

    @Override
    public int getStandardOffset(long instant) {
        return this.getInfo(instant).getStandardOffset(instant);
    }

    @Override
    public boolean isFixed() {
        return this.iZone.isFixed();
    }

    @Override
    public long nextTransition(long instant) {
        return this.iZone.nextTransition(instant);
    }

    @Override
    public long previousTransition(long instant) {
        return this.iZone.previousTransition(instant);
    }

    @Override
    public ZoneRules asZoneRules() {
        return this.iZone.asZoneRules();
    }

    private Info getInfo(long millis) {
        Info[] cache = this.iInfoCache;
        int period = (int)(millis >> 32);
        int index = period & cInfoCacheMask;
        Info info = cache[index];
        if (info == null || (int)(info.iPeriodStart >> 32) != period) {
            cache[index] = info = this.createInfo(millis);
        }
        return info;
    }

    private Info createInfo(long millis) {
        long next;
        long periodStart = millis & 0xFFFFFFFF00000000L;
        Info info = new Info(this.iZone, periodStart);
        long end = periodStart | 0xFFFFFFFFL;
        Info chain = info;
        while ((next = this.iZone.nextTransition(periodStart)) != periodStart && next <= end) {
            periodStart = next;
            chain = chain.iNextInfo = new Info(this.iZone, periodStart);
        }
        return info;
    }

    private static final class Info {
        public final long iPeriodStart;
        public final DateTimeZone iZoneRef;
        Info iNextInfo;
        private int iOffset = Integer.MIN_VALUE;
        private int iStandardOffset = Integer.MIN_VALUE;

        Info(DateTimeZone zone, long periodStart) {
            this.iPeriodStart = periodStart;
            this.iZoneRef = zone;
        }

        public int getOffset(long millis) {
            if (this.iNextInfo == null || millis < this.iNextInfo.iPeriodStart) {
                if (this.iOffset == Integer.MIN_VALUE) {
                    this.iOffset = this.iZoneRef.getOffset(this.iPeriodStart);
                }
                return this.iOffset;
            }
            return this.iNextInfo.getOffset(millis);
        }

        public int getStandardOffset(long millis) {
            if (this.iNextInfo == null || millis < this.iNextInfo.iPeriodStart) {
                if (this.iStandardOffset == Integer.MIN_VALUE) {
                    this.iStandardOffset = this.iZoneRef.getStandardOffset(this.iPeriodStart);
                }
                return this.iStandardOffset;
            }
            return this.iNextInfo.getStandardOffset(millis);
        }
    }
}

