/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.util.TEnumSet;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformClass;

class TGenericEnumSet<E extends Enum<E>>
extends TEnumSet<E> {
    Class<E> cls;
    int[] bits;

    TGenericEnumSet(Class<E> cls) {
        this.cls = cls;
        Enum<E>[] constants = TGenericEnumSet.getConstants(cls);
        if (constants == null) {
            throw new ClassCastException();
        }
        int constantCount = constants.length;
        int bitCount = constantCount == 0 ? 0 : (constantCount - 1) / 32 + 1;
        this.bits = new int[bitCount];
    }

    TGenericEnumSet(Class<E> cls, int[] bits) {
        this.cls = cls;
        this.bits = bits;
    }

    static Enum<?>[] getConstants(Class<?> cls) {
        PlatformClass platformClass = ((TClass)((Object)cls)).getPlatformClass();
        Platform.initClass((PlatformClass)platformClass);
        return Platform.getEnumConstants((PlatformClass)platformClass);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index = this.find();
            private int indexToRemove = -1;

            private int find() {
                int overflow = TGenericEnumSet.this.bits.length * 32;
                while (this.index < overflow) {
                    int next = Integer.numberOfTrailingZeros(TGenericEnumSet.this.bits[this.index / 32] >>> this.index % 32);
                    if (next < 32) {
                        this.index += next;
                        return this.index;
                    }
                    this.index = (this.index / 32 + 1) * 32;
                }
                return this.index;
            }

            @Override
            public boolean hasNext() {
                return this.index < TGenericEnumSet.this.bits.length * 32;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new TNoSuchElementException();
                }
                this.indexToRemove = this.index;
                Enum returnValue = TGenericEnumSet.getConstants(TGenericEnumSet.this.cls)[this.index++];
                this.index = this.find();
                return returnValue;
            }

            @Override
            public void remove() {
                int bitNumber;
                if (this.indexToRemove < 0) {
                    throw new IllegalStateException();
                }
                int n = bitNumber = this.indexToRemove / 32;
                TGenericEnumSet.this.bits[n] = TGenericEnumSet.this.bits[n] & ~(1 << this.indexToRemove % 32);
                this.indexToRemove = -1;
            }
        };
    }

    @Override
    public int size() {
        int result = 0;
        for (int bit : this.bits) {
            result += Integer.bitCount(bit);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TGenericEnumSet)) {
            return super.equals(o);
        }
        TGenericEnumSet other = (TGenericEnumSet)o;
        if (this.cls != other.cls) {
            return this.size() == 0 && other.size() == 0;
        }
        return Arrays.equals(this.bits, other.bits);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof TGenericEnumSet) {
            TGenericEnumSet other = (TGenericEnumSet)c;
            if (this.cls == other.cls) {
                boolean changed = false;
                for (int i = 0; i < this.bits.length; ++i) {
                    int inv = ~other.bits[i];
                    if ((this.bits[i] & inv) == this.bits[i]) continue;
                    changed = true;
                    int n = i;
                    this.bits[n] = this.bits[n] & inv;
                }
                return changed;
            }
        }
        return super.removeAll(c);
    }

    @Override
    public boolean contains(Object o) {
        int bit;
        if (!this.cls.isInstance(o)) {
            return false;
        }
        int n = ((Enum)o).ordinal();
        int bitNumber = n / 32;
        return (this.bits[bitNumber] & (bit = 1 << n % 32)) != 0;
    }

    @Override
    void fastAdd(int n) {
        int bitNumber;
        int n2 = bitNumber = n / 32;
        this.bits[n2] = this.bits[n2] | 1 << n % 32;
    }

    @Override
    public boolean add(E t) {
        int bit;
        Class<?> tCls = t.getClass();
        if (tCls != this.cls && tCls.getSuperclass() != this.cls) {
            throw new ClassCastException();
        }
        int n = ((Enum)t).ordinal();
        int bitNumber = n / 32;
        if ((this.bits[bitNumber] & (bit = 1 << n % 32)) == 0) {
            int n2 = bitNumber;
            this.bits[n2] = this.bits[n2] | bit;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        int bit;
        if (!this.cls.isInstance(o)) {
            return false;
        }
        int n = ((Enum)o).ordinal();
        int bitNumber = n / 32;
        if ((this.bits[bitNumber] & (bit = 1 << n % 32)) != 0) {
            int n2 = bitNumber;
            this.bits[n2] = this.bits[n2] & ~bit;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof TGenericEnumSet) {
            TGenericEnumSet other = (TGenericEnumSet)c;
            if (this.cls == other.cls) {
                for (int i = 0; i < this.bits.length; ++i) {
                    if ((this.bits[i] | other.bits[i]) == this.bits[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return super.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c instanceof TGenericEnumSet) {
            TGenericEnumSet other = (TGenericEnumSet)c;
            if (this.cls == other.cls) {
                boolean added = false;
                for (int i = 0; i < this.bits.length; ++i) {
                    if ((this.bits[i] | other.bits[i]) == this.bits[i]) continue;
                    added = true;
                    int n = i;
                    this.bits[n] = this.bits[n] | other.bits[i];
                }
                return added;
            }
        }
        return super.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof TGenericEnumSet) {
            TGenericEnumSet other = (TGenericEnumSet)c;
            if (this.cls == other.cls) {
                boolean changed = false;
                for (int i = 0; i < this.bits.length; ++i) {
                    if ((this.bits[i] & other.bits[i]) == this.bits[i]) continue;
                    changed = true;
                    int n = i;
                    this.bits[n] = this.bits[n] & other.bits[i];
                }
                return changed;
            }
        }
        return super.retainAll(c);
    }

    @Override
    public void clear() {
        Arrays.fill(this.bits, 0);
    }
}

