/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import java.util.ArrayList;
import java.util.Iterator;
import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TFSet;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;

class TJointSet
extends TAbstractSet {
    protected ArrayList<TAbstractSet> children;
    protected TAbstractSet fSet;
    protected int groupIndex;

    protected TJointSet() {
    }

    public TJointSet(ArrayList<TAbstractSet> children, TFSet fSet) {
        this.children = children;
        this.fSet = fSet;
        this.groupIndex = fSet.getGroupIndex();
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (this.children == null) {
            return -1;
        }
        int start = matchResult.getStart(this.groupIndex);
        matchResult.setStart(this.groupIndex, stringIndex);
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            TAbstractSet e = this.children.get(i);
            int shift = e.matches(stringIndex, testString, matchResult);
            if (shift < 0) continue;
            return shift;
        }
        matchResult.setStart(this.groupIndex, start);
        return -1;
    }

    @Override
    public void setNext(TAbstractSet next) {
        this.fSet.setNext(next);
    }

    @Override
    public TAbstractSet getNext() {
        return this.fSet.getNext();
    }

    @Override
    protected String getName() {
        return "JointSet";
    }

    public int getGroup() {
        return this.groupIndex;
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (this.children != null) {
            Iterator<TAbstractSet> i = this.children.iterator();
            while (i.hasNext()) {
                if (!i.next().first(set)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl matchResult) {
        return matchResult.getEnd(this.groupIndex) < 0 || matchResult.getStart(this.groupIndex) != matchResult.getEnd(this.groupIndex);
    }

    @Override
    public void processSecondPass() {
        this.isSecondPassVisited = true;
        if (this.fSet != null && !this.fSet.isSecondPassVisited) {
            this.fSet.processSecondPass();
        }
        if (this.children != null) {
            int childrenSize = this.children.size();
            for (int i = 0; i < childrenSize; ++i) {
                TAbstractSet child = this.children.get(i);
                TJointSet set = child.processBackRefReplacement();
                if (set != null) {
                    child.isSecondPassVisited = true;
                    this.children.remove(i);
                    this.children.add(i, set);
                    child = set;
                }
                if (child.isSecondPassVisited) continue;
                child.processSecondPass();
            }
        }
        if (this.next != null) {
            super.processSecondPass();
        }
    }
}

