/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.Consumer;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TLinkedHashMap;
import org.teavm.classlib.java.util.TLinkedHashMapIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TSequencedSet;

class TLinkedHashMapEntrySet<K, V>
extends TAbstractSet<TMap.Entry<K, V>>
implements TSequencedSet<TMap.Entry<K, V>> {
    private final TLinkedHashMap<K, V> base;
    private final boolean reversed;

    TLinkedHashMapEntrySet(TLinkedHashMap<K, V> base, boolean reversed) {
        this.base = base;
        this.reversed = reversed;
    }

    @Override
    public final int size() {
        return this.base.elementCount;
    }

    @Override
    public final void clear() {
        this.base.clear();
    }

    @Override
    public final TIterator<TMap.Entry<K, V>> iterator() {
        return new TLinkedHashMapIterator.EntryIterator<K, V>(this.base, this.reversed);
    }

    @Override
    public final boolean contains(Object o) {
        if (o instanceof TMap.Entry) {
            TMap.Entry oEntry = (TMap.Entry)o;
            THashMap.HashEntry entry = this.base.entryByKey(oEntry.getKey());
            return entry != null && TObjects.equals(entry.getValue(), oEntry.getValue());
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        TMap.Entry oEntry;
        THashMap.HashEntry entry;
        if (object instanceof TMap.Entry && (entry = this.base.entryByKey((oEntry = (TMap.Entry)object).getKey())) != null && TObjects.equals(entry.getValue(), oEntry.getValue())) {
            this.base.remove(entry.getKey());
            return true;
        }
        return false;
    }

    @Override
    public final void forEach(Consumer<? super TMap.Entry<K, V>> action) {
        if (this.base.elementCount > 0) {
            int prevModCount = this.base.modCount;
            TLinkedHashMap.LinkedHashMapEntry entry = this.reversed ? this.base.tail : this.base.head;
            do {
                action.accept(entry);
                TLinkedHashMap.LinkedHashMapEntry linkedHashMapEntry = entry = this.reversed ? entry.chainBackward : entry.chainForward;
                if (this.base.modCount == prevModCount) continue;
                throw new TConcurrentModificationException();
            } while (entry != null);
        }
    }

    @Override
    public final void addFirst(TMap.Entry<K, V> e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void addLast(TMap.Entry<K, V> e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final TMap.Entry<K, V> getFirst() {
        return TLinkedHashMap.checkNotNull(this.reversed ? this.base.tail : this.base.head);
    }

    @Override
    public final TMap.Entry<K, V> getLast() {
        return TLinkedHashMap.checkNotNull(this.reversed ? this.base.head : this.base.tail);
    }

    @Override
    public final TMap.Entry<K, V> removeFirst() {
        TLinkedHashMap.LinkedHashMapEntry e = TLinkedHashMap.checkNotNull(this.reversed ? this.base.tail : this.base.head);
        this.base.remove(e.key);
        return e;
    }

    @Override
    public final TMap.Entry<K, V> removeLast() {
        TLinkedHashMap.LinkedHashMapEntry e = TLinkedHashMap.checkNotNull(this.reversed ? this.base.head : this.base.tail);
        this.base.remove(e.key);
        return e;
    }

    @Override
    public TSequencedSet<TMap.Entry<K, V>> reversed() {
        return new TLinkedHashMapEntrySet<K, V>(this.base, !this.reversed);
    }
}

