/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TAbstractMap;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TMapEntry;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TSet;
import org.teavm.interop.Rename;

public class THashMap<K, V>
extends TAbstractMap<K, V>
implements TCloneable,
TSerializable {
    transient int elementCount;
    transient HashEntry<K, V>[] elementData;
    transient int modCount;
    private static final int DEFAULT_SIZE = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    final float loadFactor;
    int threshold;

    HashEntry<K, V>[] newElementArray(int s) {
        return new HashEntry[s];
    }

    public THashMap() {
        this(16);
    }

    public THashMap(int capacity) {
        this(capacity, 0.75f);
    }

    private static int calculateCapacity(int x) {
        if (x >= 0x40000000) {
            return 0x40000000;
        }
        if (x == 0) {
            return 16;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public THashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new TIllegalArgumentException();
        }
        capacity = THashMap.calculateCapacity(capacity);
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity);
        this.loadFactor = loadFactor;
        this.computeThreshold();
    }

    public THashMap(TMap<? extends K, ? extends V> map) {
        this(THashMap.calculateCapacity(map.size()));
        this.putAllImpl(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
        }
    }

    @Rename(value="clone")
    public TObject clone0() {
        try {
            THashMap map = (THashMap)super.clone();
            map.elementCount = 0;
            map.elementData = this.newElementArray(this.elementData.length);
            map.putAll(this);
            return map;
        }
        catch (TCloneNotSupportedException e) {
            return null;
        }
    }

    private void computeThreshold() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    @Override
    public boolean containsKey(Object key) {
        HashEntry<K, V> m = this.entryByKey(key);
        return m != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (int i = 0; i < this.elementData.length; ++i) {
                HashEntry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    if (value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            for (int i = 0; i < this.elementData.length; ++i) {
                HashEntry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return new HashMapEntrySet(this);
    }

    @Override
    public V get(Object key) {
        HashEntry<K, V> m = this.entryByKey(key);
        if (m != null) {
            return (V)m.value;
        }
        return null;
    }

    final HashEntry<K, V> entryByKey(Object key) {
        HashEntry<K, V> m;
        if (key == null) {
            m = this.findNullKeyEntry();
        } else {
            int hash = key.hashCode();
            int index = hash & this.elementData.length - 1;
            m = this.findNonNullKeyEntry(key, index, hash);
        }
        return m;
    }

    final HashEntry<K, V> findNonNullKeyEntry(Object key, int index, int keyHash) {
        HashEntry<K, V> m = this.elementData[index];
        while (!(m == null || m.origKeyHash == keyHash && THashMap.areEqualKeys(key, m.key))) {
            m = m.next;
        }
        return m;
    }

    final HashEntry<K, V> findNullKeyEntry() {
        HashEntry<K, V> m = this.elementData[0];
        while (m != null && m.key != null) {
            m = m.next;
        }
        return m;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public TSet<K> keySet() {
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new TAbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return THashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return THashMap.this.size();
                }

                @Override
                public void clear() {
                    THashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    HashEntry entry = THashMap.this.removeByKey(key);
                    return entry != null;
                }

                @Override
                public TIterator<K> iterator() {
                    return new KeyIterator(THashMap.this);
                }

                @Override
                public void forEach(Consumer<? super K> action) {
                    if (THashMap.this.elementCount > 0) {
                        int prevModCount = THashMap.this.modCount;
                        for (int i = 0; i < THashMap.this.elementData.length; ++i) {
                            HashEntry entry = THashMap.this.elementData[i];
                            while (entry != null) {
                                action.accept(entry.key);
                                entry = entry.next;
                                if (prevModCount == THashMap.this.modCount) continue;
                                throw new TConcurrentModificationException();
                            }
                        }
                    }
                }
            };
        }
        return this.cachedKeySet;
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value);
    }

    private V putImpl(K key, V value) {
        HashEntry<Object, V> entry;
        if (key == null) {
            entry = this.findNullKeyEntry();
            if (entry == null) {
                ++this.modCount;
                entry = this.createHashedEntry(null, 0, 0);
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
            }
        } else {
            int hash = key.hashCode();
            int index = hash & this.elementData.length - 1;
            entry = this.findNonNullKeyEntry(key, index, hash);
            if (entry == null) {
                ++this.modCount;
                entry = this.createHashedEntry(key, index, hash);
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
            }
        }
        Object result = entry.value;
        entry.value = value;
        return (V)result;
    }

    private HashEntry<K, V> createHashedEntry(K key, int index, int hash) {
        HashEntry<K, int> entry = new HashEntry<K, int>(key, hash);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> map) {
        if (!map.isEmpty()) {
            this.putAllImpl(map);
        }
    }

    void putAllImpl(TMap<? extends K, ? extends V> map) {
        int capacity = this.elementCount + map.size();
        if (capacity > this.threshold) {
            this.rehash(capacity);
        }
        TIterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            TMap.Entry entry = (TMap.Entry)it.next();
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    void rehash(int capacity) {
        int length = THashMap.calculateCapacity(capacity == 0 ? 1 : capacity << 1);
        HashEntry<K, V>[] newData = this.newElementArray(length);
        for (int i = 0; i < this.elementData.length; ++i) {
            HashEntry<K, V> entry = this.elementData[i];
            this.elementData[i] = null;
            while (entry != null) {
                int index = entry.origKeyHash & length - 1;
                HashEntry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeThreshold();
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    @Override
    public V remove(Object key) {
        HashEntry<K, V> entry = this.removeByKey(key);
        if (entry != null) {
            return (V)entry.value;
        }
        return null;
    }

    final HashEntry<K, V> removeByKey(Object key) {
        HashEntry<K, V> entry;
        int index = 0;
        HashEntry<K, V> last = null;
        if (key != null) {
            int hash = key.hashCode();
            index = hash & this.elementData.length - 1;
            entry = this.elementData[index];
            while (!(entry == null || entry.origKeyHash == hash && THashMap.areEqualKeys(key, entry.key))) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && entry.key != null) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index] = entry.next;
        } else {
            last.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public TCollection<V> values() {
        if (this.cachedValues == null) {
            this.cachedValues = new TAbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return THashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return THashMap.this.size();
                }

                @Override
                public void clear() {
                    THashMap.this.clear();
                }

                @Override
                public TIterator<V> iterator() {
                    return new ValueIterator(THashMap.this);
                }

                @Override
                public void forEach(Consumer<? super V> action) {
                    if (THashMap.this.elementCount > 0) {
                        int prevModCount = THashMap.this.modCount;
                        for (int i = 0; i < THashMap.this.elementData.length; ++i) {
                            HashEntry entry = THashMap.this.elementData[i];
                            while (entry != null) {
                                action.accept(entry.value);
                                entry = entry.next;
                                if (prevModCount == THashMap.this.modCount) continue;
                                throw new TConcurrentModificationException();
                            }
                        }
                    }
                }
            };
        }
        return this.cachedValues;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.elementCount > 0) {
            int prevModCount = this.modCount;
            for (int i = 0; i < this.elementData.length; ++i) {
                HashEntry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    action.accept(entry.key, entry.value);
                    entry = entry.next;
                    if (prevModCount == this.modCount) continue;
                    throw new TConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (this.elementCount > 0) {
            int prevModCount = this.modCount;
            for (int i = 0; i < this.elementData.length; ++i) {
                HashEntry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    entry.value = function.apply(entry.key, entry.value);
                    entry = entry.next;
                    if (prevModCount == this.modCount) continue;
                    throw new TConcurrentModificationException();
                }
            }
        }
    }

    static boolean areEqualKeys(Object key1, Object key2) {
        return key1 == key2 || key1.equals(key2);
    }

    static int capacity(int size) {
        return (int)Math.ceil((float)size / 0.75f);
    }

    public static <K, V> THashMap<K, V> newHashMap(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        return new THashMap<K, V>(THashMap.capacity(size));
    }

    static class HashEntry<K, V>
    extends TMapEntry<K, V> {
        final int origKeyHash;
        HashEntry<K, V> next;

        HashEntry(K theKey, int hash) {
            super(theKey, null);
            this.origKeyHash = hash;
        }

        HashEntry(K theKey, V theValue) {
            super(theKey, theValue);
            this.origKeyHash = TObjects.hashCode(theKey);
        }

        @Override
        public Object clone() {
            HashEntry entry = (HashEntry)super.clone();
            if (this.next != null) {
                entry.next = (HashEntry)this.next.clone();
            }
            return entry;
        }
    }

    static class HashMapEntrySet<K, V>
    extends TAbstractSet<TMap.Entry<K, V>> {
        private final THashMap<K, V> associatedMap;

        public HashMapEntrySet(THashMap<K, V> hm) {
            this.associatedMap = hm;
        }

        THashMap<K, V> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.elementCount;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        @Override
        public boolean remove(Object object) {
            TMap.Entry oEntry;
            HashEntry<K, V> entry;
            if (object instanceof TMap.Entry && (entry = this.associatedMap.entryByKey((oEntry = (TMap.Entry)object).getKey())) != null && TObjects.equals(entry.getValue(), oEntry.getValue())) {
                this.associatedMap.removeByKey(entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof TMap.Entry) {
                TMap.Entry oEntry = (TMap.Entry)object;
                HashEntry<K, V> entry = this.associatedMap.entryByKey(oEntry.getKey());
                return entry != null && TObjects.equals(entry.getValue(), oEntry.getValue());
            }
            return false;
        }

        @Override
        public TIterator<TMap.Entry<K, V>> iterator() {
            return new EntryIterator<K, V>(this.associatedMap);
        }

        @Override
        public void forEach(Consumer<? super TMap.Entry<K, V>> action) {
            if (this.associatedMap.elementCount > 0) {
                int prevModCount = this.associatedMap.modCount;
                for (int i = 0; i < this.associatedMap.elementData.length; ++i) {
                    HashEntry entry = this.associatedMap.elementData[i];
                    while (entry != null) {
                        action.accept(entry);
                        entry = entry.next;
                        if (prevModCount == this.associatedMap.modCount) continue;
                        throw new TConcurrentModificationException();
                    }
                }
            }
        }
    }

    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<V> {
        ValueIterator(THashMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<K> {
        KeyIterator(THashMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<TMap.Entry<K, V>> {
        EntryIterator(THashMap<K, V> map) {
            super(map);
        }

        @Override
        public TMap.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private static class AbstractMapIterator<K, V> {
        private int position;
        int expectedModCount;
        HashEntry<K, V> futureEntry;
        HashEntry<K, V> currentEntry;
        HashEntry<K, V> prevEntry;
        final THashMap<K, V> associatedMap;

        AbstractMapIterator(THashMap<K, V> hm) {
            this.associatedMap = hm;
            this.expectedModCount = hm.modCount;
            this.futureEntry = null;
        }

        public boolean hasNext() {
            if (this.futureEntry != null) {
                return true;
            }
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        final void checkConcurrentMod() throws TConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new TConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new TNoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = this.associatedMap.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new TIllegalStateException();
            }
            if (this.prevEntry == null) {
                int index = this.currentEntry.origKeyHash & this.associatedMap.elementData.length - 1;
                this.associatedMap.elementData[index] = this.associatedMap.elementData[index].next;
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++this.associatedMap.modCount;
            --this.associatedMap.elementCount;
        }
    }
}

